# coding: utf-8

"""
    QAnswer: Api Documentation

    APIs provided by QAnswer

    The version of the OpenAPI document: 1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from qanswer_sdk.models.aggregations_group import AggregationsGroup
from qanswer_sdk.models.search_metadata_filter import SearchMetadataFilter
from qanswer_sdk.models.source import Source
from typing import Optional, Set
from typing_extensions import Self

class RAGResponse(BaseModel):
    """
    RAGResponse
    """ # noqa: E501
    conversation_id: StrictStr = Field(description="Unique identifier for the conversation.")
    message_id: StrictStr = Field(description="Unique identifier for the generated response.")
    ai_response: StrictStr = Field(description="The response generated by the AI model.")
    sources: Optional[List[Source]] = Field(default=None, description="List of relevant sources cited in the response.")
    all_sources: Optional[List[Source]] = Field(default=None, description="Comprehensive list of all sources used in the prompt.")
    finish_reason: Optional[StrictStr] = Field(default=None, description="Reason the model stopped: stop, length, or content_filter.")
    is_regenerate: Optional[StrictBool] = Field(default=None, description="Specifies whether the response was regenerated.")
    aggs: Optional[List[AggregationsGroup]] = Field(default=None, description="Aggregations response containing additional metadata or statistics related to the response.")
    filters: Optional[List[SearchMetadataFilter]] = Field(default=None, description="Filters response containing additional metadata or statistics related to the response.")
    is_input_data_cropped: Optional[StrictBool] = Field(default=None, description="Indicates whether the input data was cropped during prompting.")
    mode: Optional[StrictStr] = Field(default=None, description="The mode of the response generation.")
    prompt_used: Optional[StrictStr] = Field(default=None, description="The actual prompt used for generation by the model.")
    prompt_type: Optional[StrictStr] = Field(default=None, description="The type of prompt used for generation by the model.")
    __properties: ClassVar[List[str]] = ["conversation_id", "message_id", "ai_response", "sources", "all_sources", "finish_reason", "is_regenerate", "aggs", "filters", "is_input_data_cropped", "mode", "prompt_used", "prompt_type"]

    @field_validator('mode')
    def mode_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['rag', 'full-context']):
            raise ValueError("must be one of enum values ('rag', 'full-context')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of RAGResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in sources (list)
        _items = []
        if self.sources:
            for _item_sources in self.sources:
                if _item_sources:
                    _items.append(_item_sources.to_dict())
            _dict['sources'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in all_sources (list)
        _items = []
        if self.all_sources:
            for _item_all_sources in self.all_sources:
                if _item_all_sources:
                    _items.append(_item_all_sources.to_dict())
            _dict['all_sources'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in aggs (list)
        _items = []
        if self.aggs:
            for _item_aggs in self.aggs:
                if _item_aggs:
                    _items.append(_item_aggs.to_dict())
            _dict['aggs'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in filters (list)
        _items = []
        if self.filters:
            for _item_filters in self.filters:
                if _item_filters:
                    _items.append(_item_filters.to_dict())
            _dict['filters'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of RAGResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "conversation_id": obj.get("conversation_id"),
            "message_id": obj.get("message_id"),
            "ai_response": obj.get("ai_response"),
            "sources": [Source.from_dict(_item) for _item in obj["sources"]] if obj.get("sources") is not None else None,
            "all_sources": [Source.from_dict(_item) for _item in obj["all_sources"]] if obj.get("all_sources") is not None else None,
            "finish_reason": obj.get("finish_reason"),
            "is_regenerate": obj.get("is_regenerate"),
            "aggs": [AggregationsGroup.from_dict(_item) for _item in obj["aggs"]] if obj.get("aggs") is not None else None,
            "filters": [SearchMetadataFilter.from_dict(_item) for _item in obj["filters"]] if obj.get("filters") is not None else None,
            "is_input_data_cropped": obj.get("is_input_data_cropped"),
            "mode": obj.get("mode"),
            "prompt_used": obj.get("prompt_used"),
            "prompt_type": obj.get("prompt_type")
        })
        return _obj


