# coding: utf-8

"""
    QAnswer: Api Documentation

    APIs provided by QAnswer

    The version of the OpenAPI document: 1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictStr
from typing import Any, ClassVar, Dict, List
from qanswer_sdk.models.relation_model import RelationModel
from qanswer_sdk.models.subject_model import SubjectModel
from typing import Optional, Set
from typing_extensions import Self

class RelationExtractionPayload(BaseModel):
    """
    RelationExtractionPayload
    """ # noqa: E501
    subject_entities: List[SubjectModel]
    relations: List[RelationModel]
    username: StrictStr
    dataset: StrictStr
    conversation_id: StrictStr
    __properties: ClassVar[List[str]] = ["subject_entities", "relations", "username", "dataset", "conversation_id"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of RelationExtractionPayload from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in subject_entities (list)
        _items = []
        if self.subject_entities:
            for _item_subject_entities in self.subject_entities:
                if _item_subject_entities:
                    _items.append(_item_subject_entities.to_dict())
            _dict['subject_entities'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in relations (list)
        _items = []
        if self.relations:
            for _item_relations in self.relations:
                if _item_relations:
                    _items.append(_item_relations.to_dict())
            _dict['relations'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of RelationExtractionPayload from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "subject_entities": [SubjectModel.from_dict(_item) for _item in obj["subject_entities"]] if obj.get("subject_entities") is not None else None,
            "relations": [RelationModel.from_dict(_item) for _item in obj["relations"]] if obj.get("relations") is not None else None,
            "username": obj.get("username"),
            "dataset": obj.get("dataset"),
            "conversation_id": obj.get("conversation_id")
        })
        return _obj


