# coding: utf-8

"""
    QAnswer: Api Documentation

    APIs provided by QAnswer

    The version of the OpenAPI document: 1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from qanswer_sdk.models.search_metadata_filter import SearchMetadataFilter
from typing import Optional, Set
from typing_extensions import Self

class SearchIndexPayload(BaseModel):
    """
    SearchIndexPayload
    """ # noqa: E501
    username: StrictStr
    dataset: StrictStr
    connector_id: StrictInt
    query: StrictStr
    oauth_token: Optional[StrictStr] = None
    filters: Optional[List[List[SearchMetadataFilter]]] = None
    limit: Optional[StrictInt] = None
    offset: Optional[StrictInt] = None
    __properties: ClassVar[List[str]] = ["username", "dataset", "connector_id", "query", "oauth_token", "filters", "limit", "offset"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of SearchIndexPayload from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in filters (list of list)
        _items = []
        if self.filters:
            for _item_filters in self.filters:
                if _item_filters:
                    _items.append(
                         [_inner_item.to_dict() for _inner_item in _item_filters if _inner_item is not None]
                    )
            _dict['filters'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of SearchIndexPayload from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "username": obj.get("username"),
            "dataset": obj.get("dataset"),
            "connector_id": obj.get("connector_id"),
            "query": obj.get("query"),
            "oauth_token": obj.get("oauth_token"),
            "filters": [
                    [SearchMetadataFilter.from_dict(_inner_item) for _inner_item in _item]
                    for _item in obj["filters"]
                ] if obj.get("filters") is not None else None,
            "limit": obj.get("limit"),
            "offset": obj.get("offset")
        })
        return _obj


