# coding: utf-8

"""
    QAnswer: Api Documentation

    APIs provided by QAnswer

    The version of the OpenAPI document: 1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from qanswer_sdk.models.search_metadata_filter import SearchMetadataFilter
from typing import Optional, Set
from typing_extensions import Self

class SearchPayload(BaseModel):
    """
    SearchPayload
    """ # noqa: E501
    question: StrictStr
    username: StrictStr
    dataset: StrictStr
    auto_apply_filters: Optional[StrictBool] = None
    text_fragmentation: Optional[StrictBool] = None
    limit: Optional[StrictInt] = None
    offset: Optional[StrictInt] = None
    oauth_token: Optional[StrictStr] = None
    conversation_id: Optional[StrictStr] = None
    filters: Optional[List[List[SearchMetadataFilter]]] = None
    index_hashes: Optional[List[Dict[str, Any]]] = Field(default=None, description="The hashes of the indexes to be used for the response.")
    conversation_has_clip: Optional[StrictBool] = Field(default=None, description="Indicates whether the conversation has a clip associated with it.")
    dataset_id: Optional[StrictInt] = Field(default=None, description="The ID of the dataset to be used for the response.")
    __properties: ClassVar[List[str]] = ["question", "username", "dataset", "auto_apply_filters", "text_fragmentation", "limit", "offset", "oauth_token", "conversation_id", "filters", "index_hashes", "conversation_has_clip", "dataset_id"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of SearchPayload from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in filters (list of list)
        _items = []
        if self.filters:
            for _item_filters in self.filters:
                if _item_filters:
                    _items.append(
                         [_inner_item.to_dict() for _inner_item in _item_filters if _inner_item is not None]
                    )
            _dict['filters'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of SearchPayload from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "question": obj.get("question"),
            "username": obj.get("username"),
            "dataset": obj.get("dataset"),
            "auto_apply_filters": obj.get("auto_apply_filters"),
            "text_fragmentation": obj.get("text_fragmentation"),
            "limit": obj.get("limit"),
            "offset": obj.get("offset"),
            "oauth_token": obj.get("oauth_token"),
            "conversation_id": obj.get("conversation_id"),
            "filters": [
                    [SearchMetadataFilter.from_dict(_inner_item) for _inner_item in _item]
                    for _item in obj["filters"]
                ] if obj.get("filters") is not None else None,
            "index_hashes": obj.get("index_hashes"),
            "conversation_has_clip": obj.get("conversation_has_clip"),
            "dataset_id": obj.get("dataset_id")
        })
        return _obj


