# coding: utf-8

"""
    QAnswer: Api Documentation

    APIs provided by QAnswer

    The version of the OpenAPI document: 1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictFloat, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional, Union
from qanswer_sdk.models.source_metadata import SourceMetadata
from typing import Optional, Set
from typing_extensions import Self

class SocketFileMetadata(BaseModel):
    """
    SocketFileMetadata
    """ # noqa: E501
    file_id: StrictStr
    title: Optional[StrictStr] = None
    name: Optional[StrictStr] = None
    file_name: StrictStr
    display_name: Optional[StrictStr] = None
    original_file_name: StrictStr
    file_extension: StrictStr
    additional_fields: Dict[str, Any]
    author: Optional[StrictStr] = None
    subject: Optional[StrictStr] = None
    creator: Optional[StrictStr] = None
    last_modified_by: Optional[StrictStr] = None
    created_at: Optional[StrictStr] = None
    modified_at: Optional[StrictStr] = None
    category: Optional[StrictStr] = None
    comments: Optional[StrictStr] = None
    keywords: Optional[StrictStr] = None
    source_metadata: Optional[SourceMetadata] = None
    username: StrictStr = Field(description="Username of the dataset")
    dataset: StrictStr = Field(description="Name of the dataset")
    connector_id: StrictInt
    connector_name: StrictStr
    connector_type: StrictStr
    usage: Optional[StrictInt] = None
    status: StrictStr
    failure_reason: Optional[StrictStr] = None
    source: StrictStr
    source_type: Optional[StrictStr] = None
    weight: Optional[Union[StrictFloat, StrictInt]] = None
    mime_type: Optional[StrictStr] = None
    hashed_filename: Optional[StrictStr] = None
    size: Optional[StrictInt] = None
    do_ocr: Optional[StrictBool] = None
    do_llm: Optional[StrictBool] = None
    account_id: Optional[StrictStr] = None
    jwt: StrictStr = Field(description="JTW token for authentification to join the conversation.")
    api_key: Optional[StrictStr] = Field(default=None, description="Api ley for authentification to join the conversation.")
    __properties: ClassVar[List[str]] = ["file_id", "title", "name", "file_name", "display_name", "original_file_name", "file_extension", "additional_fields", "author", "subject", "creator", "last_modified_by", "created_at", "modified_at", "category", "comments", "keywords", "source_metadata", "username", "dataset", "connector_id", "connector_name", "connector_type", "usage", "status", "failure_reason", "source", "source_type", "weight", "mime_type", "hashed_filename", "size", "do_ocr", "do_llm", "account_id", "jwt", "api_key"]

    @field_validator('status')
    def status_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['Submitted', 'Uploaded', 'Converted', 'Indexed', 'QuotaExceeded', 'Failed', 'MalwareDetected', 'NeedsToBeUploaded']):
            raise ValueError("must be one of enum values ('Submitted', 'Uploaded', 'Converted', 'Indexed', 'QuotaExceeded', 'Failed', 'MalwareDetected', 'NeedsToBeUploaded')")
        return value

    @field_validator('failure_reason')
    def failure_reason_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['format_not_supported', 'file_empty', 'pdf_conversion_failed', 'embedding_failed', 'indexing_failed', 'quota_exceeded', 'illegal_filename', 'malware_detected', 'duplicate_filename', 'unknown_error', 'website_not_reachable', 'remote_file_rejected', 'other']):
            raise ValueError("must be one of enum values ('format_not_supported', 'file_empty', 'pdf_conversion_failed', 'embedding_failed', 'indexing_failed', 'quota_exceeded', 'illegal_filename', 'malware_detected', 'duplicate_filename', 'unknown_error', 'website_not_reachable', 'remote_file_rejected', 'other')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of SocketFileMetadata from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of source_metadata
        if self.source_metadata:
            _dict['source_metadata'] = self.source_metadata.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of SocketFileMetadata from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "file_id": obj.get("file_id"),
            "title": obj.get("title"),
            "name": obj.get("name"),
            "file_name": obj.get("file_name"),
            "display_name": obj.get("display_name"),
            "original_file_name": obj.get("original_file_name"),
            "file_extension": obj.get("file_extension"),
            "additional_fields": obj.get("additional_fields"),
            "author": obj.get("author"),
            "subject": obj.get("subject"),
            "creator": obj.get("creator"),
            "last_modified_by": obj.get("last_modified_by"),
            "created_at": obj.get("created_at"),
            "modified_at": obj.get("modified_at"),
            "category": obj.get("category"),
            "comments": obj.get("comments"),
            "keywords": obj.get("keywords"),
            "source_metadata": SourceMetadata.from_dict(obj["source_metadata"]) if obj.get("source_metadata") is not None else None,
            "username": obj.get("username"),
            "dataset": obj.get("dataset"),
            "connector_id": obj.get("connector_id"),
            "connector_name": obj.get("connector_name"),
            "connector_type": obj.get("connector_type"),
            "usage": obj.get("usage"),
            "status": obj.get("status"),
            "failure_reason": obj.get("failure_reason"),
            "source": obj.get("source"),
            "source_type": obj.get("source_type"),
            "weight": obj.get("weight"),
            "mime_type": obj.get("mime_type"),
            "hashed_filename": obj.get("hashed_filename"),
            "size": obj.get("size"),
            "do_ocr": obj.get("do_ocr"),
            "do_llm": obj.get("do_llm"),
            "account_id": obj.get("account_id"),
            "jwt": obj.get("jwt"),
            "api_key": obj.get("api_key")
        })
        return _obj


