# coding: utf-8

"""
    QAnswer: Api Documentation

    APIs provided by QAnswer

    The version of the OpenAPI document: 1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class SocketSpeech2TextResponse(BaseModel):
    """
    SocketSpeech2TextResponse
    """ # noqa: E501
    transcription: StrictStr
    username: StrictStr = Field(description="Username of the dataset")
    dataset: StrictStr = Field(description="Name of the dataset")
    jwt: StrictStr = Field(description="JTW token for authentification to join the conversation.")
    api_key: Optional[StrictStr] = Field(default=None, description="Api ley for authentification to join the conversation.")
    conversation_id: StrictStr = Field(description="ID of the conversation")
    user: Optional[StrictStr] = Field(default=None, description="User that is joining the conversation")
    __properties: ClassVar[List[str]] = ["transcription", "username", "dataset", "jwt", "api_key", "conversation_id", "user"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of SocketSpeech2TextResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of SocketSpeech2TextResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "transcription": obj.get("transcription"),
            "username": obj.get("username"),
            "dataset": obj.get("dataset"),
            "jwt": obj.get("jwt"),
            "api_key": obj.get("api_key"),
            "conversation_id": obj.get("conversation_id"),
            "user": obj.get("user")
        })
        return _obj


