# coding: utf-8

"""
    QAnswer: Api Documentation

    APIs provided by QAnswer

    The version of the OpenAPI document: 1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class SourceMetadata(BaseModel):
    """
    SourceMetadata
    """ # noqa: E501
    created_date_time: Optional[StrictStr] = Field(default=None, alias="createdDateTime")
    last_modified_date_time: Optional[StrictStr] = Field(default=None, alias="lastModifiedDateTime")
    id: Optional[StrictStr] = None
    name: Optional[StrictStr] = None
    size: Optional[StrictInt] = None
    web_url: Optional[StrictStr] = Field(default=None, alias="webUrl")
    display_name: Optional[StrictStr] = Field(default=None, alias="displayName")
    parent_reference: Optional[Dict[str, Any]] = Field(default=None, alias="parentReference")
    site_id: Optional[StrictStr] = None
    drive_id: Optional[StrictStr] = None
    path: Optional[StrictStr] = None
    file_type: Optional[StrictStr] = None
    __properties: ClassVar[List[str]] = ["createdDateTime", "lastModifiedDateTime", "id", "name", "size", "webUrl", "displayName", "parentReference", "site_id", "drive_id", "path", "file_type"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of SourceMetadata from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of SourceMetadata from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "createdDateTime": obj.get("createdDateTime"),
            "lastModifiedDateTime": obj.get("lastModifiedDateTime"),
            "id": obj.get("id"),
            "name": obj.get("name"),
            "size": obj.get("size"),
            "webUrl": obj.get("webUrl"),
            "displayName": obj.get("displayName"),
            "parentReference": obj.get("parentReference"),
            "site_id": obj.get("site_id"),
            "drive_id": obj.get("drive_id"),
            "path": obj.get("path"),
            "file_type": obj.get("file_type")
        })
        return _obj


