# coding: utf-8

"""
    QAnswer: Api Documentation

    APIs provided by QAnswer

    The version of the OpenAPI document: 1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictFloat, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional, Union
from qanswer_sdk.models.organization_admin import OrganizationAdmin
from qanswer_sdk.models.role import Role
from qanswer_sdk.models.team_admin import TeamAdmin
from typing import Optional, Set
from typing_extensions import Self

class UserProfileDto(BaseModel):
    """
    UserProfileDto
    """ # noqa: E501
    id: Optional[StrictInt] = None
    username: Optional[StrictStr] = None
    name: Optional[StrictStr] = None
    created: Optional[datetime] = None
    last_login: Optional[datetime] = Field(default=None, alias="lastLogin")
    quota_dataset_number: Optional[StrictInt] = Field(default=None, alias="quotaDatasetNumber")
    quota_dataset_number_used: Optional[StrictInt] = Field(default=None, alias="quotaDatasetNumberUsed")
    quota_dataset_space_mb: Optional[StrictInt] = Field(default=None, alias="quotaDatasetSpaceMb")
    quota_dataset_space_mb_used: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="quotaDatasetSpaceMbUsed")
    question_credits_start: Optional[datetime] = Field(default=None, alias="questionCreditsStart")
    quota_question_credits: Optional[StrictInt] = Field(default=None, alias="quotaQuestionCredits")
    quota_question_credits_used: Optional[StrictInt] = Field(default=None, alias="quotaQuestionCreditsUsed")
    quota_input_tokens: Optional[StrictInt] = Field(default=None, alias="quotaInputTokens")
    quota_output_tokens: Optional[StrictInt] = Field(default=None, alias="quotaOutputTokens")
    input_tokens_used: Optional[StrictInt] = Field(default=None, alias="inputTokensUsed")
    output_tokens_used: Optional[StrictInt] = Field(default=None, alias="outputTokensUsed")
    role: Optional[List[Role]] = None
    pricing_plan: Optional[StrictStr] = Field(default=None, alias="pricingPlan")
    data_package: Optional[StrictInt] = Field(default=None, alias="dataPackage")
    pricing_plan_subscription: Optional[datetime] = Field(default=None, alias="pricingPlanSubscription")
    activated: Optional[StrictBool] = None
    blocked: Optional[StrictBool] = None
    language: Optional[StrictStr] = None
    teams: Optional[List[TeamAdmin]] = None
    organizations: Optional[List[OrganizationAdmin]] = None
    origin: Optional[StrictStr] = None
    email: Optional[StrictStr] = None
    __properties: ClassVar[List[str]] = ["id", "username", "name", "created", "lastLogin", "quotaDatasetNumber", "quotaDatasetNumberUsed", "quotaDatasetSpaceMb", "quotaDatasetSpaceMbUsed", "questionCreditsStart", "quotaQuestionCredits", "quotaQuestionCreditsUsed", "quotaInputTokens", "quotaOutputTokens", "inputTokensUsed", "outputTokensUsed", "role", "pricingPlan", "dataPackage", "pricingPlanSubscription", "activated", "blocked", "language", "teams", "organizations", "origin", "email"]

    @field_validator('pricing_plan')
    def pricing_plan_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['NOT_LOGGED', 'FREE', 'BASIC', 'BASIC_DOLLAR', 'BASIC_ANNUAL', 'BASIC_ANNUAL_DOLLAR', 'PROFESSIONAL', 'PROFESSIONAL_DOLLAR', 'PROFESSIONAL_ANNUAL', 'PROFESSIONAL_ANNUAL_DOLLAR', 'CUSTOM', 'UNLIMITED']):
            raise ValueError("must be one of enum values ('NOT_LOGGED', 'FREE', 'BASIC', 'BASIC_DOLLAR', 'BASIC_ANNUAL', 'BASIC_ANNUAL_DOLLAR', 'PROFESSIONAL', 'PROFESSIONAL_DOLLAR', 'PROFESSIONAL_ANNUAL', 'PROFESSIONAL_ANNUAL_DOLLAR', 'CUSTOM', 'UNLIMITED')")
        return value

    @field_validator('language')
    def language_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['en', 'fr']):
            raise ValueError("must be one of enum values ('en', 'fr')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of UserProfileDto from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in role (list)
        _items = []
        if self.role:
            for _item_role in self.role:
                if _item_role:
                    _items.append(_item_role.to_dict())
            _dict['role'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in teams (list)
        _items = []
        if self.teams:
            for _item_teams in self.teams:
                if _item_teams:
                    _items.append(_item_teams.to_dict())
            _dict['teams'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in organizations (list)
        _items = []
        if self.organizations:
            for _item_organizations in self.organizations:
                if _item_organizations:
                    _items.append(_item_organizations.to_dict())
            _dict['organizations'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of UserProfileDto from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "username": obj.get("username"),
            "name": obj.get("name"),
            "created": obj.get("created"),
            "lastLogin": obj.get("lastLogin"),
            "quotaDatasetNumber": obj.get("quotaDatasetNumber"),
            "quotaDatasetNumberUsed": obj.get("quotaDatasetNumberUsed"),
            "quotaDatasetSpaceMb": obj.get("quotaDatasetSpaceMb"),
            "quotaDatasetSpaceMbUsed": obj.get("quotaDatasetSpaceMbUsed"),
            "questionCreditsStart": obj.get("questionCreditsStart"),
            "quotaQuestionCredits": obj.get("quotaQuestionCredits"),
            "quotaQuestionCreditsUsed": obj.get("quotaQuestionCreditsUsed"),
            "quotaInputTokens": obj.get("quotaInputTokens"),
            "quotaOutputTokens": obj.get("quotaOutputTokens"),
            "inputTokensUsed": obj.get("inputTokensUsed"),
            "outputTokensUsed": obj.get("outputTokensUsed"),
            "role": [Role.from_dict(_item) for _item in obj["role"]] if obj.get("role") is not None else None,
            "pricingPlan": obj.get("pricingPlan"),
            "dataPackage": obj.get("dataPackage"),
            "pricingPlanSubscription": obj.get("pricingPlanSubscription"),
            "activated": obj.get("activated"),
            "blocked": obj.get("blocked"),
            "language": obj.get("language"),
            "teams": [TeamAdmin.from_dict(_item) for _item in obj["teams"]] if obj.get("teams") is not None else None,
            "organizations": [OrganizationAdmin.from_dict(_item) for _item in obj["organizations"]] if obj.get("organizations") is not None else None,
            "origin": obj.get("origin"),
            "email": obj.get("email")
        })
        return _obj


