# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from ..types.action_response import ActionResponse
from ..types.response_browser_info_result import ResponseBrowserInfoResult
from .raw_client import AsyncRawBrowserClient, RawBrowserClient
from .types.action import Action

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class BrowserClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawBrowserClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawBrowserClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawBrowserClient
        """
        return self._raw_client

    def get_browser_info(self, *, request_options: typing.Optional[RequestOptions] = None) -> ResponseBrowserInfoResult:
        """
        Get information about browser, like cdp url, viewport size, etc.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ResponseBrowserInfoResult
            Successful Response

        Examples
        --------
        from agent_sandbox import Sandbox

        client = Sandbox(
            base_url="https://yourhost.com/path/to/api",
        )
        client.browser.get_browser_info()
        """
        _response = self._raw_client.get_browser_info(request_options=request_options)
        return _response.data

    def take_screenshot(self, *, request_options: typing.Optional[RequestOptions] = None) -> typing.Iterator[bytes]:
        """
        Take a screenshot of the current display.

        Returns:
            StreamingResponse: PNG image data with proper headers

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration. You can pass in configuration such as `chunk_size`, and more to customize the request and response.

        Returns
        -------
        typing.Iterator[bytes]
            Screenshot image
        """
        with self._raw_client.take_screenshot(request_options=request_options) as r:
            yield from r.data

    def execute_action(
        self, *, request: Action, request_options: typing.Optional[RequestOptions] = None
    ) -> ActionResponse:
        """
        Execute a validated action on the current display.

        Parameters
        ----------
        request : Action

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ActionResponse
            Successful Response

        Examples
        --------
        from agent_sandbox import Sandbox
        from agent_sandbox.browser import Action_MoveTo

        client = Sandbox(
            base_url="https://yourhost.com/path/to/api",
        )
        client.browser.execute_action(
            request=Action_MoveTo(
                x=1.1,
                y=1.1,
            ),
        )
        """
        _response = self._raw_client.execute_action(request=request, request_options=request_options)
        return _response.data


class AsyncBrowserClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawBrowserClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawBrowserClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawBrowserClient
        """
        return self._raw_client

    async def get_browser_info(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> ResponseBrowserInfoResult:
        """
        Get information about browser, like cdp url, viewport size, etc.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ResponseBrowserInfoResult
            Successful Response

        Examples
        --------
        import asyncio

        from agent_sandbox import AsyncSandbox

        client = AsyncSandbox(
            base_url="https://yourhost.com/path/to/api",
        )


        async def main() -> None:
            await client.browser.get_browser_info()


        asyncio.run(main())
        """
        _response = await self._raw_client.get_browser_info(request_options=request_options)
        return _response.data

    async def take_screenshot(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> typing.AsyncIterator[bytes]:
        """
        Take a screenshot of the current display.

        Returns:
            StreamingResponse: PNG image data with proper headers

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration. You can pass in configuration such as `chunk_size`, and more to customize the request and response.

        Returns
        -------
        typing.AsyncIterator[bytes]
            Screenshot image
        """
        async with self._raw_client.take_screenshot(request_options=request_options) as r:
            async for _chunk in r.data:
                yield _chunk

    async def execute_action(
        self, *, request: Action, request_options: typing.Optional[RequestOptions] = None
    ) -> ActionResponse:
        """
        Execute a validated action on the current display.

        Parameters
        ----------
        request : Action

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ActionResponse
            Successful Response

        Examples
        --------
        import asyncio

        from agent_sandbox import AsyncSandbox
        from agent_sandbox.browser import Action_MoveTo

        client = AsyncSandbox(
            base_url="https://yourhost.com/path/to/api",
        )


        async def main() -> None:
            await client.browser.execute_action(
                request=Action_MoveTo(
                    x=1.1,
                    y=1.1,
                ),
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.execute_action(request=request, request_options=request_options)
        return _response.data
