# This file was auto-generated by Fern from our API Definition.

from __future__ import annotations

import typing

import httpx
from .core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from .core.request_options import RequestOptions
from .raw_client import AsyncRawSandbox, RawSandbox

if typing.TYPE_CHECKING:
    from .browser.client import AsyncBrowserClient, BrowserClient
    from .file.client import AsyncFileClient, FileClient
    from .jupyter.client import AsyncJupyterClient, JupyterClient
    from .mcp.client import AsyncMcpClient, McpClient
    from .nodejs.client import AsyncNodejsClient, NodejsClient
    from .sandbox.client import AsyncSandboxClient, SandboxClient
    from .shell.client import AsyncShellClient, ShellClient


class Sandbox:
    """
    Use this class to access the different functions within the SDK. You can instantiate any number of clients with different configuration that will propagate to these functions.

    Parameters
    ----------
    base_url : str
        The base url to use for requests from the client.

    headers : typing.Optional[typing.Dict[str, str]]
        Additional headers to send with every request.

    timeout : typing.Optional[float]
        The timeout to be used, in seconds, for requests. By default the timeout is 60 seconds, unless a custom httpx client is used, in which case this default is not enforced.

    follow_redirects : typing.Optional[bool]
        Whether the default httpx client follows redirects or not, this is irrelevant if a custom httpx client is passed in.

    httpx_client : typing.Optional[httpx.Client]
        The httpx client to use for making requests, a preconfigured client is used by default, however this is useful should you want to pass in any custom httpx configuration.

    Examples
    --------
    from agent_sandbox import Sandbox

    client = Sandbox(
        base_url="https://yourhost.com/path/to/api",
    )
    """

    def __init__(
        self,
        *,
        base_url: str,
        headers: typing.Optional[typing.Dict[str, str]] = None,
        timeout: typing.Optional[float] = None,
        follow_redirects: typing.Optional[bool] = True,
        httpx_client: typing.Optional[httpx.Client] = None,
    ):
        _defaulted_timeout = (
            timeout if timeout is not None else 60 if httpx_client is None else httpx_client.timeout.read
        )
        self._client_wrapper = SyncClientWrapper(
            base_url=base_url,
            headers=headers,
            httpx_client=httpx_client
            if httpx_client is not None
            else httpx.Client(timeout=_defaulted_timeout, follow_redirects=follow_redirects)
            if follow_redirects is not None
            else httpx.Client(timeout=_defaulted_timeout),
            timeout=_defaulted_timeout,
        )
        self._raw_client = RawSandbox(client_wrapper=self._client_wrapper)
        self._sandbox: typing.Optional[SandboxClient] = None
        self._shell: typing.Optional[ShellClient] = None
        self._file: typing.Optional[FileClient] = None
        self._jupyter: typing.Optional[JupyterClient] = None
        self._nodejs: typing.Optional[NodejsClient] = None
        self._mcp: typing.Optional[McpClient] = None
        self._browser: typing.Optional[BrowserClient] = None

    @property
    def with_raw_response(self) -> RawSandbox:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawSandbox
        """
        return self._raw_client

    def serve_terminal_terminal_get(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> typing.Optional[typing.Any]:
        """
        Serve the terminal HTML page

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.Optional[typing.Any]
            Successful Response

        Examples
        --------
        from agent_sandbox import Sandbox

        client = Sandbox(
            base_url="https://yourhost.com/path/to/api",
        )
        client.serve_terminal_terminal_get()
        """
        _response = self._raw_client.serve_terminal_terminal_get(request_options=request_options)
        return _response.data

    @property
    def sandbox(self):
        if self._sandbox is None:
            from .sandbox.client import SandboxClient  # noqa: E402

            self._sandbox = SandboxClient(client_wrapper=self._client_wrapper)
        return self._sandbox

    @property
    def shell(self):
        if self._shell is None:
            from .shell.client import ShellClient  # noqa: E402

            self._shell = ShellClient(client_wrapper=self._client_wrapper)
        return self._shell

    @property
    def file(self):
        if self._file is None:
            from .file.client import FileClient  # noqa: E402

            self._file = FileClient(client_wrapper=self._client_wrapper)
        return self._file

    @property
    def jupyter(self):
        if self._jupyter is None:
            from .jupyter.client import JupyterClient  # noqa: E402

            self._jupyter = JupyterClient(client_wrapper=self._client_wrapper)
        return self._jupyter

    @property
    def nodejs(self):
        if self._nodejs is None:
            from .nodejs.client import NodejsClient  # noqa: E402

            self._nodejs = NodejsClient(client_wrapper=self._client_wrapper)
        return self._nodejs

    @property
    def mcp(self):
        if self._mcp is None:
            from .mcp.client import McpClient  # noqa: E402

            self._mcp = McpClient(client_wrapper=self._client_wrapper)
        return self._mcp

    @property
    def browser(self):
        if self._browser is None:
            from .browser.client import BrowserClient  # noqa: E402

            self._browser = BrowserClient(client_wrapper=self._client_wrapper)
        return self._browser


class AsyncSandbox:
    """
    Use this class to access the different functions within the SDK. You can instantiate any number of clients with different configuration that will propagate to these functions.

    Parameters
    ----------
    base_url : str
        The base url to use for requests from the client.

    headers : typing.Optional[typing.Dict[str, str]]
        Additional headers to send with every request.

    timeout : typing.Optional[float]
        The timeout to be used, in seconds, for requests. By default the timeout is 60 seconds, unless a custom httpx client is used, in which case this default is not enforced.

    follow_redirects : typing.Optional[bool]
        Whether the default httpx client follows redirects or not, this is irrelevant if a custom httpx client is passed in.

    httpx_client : typing.Optional[httpx.AsyncClient]
        The httpx client to use for making requests, a preconfigured client is used by default, however this is useful should you want to pass in any custom httpx configuration.

    Examples
    --------
    from agent_sandbox import AsyncSandbox

    client = AsyncSandbox(
        base_url="https://yourhost.com/path/to/api",
    )
    """

    def __init__(
        self,
        *,
        base_url: str,
        headers: typing.Optional[typing.Dict[str, str]] = None,
        timeout: typing.Optional[float] = None,
        follow_redirects: typing.Optional[bool] = True,
        httpx_client: typing.Optional[httpx.AsyncClient] = None,
    ):
        _defaulted_timeout = (
            timeout if timeout is not None else 60 if httpx_client is None else httpx_client.timeout.read
        )
        self._client_wrapper = AsyncClientWrapper(
            base_url=base_url,
            headers=headers,
            httpx_client=httpx_client
            if httpx_client is not None
            else httpx.AsyncClient(timeout=_defaulted_timeout, follow_redirects=follow_redirects)
            if follow_redirects is not None
            else httpx.AsyncClient(timeout=_defaulted_timeout),
            timeout=_defaulted_timeout,
        )
        self._raw_client = AsyncRawSandbox(client_wrapper=self._client_wrapper)
        self._sandbox: typing.Optional[AsyncSandboxClient] = None
        self._shell: typing.Optional[AsyncShellClient] = None
        self._file: typing.Optional[AsyncFileClient] = None
        self._jupyter: typing.Optional[AsyncJupyterClient] = None
        self._nodejs: typing.Optional[AsyncNodejsClient] = None
        self._mcp: typing.Optional[AsyncMcpClient] = None
        self._browser: typing.Optional[AsyncBrowserClient] = None

    @property
    def with_raw_response(self) -> AsyncRawSandbox:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawSandbox
        """
        return self._raw_client

    async def serve_terminal_terminal_get(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> typing.Optional[typing.Any]:
        """
        Serve the terminal HTML page

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.Optional[typing.Any]
            Successful Response

        Examples
        --------
        import asyncio

        from agent_sandbox import AsyncSandbox

        client = AsyncSandbox(
            base_url="https://yourhost.com/path/to/api",
        )


        async def main() -> None:
            await client.serve_terminal_terminal_get()


        asyncio.run(main())
        """
        _response = await self._raw_client.serve_terminal_terminal_get(request_options=request_options)
        return _response.data

    @property
    def sandbox(self):
        if self._sandbox is None:
            from .sandbox.client import AsyncSandboxClient  # noqa: E402

            self._sandbox = AsyncSandboxClient(client_wrapper=self._client_wrapper)
        return self._sandbox

    @property
    def shell(self):
        if self._shell is None:
            from .shell.client import AsyncShellClient  # noqa: E402

            self._shell = AsyncShellClient(client_wrapper=self._client_wrapper)
        return self._shell

    @property
    def file(self):
        if self._file is None:
            from .file.client import AsyncFileClient  # noqa: E402

            self._file = AsyncFileClient(client_wrapper=self._client_wrapper)
        return self._file

    @property
    def jupyter(self):
        if self._jupyter is None:
            from .jupyter.client import AsyncJupyterClient  # noqa: E402

            self._jupyter = AsyncJupyterClient(client_wrapper=self._client_wrapper)
        return self._jupyter

    @property
    def nodejs(self):
        if self._nodejs is None:
            from .nodejs.client import AsyncNodejsClient  # noqa: E402

            self._nodejs = AsyncNodejsClient(client_wrapper=self._client_wrapper)
        return self._nodejs

    @property
    def mcp(self):
        if self._mcp is None:
            from .mcp.client import AsyncMcpClient  # noqa: E402

            self._mcp = AsyncMcpClient(client_wrapper=self._client_wrapper)
        return self._mcp

    @property
    def browser(self):
        if self._browser is None:
            from .browser.client import AsyncBrowserClient  # noqa: E402

            self._browser = AsyncBrowserClient(client_wrapper=self._client_wrapper)
        return self._browser
