import * as cdk from '@aws-cdk/core';
import * as cfn_parse from '@aws-cdk/core/lib/cfn-parse';
/**
 * Properties for defining a `AWS::Amplify::App`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-app.html
 */
export interface CfnAppProps {
    /**
     * `AWS::Amplify::App.Name`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-app.html#cfn-amplify-app-name
     */
    readonly name: string;
    /**
     * `AWS::Amplify::App.AccessToken`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-app.html#cfn-amplify-app-accesstoken
     */
    readonly accessToken?: string;
    /**
     * `AWS::Amplify::App.AutoBranchCreationConfig`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-app.html#cfn-amplify-app-autobranchcreationconfig
     */
    readonly autoBranchCreationConfig?: CfnApp.AutoBranchCreationConfigProperty | cdk.IResolvable;
    /**
     * `AWS::Amplify::App.BasicAuthConfig`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-app.html#cfn-amplify-app-basicauthconfig
     */
    readonly basicAuthConfig?: CfnApp.BasicAuthConfigProperty | cdk.IResolvable;
    /**
     * `AWS::Amplify::App.BuildSpec`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-app.html#cfn-amplify-app-buildspec
     */
    readonly buildSpec?: string;
    /**
     * `AWS::Amplify::App.CustomHeaders`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-app.html#cfn-amplify-app-customheaders
     */
    readonly customHeaders?: string;
    /**
     * `AWS::Amplify::App.CustomRules`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-app.html#cfn-amplify-app-customrules
     */
    readonly customRules?: Array<CfnApp.CustomRuleProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::Amplify::App.Description`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-app.html#cfn-amplify-app-description
     */
    readonly description?: string;
    /**
     * `AWS::Amplify::App.EnableBranchAutoDeletion`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-app.html#cfn-amplify-app-enablebranchautodeletion
     */
    readonly enableBranchAutoDeletion?: boolean | cdk.IResolvable;
    /**
     * `AWS::Amplify::App.EnvironmentVariables`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-app.html#cfn-amplify-app-environmentvariables
     */
    readonly environmentVariables?: Array<CfnApp.EnvironmentVariableProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::Amplify::App.IAMServiceRole`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-app.html#cfn-amplify-app-iamservicerole
     */
    readonly iamServiceRole?: string;
    /**
     * `AWS::Amplify::App.OauthToken`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-app.html#cfn-amplify-app-oauthtoken
     */
    readonly oauthToken?: string;
    /**
     * `AWS::Amplify::App.Repository`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-app.html#cfn-amplify-app-repository
     */
    readonly repository?: string;
    /**
     * `AWS::Amplify::App.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-app.html#cfn-amplify-app-tags
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::Amplify::App`.
 *
 * @external
 * @cloudformationResource AWS::Amplify::App
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-app.html
 */
export declare class CfnApp extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Amplify::App";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnApp;
    /**
     * @external
     * @cloudformationAttribute AppId
     */
    readonly attrAppId: string;
    /**
     * @external
     * @cloudformationAttribute AppName
     */
    readonly attrAppName: string;
    /**
     * @external
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * @external
     * @cloudformationAttribute DefaultDomain
     */
    readonly attrDefaultDomain: string;
    /**
     * `AWS::Amplify::App.Name`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-app.html#cfn-amplify-app-name
     */
    name: string;
    /**
     * `AWS::Amplify::App.AccessToken`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-app.html#cfn-amplify-app-accesstoken
     */
    accessToken: string | undefined;
    /**
     * `AWS::Amplify::App.AutoBranchCreationConfig`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-app.html#cfn-amplify-app-autobranchcreationconfig
     */
    autoBranchCreationConfig: CfnApp.AutoBranchCreationConfigProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::Amplify::App.BasicAuthConfig`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-app.html#cfn-amplify-app-basicauthconfig
     */
    basicAuthConfig: CfnApp.BasicAuthConfigProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::Amplify::App.BuildSpec`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-app.html#cfn-amplify-app-buildspec
     */
    buildSpec: string | undefined;
    /**
     * `AWS::Amplify::App.CustomHeaders`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-app.html#cfn-amplify-app-customheaders
     */
    customHeaders: string | undefined;
    /**
     * `AWS::Amplify::App.CustomRules`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-app.html#cfn-amplify-app-customrules
     */
    customRules: Array<CfnApp.CustomRuleProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::Amplify::App.Description`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-app.html#cfn-amplify-app-description
     */
    description: string | undefined;
    /**
     * `AWS::Amplify::App.EnableBranchAutoDeletion`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-app.html#cfn-amplify-app-enablebranchautodeletion
     */
    enableBranchAutoDeletion: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::Amplify::App.EnvironmentVariables`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-app.html#cfn-amplify-app-environmentvariables
     */
    environmentVariables: Array<CfnApp.EnvironmentVariableProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::Amplify::App.IAMServiceRole`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-app.html#cfn-amplify-app-iamservicerole
     */
    iamServiceRole: string | undefined;
    /**
     * `AWS::Amplify::App.OauthToken`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-app.html#cfn-amplify-app-oauthtoken
     */
    oauthToken: string | undefined;
    /**
     * `AWS::Amplify::App.Repository`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-app.html#cfn-amplify-app-repository
     */
    repository: string | undefined;
    /**
     * `AWS::Amplify::App.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-app.html#cfn-amplify-app-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::Amplify::App`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnAppProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::Amplify::App`.
 *
 * @external
 * @cloudformationResource AWS::Amplify::App
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-app.html
 */
export declare namespace CfnApp {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplify-app-autobranchcreationconfig.html
     */
    interface AutoBranchCreationConfigProperty {
        /**
         * `CfnApp.AutoBranchCreationConfigProperty.AutoBranchCreationPatterns`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplify-app-autobranchcreationconfig.html#cfn-amplify-app-autobranchcreationconfig-autobranchcreationpatterns
         */
        readonly autoBranchCreationPatterns?: string[];
        /**
         * `CfnApp.AutoBranchCreationConfigProperty.BasicAuthConfig`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplify-app-autobranchcreationconfig.html#cfn-amplify-app-autobranchcreationconfig-basicauthconfig
         */
        readonly basicAuthConfig?: CfnApp.BasicAuthConfigProperty | cdk.IResolvable;
        /**
         * `CfnApp.AutoBranchCreationConfigProperty.BuildSpec`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplify-app-autobranchcreationconfig.html#cfn-amplify-app-autobranchcreationconfig-buildspec
         */
        readonly buildSpec?: string;
        /**
         * `CfnApp.AutoBranchCreationConfigProperty.EnableAutoBranchCreation`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplify-app-autobranchcreationconfig.html#cfn-amplify-app-autobranchcreationconfig-enableautobranchcreation
         */
        readonly enableAutoBranchCreation?: boolean | cdk.IResolvable;
        /**
         * `CfnApp.AutoBranchCreationConfigProperty.EnableAutoBuild`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplify-app-autobranchcreationconfig.html#cfn-amplify-app-autobranchcreationconfig-enableautobuild
         */
        readonly enableAutoBuild?: boolean | cdk.IResolvable;
        /**
         * `CfnApp.AutoBranchCreationConfigProperty.EnablePerformanceMode`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplify-app-autobranchcreationconfig.html#cfn-amplify-app-autobranchcreationconfig-enableperformancemode
         */
        readonly enablePerformanceMode?: boolean | cdk.IResolvable;
        /**
         * `CfnApp.AutoBranchCreationConfigProperty.EnablePullRequestPreview`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplify-app-autobranchcreationconfig.html#cfn-amplify-app-autobranchcreationconfig-enablepullrequestpreview
         */
        readonly enablePullRequestPreview?: boolean | cdk.IResolvable;
        /**
         * `CfnApp.AutoBranchCreationConfigProperty.EnvironmentVariables`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplify-app-autobranchcreationconfig.html#cfn-amplify-app-autobranchcreationconfig-environmentvariables
         */
        readonly environmentVariables?: Array<CfnApp.EnvironmentVariableProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnApp.AutoBranchCreationConfigProperty.PullRequestEnvironmentName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplify-app-autobranchcreationconfig.html#cfn-amplify-app-autobranchcreationconfig-pullrequestenvironmentname
         */
        readonly pullRequestEnvironmentName?: string;
        /**
         * `CfnApp.AutoBranchCreationConfigProperty.Stage`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplify-app-autobranchcreationconfig.html#cfn-amplify-app-autobranchcreationconfig-stage
         */
        readonly stage?: string;
    }
}
/**
 * A CloudFormation `AWS::Amplify::App`.
 *
 * @external
 * @cloudformationResource AWS::Amplify::App
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-app.html
 */
export declare namespace CfnApp {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplify-app-basicauthconfig.html
     */
    interface BasicAuthConfigProperty {
        /**
         * `CfnApp.BasicAuthConfigProperty.EnableBasicAuth`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplify-app-basicauthconfig.html#cfn-amplify-app-basicauthconfig-enablebasicauth
         */
        readonly enableBasicAuth?: boolean | cdk.IResolvable;
        /**
         * `CfnApp.BasicAuthConfigProperty.Password`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplify-app-basicauthconfig.html#cfn-amplify-app-basicauthconfig-password
         */
        readonly password?: string;
        /**
         * `CfnApp.BasicAuthConfigProperty.Username`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplify-app-basicauthconfig.html#cfn-amplify-app-basicauthconfig-username
         */
        readonly username?: string;
    }
}
/**
 * A CloudFormation `AWS::Amplify::App`.
 *
 * @external
 * @cloudformationResource AWS::Amplify::App
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-app.html
 */
export declare namespace CfnApp {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplify-app-customrule.html
     */
    interface CustomRuleProperty {
        /**
         * `CfnApp.CustomRuleProperty.Condition`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplify-app-customrule.html#cfn-amplify-app-customrule-condition
         */
        readonly condition?: string;
        /**
         * `CfnApp.CustomRuleProperty.Source`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplify-app-customrule.html#cfn-amplify-app-customrule-source
         */
        readonly source: string;
        /**
         * `CfnApp.CustomRuleProperty.Status`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplify-app-customrule.html#cfn-amplify-app-customrule-status
         */
        readonly status?: string;
        /**
         * `CfnApp.CustomRuleProperty.Target`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplify-app-customrule.html#cfn-amplify-app-customrule-target
         */
        readonly target: string;
    }
}
/**
 * A CloudFormation `AWS::Amplify::App`.
 *
 * @external
 * @cloudformationResource AWS::Amplify::App
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-app.html
 */
export declare namespace CfnApp {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplify-app-environmentvariable.html
     */
    interface EnvironmentVariableProperty {
        /**
         * `CfnApp.EnvironmentVariableProperty.Name`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplify-app-environmentvariable.html#cfn-amplify-app-environmentvariable-name
         */
        readonly name: string;
        /**
         * `CfnApp.EnvironmentVariableProperty.Value`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplify-app-environmentvariable.html#cfn-amplify-app-environmentvariable-value
         */
        readonly value: string;
    }
}
/**
 * Properties for defining a `AWS::Amplify::Branch`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-branch.html
 */
export interface CfnBranchProps {
    /**
     * `AWS::Amplify::Branch.AppId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-branch.html#cfn-amplify-branch-appid
     */
    readonly appId: string;
    /**
     * `AWS::Amplify::Branch.BranchName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-branch.html#cfn-amplify-branch-branchname
     */
    readonly branchName: string;
    /**
     * `AWS::Amplify::Branch.BasicAuthConfig`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-branch.html#cfn-amplify-branch-basicauthconfig
     */
    readonly basicAuthConfig?: CfnBranch.BasicAuthConfigProperty | cdk.IResolvable;
    /**
     * `AWS::Amplify::Branch.BuildSpec`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-branch.html#cfn-amplify-branch-buildspec
     */
    readonly buildSpec?: string;
    /**
     * `AWS::Amplify::Branch.Description`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-branch.html#cfn-amplify-branch-description
     */
    readonly description?: string;
    /**
     * `AWS::Amplify::Branch.EnableAutoBuild`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-branch.html#cfn-amplify-branch-enableautobuild
     */
    readonly enableAutoBuild?: boolean | cdk.IResolvable;
    /**
     * `AWS::Amplify::Branch.EnablePerformanceMode`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-branch.html#cfn-amplify-branch-enableperformancemode
     */
    readonly enablePerformanceMode?: boolean | cdk.IResolvable;
    /**
     * `AWS::Amplify::Branch.EnablePullRequestPreview`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-branch.html#cfn-amplify-branch-enablepullrequestpreview
     */
    readonly enablePullRequestPreview?: boolean | cdk.IResolvable;
    /**
     * `AWS::Amplify::Branch.EnvironmentVariables`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-branch.html#cfn-amplify-branch-environmentvariables
     */
    readonly environmentVariables?: Array<CfnBranch.EnvironmentVariableProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::Amplify::Branch.PullRequestEnvironmentName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-branch.html#cfn-amplify-branch-pullrequestenvironmentname
     */
    readonly pullRequestEnvironmentName?: string;
    /**
     * `AWS::Amplify::Branch.Stage`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-branch.html#cfn-amplify-branch-stage
     */
    readonly stage?: string;
    /**
     * `AWS::Amplify::Branch.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-branch.html#cfn-amplify-branch-tags
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::Amplify::Branch`.
 *
 * @external
 * @cloudformationResource AWS::Amplify::Branch
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-branch.html
 */
export declare class CfnBranch extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Amplify::Branch";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnBranch;
    /**
     * @external
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * @external
     * @cloudformationAttribute BranchName
     */
    readonly attrBranchName: string;
    /**
     * `AWS::Amplify::Branch.AppId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-branch.html#cfn-amplify-branch-appid
     */
    appId: string;
    /**
     * `AWS::Amplify::Branch.BranchName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-branch.html#cfn-amplify-branch-branchname
     */
    branchName: string;
    /**
     * `AWS::Amplify::Branch.BasicAuthConfig`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-branch.html#cfn-amplify-branch-basicauthconfig
     */
    basicAuthConfig: CfnBranch.BasicAuthConfigProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::Amplify::Branch.BuildSpec`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-branch.html#cfn-amplify-branch-buildspec
     */
    buildSpec: string | undefined;
    /**
     * `AWS::Amplify::Branch.Description`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-branch.html#cfn-amplify-branch-description
     */
    description: string | undefined;
    /**
     * `AWS::Amplify::Branch.EnableAutoBuild`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-branch.html#cfn-amplify-branch-enableautobuild
     */
    enableAutoBuild: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::Amplify::Branch.EnablePerformanceMode`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-branch.html#cfn-amplify-branch-enableperformancemode
     */
    enablePerformanceMode: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::Amplify::Branch.EnablePullRequestPreview`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-branch.html#cfn-amplify-branch-enablepullrequestpreview
     */
    enablePullRequestPreview: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::Amplify::Branch.EnvironmentVariables`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-branch.html#cfn-amplify-branch-environmentvariables
     */
    environmentVariables: Array<CfnBranch.EnvironmentVariableProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::Amplify::Branch.PullRequestEnvironmentName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-branch.html#cfn-amplify-branch-pullrequestenvironmentname
     */
    pullRequestEnvironmentName: string | undefined;
    /**
     * `AWS::Amplify::Branch.Stage`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-branch.html#cfn-amplify-branch-stage
     */
    stage: string | undefined;
    /**
     * `AWS::Amplify::Branch.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-branch.html#cfn-amplify-branch-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::Amplify::Branch`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnBranchProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::Amplify::Branch`.
 *
 * @external
 * @cloudformationResource AWS::Amplify::Branch
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-branch.html
 */
export declare namespace CfnBranch {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplify-branch-basicauthconfig.html
     */
    interface BasicAuthConfigProperty {
        /**
         * `CfnBranch.BasicAuthConfigProperty.EnableBasicAuth`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplify-branch-basicauthconfig.html#cfn-amplify-branch-basicauthconfig-enablebasicauth
         */
        readonly enableBasicAuth?: boolean | cdk.IResolvable;
        /**
         * `CfnBranch.BasicAuthConfigProperty.Password`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplify-branch-basicauthconfig.html#cfn-amplify-branch-basicauthconfig-password
         */
        readonly password: string;
        /**
         * `CfnBranch.BasicAuthConfigProperty.Username`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplify-branch-basicauthconfig.html#cfn-amplify-branch-basicauthconfig-username
         */
        readonly username: string;
    }
}
/**
 * A CloudFormation `AWS::Amplify::Branch`.
 *
 * @external
 * @cloudformationResource AWS::Amplify::Branch
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-branch.html
 */
export declare namespace CfnBranch {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplify-branch-environmentvariable.html
     */
    interface EnvironmentVariableProperty {
        /**
         * `CfnBranch.EnvironmentVariableProperty.Name`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplify-branch-environmentvariable.html#cfn-amplify-branch-environmentvariable-name
         */
        readonly name: string;
        /**
         * `CfnBranch.EnvironmentVariableProperty.Value`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplify-branch-environmentvariable.html#cfn-amplify-branch-environmentvariable-value
         */
        readonly value: string;
    }
}
/**
 * Properties for defining a `AWS::Amplify::Domain`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-domain.html
 */
export interface CfnDomainProps {
    /**
     * `AWS::Amplify::Domain.AppId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-domain.html#cfn-amplify-domain-appid
     */
    readonly appId: string;
    /**
     * `AWS::Amplify::Domain.DomainName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-domain.html#cfn-amplify-domain-domainname
     */
    readonly domainName: string;
    /**
     * `AWS::Amplify::Domain.SubDomainSettings`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-domain.html#cfn-amplify-domain-subdomainsettings
     */
    readonly subDomainSettings: Array<CfnDomain.SubDomainSettingProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::Amplify::Domain.AutoSubDomainCreationPatterns`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-domain.html#cfn-amplify-domain-autosubdomaincreationpatterns
     */
    readonly autoSubDomainCreationPatterns?: string[];
    /**
     * `AWS::Amplify::Domain.AutoSubDomainIAMRole`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-domain.html#cfn-amplify-domain-autosubdomainiamrole
     */
    readonly autoSubDomainIamRole?: string;
    /**
     * `AWS::Amplify::Domain.EnableAutoSubDomain`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-domain.html#cfn-amplify-domain-enableautosubdomain
     */
    readonly enableAutoSubDomain?: boolean | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::Amplify::Domain`.
 *
 * @external
 * @cloudformationResource AWS::Amplify::Domain
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-domain.html
 */
export declare class CfnDomain extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Amplify::Domain";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnDomain;
    /**
     * @external
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * @external
     * @cloudformationAttribute AutoSubDomainCreationPatterns
     */
    readonly attrAutoSubDomainCreationPatterns: string[];
    /**
     * @external
     * @cloudformationAttribute AutoSubDomainIAMRole
     */
    readonly attrAutoSubDomainIamRole: string;
    /**
     * @external
     * @cloudformationAttribute CertificateRecord
     */
    readonly attrCertificateRecord: string;
    /**
     * @external
     * @cloudformationAttribute DomainName
     */
    readonly attrDomainName: string;
    /**
     * @external
     * @cloudformationAttribute DomainStatus
     */
    readonly attrDomainStatus: string;
    /**
     * @external
     * @cloudformationAttribute EnableAutoSubDomain
     */
    readonly attrEnableAutoSubDomain: cdk.IResolvable;
    /**
     * @external
     * @cloudformationAttribute StatusReason
     */
    readonly attrStatusReason: string;
    /**
     * `AWS::Amplify::Domain.AppId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-domain.html#cfn-amplify-domain-appid
     */
    appId: string;
    /**
     * `AWS::Amplify::Domain.DomainName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-domain.html#cfn-amplify-domain-domainname
     */
    domainName: string;
    /**
     * `AWS::Amplify::Domain.SubDomainSettings`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-domain.html#cfn-amplify-domain-subdomainsettings
     */
    subDomainSettings: Array<CfnDomain.SubDomainSettingProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::Amplify::Domain.AutoSubDomainCreationPatterns`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-domain.html#cfn-amplify-domain-autosubdomaincreationpatterns
     */
    autoSubDomainCreationPatterns: string[] | undefined;
    /**
     * `AWS::Amplify::Domain.AutoSubDomainIAMRole`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-domain.html#cfn-amplify-domain-autosubdomainiamrole
     */
    autoSubDomainIamRole: string | undefined;
    /**
     * `AWS::Amplify::Domain.EnableAutoSubDomain`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-domain.html#cfn-amplify-domain-enableautosubdomain
     */
    enableAutoSubDomain: boolean | cdk.IResolvable | undefined;
    /**
     * Create a new `AWS::Amplify::Domain`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnDomainProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::Amplify::Domain`.
 *
 * @external
 * @cloudformationResource AWS::Amplify::Domain
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-domain.html
 */
export declare namespace CfnDomain {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplify-domain-subdomainsetting.html
     */
    interface SubDomainSettingProperty {
        /**
         * `CfnDomain.SubDomainSettingProperty.BranchName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplify-domain-subdomainsetting.html#cfn-amplify-domain-subdomainsetting-branchname
         */
        readonly branchName: string;
        /**
         * `CfnDomain.SubDomainSettingProperty.Prefix`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplify-domain-subdomainsetting.html#cfn-amplify-domain-subdomainsetting-prefix
         */
        readonly prefix: string;
    }
}
