import * as codebuild from '@aws-cdk/aws-codebuild';
import * as iam from '@aws-cdk/aws-iam';
import { IResource, Resource, SecretValue } from '@aws-cdk/core';
import { Construct } from 'constructs';
import { BasicAuth } from './basic-auth';
import { Branch, BranchOptions } from './branch';
import { Domain, DomainOptions } from './domain';
/**
 * (experimental) An Amplify Console application.
 *
 * @experimental
 */
export interface IApp extends IResource {
    /**
     * (experimental) The application id.
     *
     * @experimental
     * @attribute true
     */
    readonly appId: string;
}
/**
 * (experimental) Configuration for the source code provider.
 *
 * @experimental
 */
export interface SourceCodeProviderConfig {
    /**
     * (experimental) The repository for the application.
     *
     * Must use the `HTTPS` protocol.
     *
     * @experimental
     * @example
     *
     * https://github.com/aws/aws-cdk
     */
    readonly repository: string;
    /**
     * (experimental) OAuth token for 3rd party source control system for an Amplify App, used to create webhook and read-only deploy key.
     *
     * OAuth token is not stored.
     *
     * Either `accessToken` or `oauthToken` must be specified if `repository`
     * is sepcified.
     *
     * @default - do not use a token
     * @experimental
     */
    readonly oauthToken?: SecretValue;
    /**
     * (experimental) Personal Access token for 3rd party source control system for an Amplify App, used to create webhook and read-only deploy key.
     *
     * Token is not stored.
     *
     * Either `accessToken` or `oauthToken` must be specified if `repository`
     * is sepcified.
     *
     * @default - do not use a token
     * @experimental
     */
    readonly accessToken?: SecretValue;
}
/**
 * (experimental) A source code provider.
 *
 * @experimental
 */
export interface ISourceCodeProvider {
    /**
     * (experimental) Binds the source code provider to an app.
     *
     * @param app The app [disable-awslint:ref-via-interface].
     * @experimental
     */
    bind(app: App): SourceCodeProviderConfig;
}
/**
 * (experimental) Properties for an App.
 *
 * @experimental
 */
export interface AppProps {
    /**
     * (experimental) The name for the application.
     *
     * @default - a CDK generated name
     * @experimental
     */
    readonly appName?: string;
    /**
     * (experimental) The source code provider for this application.
     *
     * @default - not connected to a source code provider
     * @experimental
     */
    readonly sourceCodeProvider?: ISourceCodeProvider;
    /**
     * (experimental) The auto branch creation configuration.
     *
     * Use this to automatically create
     * branches that match a certain pattern.
     *
     * @default - no auto branch creation
     * @experimental
     */
    readonly autoBranchCreation?: AutoBranchCreation;
    /**
     * (experimental) Automatically disconnect a branch in the Amplify Console when you delete a branch from your Git repository.
     *
     * @default false
     * @experimental
     */
    readonly autoBranchDeletion?: boolean;
    /**
     * (experimental) The Basic Auth configuration.
     *
     * Use this to set password protection at an
     * app level to all your branches.
     *
     * @default - no password protection
     * @experimental
     */
    readonly basicAuth?: BasicAuth;
    /**
     * (experimental) BuildSpec for the application.
     *
     * Alternatively, add a `amplify.yml`
     * file to the repository.
     *
     * @default - no build spec
     * @see https://docs.aws.amazon.com/amplify/latest/userguide/build-settings.html
     * @experimental
     */
    readonly buildSpec?: codebuild.BuildSpec;
    /**
     * (experimental) Custom rewrite/redirect rules for the application.
     *
     * @default - no custom rewrite/redirect rules
     * @experimental
     */
    readonly customRules?: CustomRule[];
    /**
     * (experimental) A description for the application.
     *
     * @default - no description
     * @experimental
     */
    readonly description?: string;
    /**
     * (experimental) Environment variables for the application.
     *
     * All environment variables that you add are encrypted to prevent rogue
     * access so you can use them to store secret information.
     *
     * @default - no environment variables
     * @experimental
     */
    readonly environmentVariables?: {
        [name: string]: string;
    };
    /**
     * (experimental) The IAM service role to associate with the application.
     *
     * The App
     * implements IGrantable.
     *
     * @default - a new role is created
     * @experimental
     */
    readonly role?: iam.IRole;
}
/**
 * (experimental) An Amplify Console application.
 *
 * @experimental
 */
export declare class App extends Resource implements IApp, iam.IGrantable {
    /**
     * (experimental) Import an existing application.
     *
     * @experimental
     */
    static fromAppId(scope: Construct, id: string, appId: string): IApp;
    /**
     * (experimental) The application id.
     *
     * @experimental
     */
    readonly appId: string;
    /**
     * (experimental) The name of the application.
     *
     * @experimental
     * @attribute true
     */
    readonly appName: string;
    /**
     * (experimental) The ARN of the application.
     *
     * @experimental
     * @attribute true
     */
    readonly arn: string;
    /**
     * (experimental) The default domain of the application.
     *
     * @experimental
     * @attribute true
     */
    readonly defaultDomain: string;
    /**
     * (experimental) The principal to grant permissions to.
     *
     * @experimental
     */
    readonly grantPrincipal: iam.IPrincipal;
    private readonly customRules;
    private readonly environmentVariables;
    private readonly autoBranchEnvironmentVariables;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: AppProps);
    /**
     * (experimental) Adds a custom rewrite/redirect rule to this application.
     *
     * @experimental
     */
    addCustomRule(rule: CustomRule): this;
    /**
     * (experimental) Adds an environment variable to this application.
     *
     * All environment variables that you add are encrypted to prevent rogue
     * access so you can use them to store secret information.
     *
     * @experimental
     */
    addEnvironment(name: string, value: string): this;
    /**
     * (experimental) Adds an environment variable to the auto created branch.
     *
     * All environment variables that you add are encrypted to prevent rogue
     * access so you can use them to store secret information.
     *
     * @experimental
     */
    addAutoBranchEnvironment(name: string, value: string): this;
    /**
     * (experimental) Adds a branch to this application.
     *
     * @experimental
     */
    addBranch(id: string, options?: BranchOptions): Branch;
    /**
     * (experimental) Adds a domain to this application.
     *
     * @experimental
     */
    addDomain(id: string, options?: DomainOptions): Domain;
}
/**
 * (experimental) Auto branch creation configuration.
 *
 * @experimental
 */
export interface AutoBranchCreation {
    /**
     * (experimental) Automated branch creation glob patterns.
     *
     * @default - all repository branches
     * @experimental
     */
    readonly patterns?: string[];
    /**
     * (experimental) The Basic Auth configuration.
     *
     * Use this to set password protection for
     * the auto created branch.
     *
     * @default - no password protection
     * @experimental
     */
    readonly basicAuth?: BasicAuth;
    /**
     * (experimental) Build spec for the auto created branch.
     *
     * @default - application build spec
     * @experimental
     */
    readonly buildSpec?: codebuild.BuildSpec;
    /**
     * (experimental) Whether to enable auto building for the auto created branch.
     *
     * @default true
     * @experimental
     */
    readonly autoBuild?: boolean;
    /**
     * (experimental) Whether to enable pull request preview for the auto created branch.
     *
     * @default true
     * @experimental
     */
    readonly pullRequestPreview?: boolean;
    /**
     * (experimental) Environment variables for the auto created branch.
     *
     * All environment variables that you add are encrypted to prevent rogue
     * access so you can use them to store secret information.
     *
     * @default - application environment variables
     * @experimental
     */
    readonly environmentVariables?: {
        [name: string]: string;
    };
    /**
     * (experimental) The dedicated backend environment for the pull request previews of the auto created branch.
     *
     * @default - automatically provision a temporary backend
     * @experimental
     */
    readonly pullRequestEnvironmentName?: string;
    /**
     * (experimental) Stage for the auto created branch.
     *
     * @default - no stage
     * @experimental
     */
    readonly stage?: string;
}
/**
 * (experimental) The status code for a URL rewrite or redirect rule.
 *
 * @experimental
 */
export declare enum RedirectStatus {
    /**
     * (experimental) Rewrite (200).
     *
     * @experimental
     */
    REWRITE = "200",
    /**
     * (experimental) Permanent redirect (301).
     *
     * @experimental
     */
    PERMANENT_REDIRECT = "301",
    /**
     * (experimental) Temporary redirect (302).
     *
     * @experimental
     */
    TEMPORARY_REDIRECT = "302",
    /**
     * (experimental) Not found (404).
     *
     * @experimental
     */
    NOT_FOUND = "404",
    /**
     * (experimental) Not found rewrite (404).
     *
     * @experimental
     */
    NOT_FOUND_REWRITE = "404-200"
}
/**
 * (experimental) Options for a custom rewrite/redirect rule for an Amplify App.
 *
 * @experimental
 */
export interface CustomRuleOptions {
    /**
     * (experimental) The source pattern for a URL rewrite or redirect rule.
     *
     * @see https://docs.aws.amazon.com/amplify/latest/userguide/redirects.html
     * @experimental
     */
    readonly source: string;
    /**
     * (experimental) The target pattern for a URL rewrite or redirect rule.
     *
     * @see https://docs.aws.amazon.com/amplify/latest/userguide/redirects.html
     * @experimental
     */
    readonly target: string;
    /**
     * (experimental) The status code for a URL rewrite or redirect rule.
     *
     * @default PERMANENT_REDIRECT
     * @see https://docs.aws.amazon.com/amplify/latest/userguide/redirects.html
     * @experimental
     */
    readonly status?: RedirectStatus;
    /**
     * (experimental) The condition for a URL rewrite or redirect rule, e.g. country code.
     *
     * @default - no condition
     * @see https://docs.aws.amazon.com/amplify/latest/userguide/redirects.html
     * @experimental
     */
    readonly condition?: string;
}
/**
 * (experimental) Custom rewrite/redirect rule for an Amplify App.
 *
 * @see https://docs.aws.amazon.com/amplify/latest/userguide/redirects.html
 * @experimental
 */
export declare class CustomRule {
    /**
     * (experimental) Sets up a 200 rewrite for all paths to `index.html` except for path containing a file extension.
     *
     * @experimental
     */
    static readonly SINGLE_PAGE_APPLICATION_REDIRECT: CustomRule;
    /**
     * (experimental) The source pattern for a URL rewrite or redirect rule.
     *
     * @see https://docs.aws.amazon.com/amplify/latest/userguide/redirects.html
     * @experimental
     */
    readonly source: string;
    /**
     * (experimental) The target pattern for a URL rewrite or redirect rule.
     *
     * @see https://docs.aws.amazon.com/amplify/latest/userguide/redirects.html
     * @experimental
     */
    readonly target: string;
    /**
     * (experimental) The status code for a URL rewrite or redirect rule.
     *
     * @default PERMANENT_REDIRECT
     * @see https://docs.aws.amazon.com/amplify/latest/userguide/redirects.html
     * @experimental
     */
    readonly status?: RedirectStatus;
    /**
     * (experimental) The condition for a URL rewrite or redirect rule, e.g. country code.
     *
     * @default - no condition
     * @see https://docs.aws.amazon.com/amplify/latest/userguide/redirects.html
     * @experimental
     */
    readonly condition?: string;
    /**
     * @experimental
     */
    constructor(options: CustomRuleOptions);
}
