import * as kms from '@aws-cdk/aws-kms';
import { SecretValue } from '@aws-cdk/core';
import { Construct as CoreConstruct } from '@aws-cdk/core';
/**
 * (experimental) Properties for a BasicAuth.
 *
 * @experimental
 */
export interface BasicAuthProps {
    /**
     * (experimental) The username.
     *
     * @experimental
     */
    readonly username: string;
    /**
     * (experimental) The password.
     *
     * @default - A Secrets Manager generated password
     * @experimental
     */
    readonly password?: SecretValue;
    /**
     * (experimental) The encryption key to use to encrypt the password when it's generated in Secrets Manager.
     *
     * @default - default master key
     * @experimental
     */
    readonly encryptionKey?: kms.IKey;
}
/**
 * (experimental) A Basic Auth configuration.
 *
 * @experimental
 */
export interface BasicAuthConfig {
    /**
     * (experimental) Whether to enable Basic Auth.
     *
     * @experimental
     */
    readonly enableBasicAuth: boolean;
    /**
     * (experimental) The username.
     *
     * @experimental
     */
    readonly username: string;
    /**
     * (experimental) The password.
     *
     * @experimental
     */
    readonly password: string;
}
/**
 * (experimental) Basic Auth configuration.
 *
 * @experimental
 */
export declare class BasicAuth {
    private readonly props;
    /**
     * (experimental) Creates a Basic Auth configuration from a username and a password.
     *
     * @param username The username.
     * @param password The password.
     * @experimental
     */
    static fromCredentials(username: string, password: SecretValue): BasicAuth;
    /**
     * (experimental) Creates a Basic Auth configuration with a password generated in Secrets Manager.
     *
     * @param username The username.
     * @param encryptionKey The encryption key to use to encrypt the password in Secrets Manager.
     * @experimental
     */
    static fromGeneratedPassword(username: string, encryptionKey?: kms.IKey): BasicAuth;
    /**
     * @experimental
     */
    constructor(props: BasicAuthProps);
    /**
     * (experimental) Binds this Basic Auth configuration to an App.
     *
     * @experimental
     */
    bind(scope: CoreConstruct, id: string): BasicAuthConfig;
}
