"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.BasicAuth = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const secretsmanager = require("@aws-cdk/aws-secretsmanager");
/**
 * (experimental) Basic Auth configuration.
 *
 * @experimental
 */
class BasicAuth {
    /**
     * @experimental
     */
    constructor(props) {
        this.props = props;
    }
    /**
     * (experimental) Creates a Basic Auth configuration from a username and a password.
     *
     * @param username The username.
     * @param password The password.
     * @experimental
     */
    static fromCredentials(username, password) {
        return new BasicAuth({ username, password });
    }
    /**
     * (experimental) Creates a Basic Auth configuration with a password generated in Secrets Manager.
     *
     * @param username The username.
     * @param encryptionKey The encryption key to use to encrypt the password in Secrets Manager.
     * @experimental
     */
    static fromGeneratedPassword(username, encryptionKey) {
        return new BasicAuth({ username, encryptionKey });
    }
    /**
     * (experimental) Binds this Basic Auth configuration to an App.
     *
     * @experimental
     */
    bind(scope, id) {
        const config = {
            enableBasicAuth: true,
            username: this.props.username,
        };
        if (this.props.password) {
            return {
                ...config,
                password: this.props.password.toString(),
            };
        }
        const secret = new secretsmanager.Secret(scope, id, {
            generateSecretString: {
                secretStringTemplate: JSON.stringify({ username: this.props.username }),
                generateStringKey: 'password',
            },
        });
        return {
            ...config,
            password: secret.secretValueFromJson('password').toString(),
        };
    }
}
exports.BasicAuth = BasicAuth;
_a = JSII_RTTI_SYMBOL_1;
BasicAuth[_a] = { fqn: "@aws-cdk/aws-amplify.BasicAuth", version: "1.108.1" };
//# sourceMappingURL=data:application/json;base64,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