"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Domain = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("@aws-cdk/core");
const amplify_generated_1 = require("./amplify.generated");
/**
 * (experimental) An Amplify Console domain.
 *
 * @experimental
 */
class Domain extends core_1.Resource {
    /**
     * @experimental
     */
    constructor(scope, id, props) {
        var _b;
        super(scope, id);
        this.subDomains = props.subDomains || [];
        const domainName = props.domainName || id;
        const domain = new amplify_generated_1.CfnDomain(this, 'Resource', {
            appId: props.app.appId,
            domainName,
            subDomainSettings: core_1.Lazy.any({ produce: () => this.renderSubDomainSettings() }, { omitEmptyArray: true }),
            enableAutoSubDomain: !!props.enableAutoSubdomain,
            autoSubDomainCreationPatterns: props.autoSubdomainCreationPatterns || ['*', 'pr*'],
            autoSubDomainIamRole: (_b = props.autoSubDomainIamRole) === null || _b === void 0 ? void 0 : _b.roleArn,
        });
        this.arn = domain.attrArn;
        this.certificateRecord = domain.attrCertificateRecord;
        this.domainName = domain.attrDomainName;
        this.domainStatus = domain.attrDomainStatus;
        this.statusReason = domain.attrStatusReason;
        this.domainAutoSubDomainCreationPatterns = domain.attrAutoSubDomainCreationPatterns;
        this.domainAutoSubDomainIamRole = domain.attrAutoSubDomainIamRole;
        this.domainEnableAutoSubDomain = domain.attrEnableAutoSubDomain;
    }
    /**
     * (experimental) Maps a branch to a sub domain.
     *
     * @param branch The branch.
     * @param prefix The prefix.
     * @experimental
     */
    mapSubDomain(branch, prefix) {
        this.subDomains.push({ branch, prefix });
        return this;
    }
    /**
     * (experimental) Maps a branch to the domain root.
     *
     * @experimental
     */
    mapRoot(branch) {
        return this.mapSubDomain(branch, '');
    }
    /**
     * (experimental) Validate the current construct.
     *
     * This method can be implemented by derived constructs in order to perform
     * validation logic. It is called on all constructs before synthesis.
     *
     * @experimental
     */
    validate() {
        if (this.subDomains.length === 0) {
            return ['The domain doesn\'t contain any subdomains'];
        }
        return [];
    }
    renderSubDomainSettings() {
        return this.subDomains.map(s => {
            var _b;
            return ({
                branchName: s.branch.branchName,
                prefix: (_b = s.prefix) !== null && _b !== void 0 ? _b : s.branch.branchName,
            });
        });
    }
}
exports.Domain = Domain;
_a = JSII_RTTI_SYMBOL_1;
Domain[_a] = { fqn: "@aws-cdk/aws-amplify.Domain", version: "1.108.1" };
//# sourceMappingURL=data:application/json;base64,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