"use strict";
var _a, _b, _c;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CodeCommitSourceCodeProvider = exports.GitLabSourceCodeProvider = exports.GitHubSourceCodeProvider = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * (experimental) GitHub source code provider.
 *
 * @experimental
 */
class GitHubSourceCodeProvider {
    /**
     * @experimental
     */
    constructor(props) {
        this.props = props;
    }
    /**
     * (experimental) Binds the source code provider to an app.
     *
     * @experimental
     */
    bind(_app) {
        return {
            repository: `https://github.com/${this.props.owner}/${this.props.repository}`,
            oauthToken: this.props.oauthToken,
        };
    }
}
exports.GitHubSourceCodeProvider = GitHubSourceCodeProvider;
_a = JSII_RTTI_SYMBOL_1;
GitHubSourceCodeProvider[_a] = { fqn: "@aws-cdk/aws-amplify.GitHubSourceCodeProvider", version: "1.108.1" };
/**
 * (experimental) GitLab source code provider.
 *
 * @experimental
 */
class GitLabSourceCodeProvider {
    /**
     * @experimental
     */
    constructor(props) {
        this.props = props;
    }
    /**
     * (experimental) Binds the source code provider to an app.
     *
     * @experimental
     */
    bind(_app) {
        return {
            repository: `https://gitlab.com/${this.props.owner}/${this.props.repository}`,
            oauthToken: this.props.oauthToken,
        };
    }
}
exports.GitLabSourceCodeProvider = GitLabSourceCodeProvider;
_b = JSII_RTTI_SYMBOL_1;
GitLabSourceCodeProvider[_b] = { fqn: "@aws-cdk/aws-amplify.GitLabSourceCodeProvider", version: "1.108.1" };
/**
 * (experimental) CodeCommit source code provider.
 *
 * @experimental
 */
class CodeCommitSourceCodeProvider {
    /**
     * @experimental
     */
    constructor(props) {
        this.props = props;
    }
    /**
     * (experimental) Binds the source code provider to an app.
     *
     * @experimental
     */
    bind(app) {
        this.props.repository.grantPull(app);
        return {
            repository: this.props.repository.repositoryCloneUrlHttp,
        };
    }
}
exports.CodeCommitSourceCodeProvider = CodeCommitSourceCodeProvider;
_c = JSII_RTTI_SYMBOL_1;
CodeCommitSourceCodeProvider[_c] = { fqn: "@aws-cdk/aws-amplify.CodeCommitSourceCodeProvider", version: "1.108.1" };
//# sourceMappingURL=data:application/json;base64,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