# EyeDentify3D: A Python package for gaze behavior classification of 3D eye-tracking data

<a href="https://opensource.org/licenses/MIT"><img src="https://img.shields.io/badge/license-MIT-success" alt="License"/></a>
[![Build status](https://github.com/EveCharbie/EyeDentify3d/actions/workflows/run_tests.yml/badge.svg)](https://github.com/EveCharbie/EyeDentify3d/actions)
[![codecov](https://codecov.io/gh/EveCharbie/EyeDentify3d/graph/badge.svg?token=BP4B2TCZXI)](https://codecov.io/gh/EveCharbie/EyeDentify3d)
[![DOI](https://zenodo.org/badge/821504006.svg)](https://doi.org/10.5281/zenodo.14718072)
[![Maintainability](https://qlty.sh/gh/EveCharbie/projects/EyeDentify3d/maintainability.svg)](https://qlty.sh/gh/EveCharbie/projects/EyeDentify3d)

## Installation
The easiest way to install `EyeDentify3D` is to use pip:
```bash
pip install eyedentify3d
```
or conda-forge:
```bash
conda install -c conda-forge eyedentify3d
```

If you prefer to install from source, you can clone the repository and create a conda environment with the required dependencies:
```bash
conda env create -f environment.yml
```

## Documentation
you can find the paper accompanying our JOSS submission [here](paper/paper.pdf) and a deeper documentation of the 
package features and underlying mathematical choices [here](https://evecharbie.github.io/EyeDentify3d).

## Examples
Examples of usage can be found in the [examples](examples/) directory.

