# This file is automatically generated by pyo3_stub_gen
# ruff: noqa: E501, F401

import builtins
import typing
from enum import Enum

class AxisDirectionPair:
    r"""
    An [`Axis`] paired with a [`Direction`].
    """
    ...

class Base64Data:
    r"""
    A container for binary that should be base64 encoded in serialisation. In reverse
    when deserializing, will decode from many different types of base64 possible.
    """
    ...

class CameraLookAt:
    def __new__(cls, vantage:Point3d, center:Point3d, up:Point3d) -> CameraLookAt: ...

class Discovered:
    r"""
    Specific discovered lint rule Violation of a particular Finding.
    """
    @property
    def finding(self) -> Finding: ...
    @property
    def description(self) -> builtins.str: ...
    @property
    def pos(self) -> tuple[builtins.int, builtins.int]: ...
    @property
    def overridden(self) -> builtins.bool: ...

class DxfExportOptions:
    r"""
    Options for exporting DXF format.
    """
    def __new__(cls) -> DxfExportOptions:
        r"""
        Set the options to their defaults.
        """

class ExportFile:
    r"""
    A file to be exported to the client.
    """
    @property
    def contents(self) -> builtins.list[builtins.int]: ...
    @property
    def name(self) -> builtins.str: ...

class FbxExportOptions:
    r"""
    Options for exporting FBX.
    """
    def __new__(cls) -> FbxExportOptions:
        r"""
        Set the options to their defaults.
        """

class FbxImportOptions:
    r"""
    Options for importing FBX.
    """
    def __new__(cls) -> FbxImportOptions:
        r"""
        Set the options to their defaults.
        """

class Finding:
    r"""
    Abstract lint problem type.
    """
    @property
    def code(self) -> builtins.str: ...
    @property
    def title(self) -> builtins.str: ...
    @property
    def description(self) -> builtins.str: ...
    @property
    def experimental(self) -> builtins.bool: ...

class GltfExportOptions:
    r"""
    Options for exporting glTF 2.0.
    """
    def __new__(cls) -> GltfExportOptions:
        r"""
        Set the options to their defaults.
        """

class GltfImportOptions:
    r"""
    Options for importing glTF 2.0.
    """
    def __new__(cls) -> GltfImportOptions:
        r"""
        Set the options to their defaults.
        """

class InputFormat3d:
    r"""
    Input format specifier.
    """
    class Fbx(InputFormat3d):
        r"""
        Autodesk Filmbox (FBX) format.
        """
        __match_args__ = ("_0",)
        @property
        def _0(self) -> FbxImportOptions: ...
        def __new__(cls, _0:FbxImportOptions) -> InputFormat3d.Fbx: ...
        def __len__(self) -> builtins.int: ...
        def __getitem__(self, key:builtins.int) -> typing.Any: ...
    
    class Gltf(InputFormat3d):
        r"""
        Binary glTF 2.0.
        We refer to this as glTF since that is how our customers refer to it,
        but this can also import binary glTF (glb).
        """
        __match_args__ = ("_0",)
        @property
        def _0(self) -> GltfImportOptions: ...
        def __new__(cls, _0:GltfImportOptions) -> InputFormat3d.Gltf: ...
        def __len__(self) -> builtins.int: ...
        def __getitem__(self, key:builtins.int) -> typing.Any: ...
    
    class Obj(InputFormat3d):
        r"""
        Wavefront OBJ format.
        """
        __match_args__ = ("_0",)
        @property
        def _0(self) -> ObjImportOptions: ...
        def __new__(cls, _0:ObjImportOptions) -> InputFormat3d.Obj: ...
        def __len__(self) -> builtins.int: ...
        def __getitem__(self, key:builtins.int) -> typing.Any: ...
    
    class Ply(InputFormat3d):
        r"""
        The PLY Polygon File Format.
        """
        __match_args__ = ("_0",)
        @property
        def _0(self) -> PlyImportOptions: ...
        def __new__(cls, _0:PlyImportOptions) -> InputFormat3d.Ply: ...
        def __len__(self) -> builtins.int: ...
        def __getitem__(self, key:builtins.int) -> typing.Any: ...
    
    class Sldprt(InputFormat3d):
        r"""
        SolidWorks part (SLDPRT) format.
        """
        __match_args__ = ("_0",)
        @property
        def _0(self) -> SldprtImportOptions: ...
        def __new__(cls, _0:SldprtImportOptions) -> InputFormat3d.Sldprt: ...
        def __len__(self) -> builtins.int: ...
        def __getitem__(self, key:builtins.int) -> typing.Any: ...
    
    class Step(InputFormat3d):
        r"""
        ISO 10303-21 (STEP) format.
        """
        __match_args__ = ("_0",)
        @property
        def _0(self) -> StepImportOptions: ...
        def __new__(cls, _0:StepImportOptions) -> InputFormat3d.Step: ...
        def __len__(self) -> builtins.int: ...
        def __getitem__(self, key:builtins.int) -> typing.Any: ...
    
    class Stl(InputFormat3d):
        r"""
        **ST**ereo**L**ithography format.
        """
        __match_args__ = ("_0",)
        @property
        def _0(self) -> StlImportOptions: ...
        def __new__(cls, _0:StlImportOptions) -> InputFormat3d.Stl: ...
        def __len__(self) -> builtins.int: ...
        def __getitem__(self, key:builtins.int) -> typing.Any: ...
    
    ...

class ObjExportOptions:
    r"""
    Options for exporting OBJ.
    """
    def __new__(cls) -> ObjExportOptions:
        r"""
        Set the options to their defaults.
        """

class ObjImportOptions:
    r"""
    Options for importing OBJ.
    """
    def __new__(cls) -> ObjImportOptions:
        r"""
        Set the options to their defaults.
        """

class PlyExportOptions:
    r"""
    Options for exporting PLY.
    """
    def __new__(cls) -> PlyExportOptions:
        r"""
        Set the options to their defaults.
        """

class PlyImportOptions:
    r"""
    Options for importing PLY.
    """
    def __new__(cls) -> PlyImportOptions:
        r"""
        Set the options to their defaults.
        """

class Point3d:
    def __new__(cls, x:builtins.float, y:builtins.float, z:builtins.float) -> Point3d:
        r"""
        Create a new point from its 3 components x, y and z
        All of them take floating point values.
        """

class RawFile:
    r"""
    A raw file with unencoded contents to be passed over binary websockets.
    When raw files come back for exports it is sent as binary/bson, not text/json.
    """
    @property
    def contents(self) -> builtins.list[builtins.int]: ...
    @property
    def name(self) -> builtins.str: ...

class SldprtImportOptions:
    r"""
    Options for importing SolidWorks parts.
    """
    def __new__(cls) -> SldprtImportOptions:
        r"""
        Set the options to their defaults.
        """

class SnapshotOptions:
    r"""
    Customize a snapshot.
    """
    def __new__(cls, camera:typing.Optional[CameraLookAt], padding:builtins.float) -> SnapshotOptions:
        r"""
        Takes a kcl.CameraLookAt, and a padding number.
        """
    @staticmethod
    def isometric_view(padding:builtins.float) -> SnapshotOptions:
        r"""
        Takes a padding number.
        """

class StepExportOptions:
    r"""
    Options for exporting STEP format.
    """
    def __new__(cls) -> StepExportOptions:
        r"""
        Set the options to their defaults.
        """

class StepImportOptions:
    r"""
    Options for importing STEP format.
    """
    def __new__(cls) -> StepImportOptions:
        r"""
        Set the options to their defaults.
        """

class StlExportOptions:
    r"""
    Options for exporting STL.
    """
    def __new__(cls) -> StlExportOptions:
        r"""
        Set the options to their defaults.
        """

class StlImportOptions:
    r"""
    Options for importing STL.
    """
    ...

class System:
    r"""
    Co-ordinate system definition.
    
    The `up` axis must be orthogonal to the `forward` axis.
    
    See [cglearn.eu] for background reading.
    
    [cglearn.eu](https://cglearn.eu/pub/computer-graphics/introduction-to-geometry#material-coordinate-systems-1)
    """
    ...

class Axis(Enum):
    r"""
    Co-ordinate axis specifier.
    
    See [cglearn.eu] for background reading.
    
    [cglearn.eu]: https://cglearn.eu/pub/computer-graphics/introduction-to-geometry#material-coordinate-systems-1
    """
    Y = ...
    r"""
    'Y' axis.
    """
    Z = ...
    r"""
    'Z' axis.
    """

class Direction(Enum):
    r"""
    Specifies the sign of a co-ordinate axis.
    """
    Positive = ...
    r"""
    Increasing numbers.
    """
    Negative = ...
    r"""
    Decreasing numbers.
    """

class DxfStorage(Enum):
    r"""
    Export storage.
    """
    Ascii = ...
    r"""
    Plaintext encoding.
    
    This is the default setting.
    """
    Binary = ...
    r"""
    Binary encoding.
    """

class FbxStorage(Enum):
    r"""
    Describes the storage format of an FBX file.
    """
    Ascii = ...
    r"""
    ASCII FBX encoding.
    """
    Binary = ...
    r"""
    Binary FBX encoding.
    """

class FileExportFormat(Enum):
    r"""
    The valid types of output file formats.
    """
    Fbx = ...
    r"""
    Autodesk Filmbox (FBX) format. <https://en.wikipedia.org/wiki/FBX>
    """
    Glb = ...
    r"""
    Binary glTF 2.0.
    
    This is a single binary with .glb extension.
    
    This is better if you want a compressed format as opposed to the human readable
    glTF that lacks compression.
    """
    Gltf = ...
    r"""
    glTF 2.0.
    Embedded glTF 2.0 (pretty printed).
    
    Single JSON file with .gltf extension binary data encoded as
    base64 data URIs.
    
    The JSON contents are pretty printed.
    
    It is human readable, single file, and you can view the
    diff easily in a git commit.
    """
    Obj = ...
    r"""
    The OBJ file format. <https://en.wikipedia.org/wiki/Wavefront_.obj_file>
    It may or may not have an an attached material (mtl // mtllib) within the file,
    but we interact with it as if it does not.
    """
    Ply = ...
    r"""
    The PLY file format. <https://en.wikipedia.org/wiki/PLY_(file_format)>
    """
    Step = ...
    r"""
    The STEP file format. <https://en.wikipedia.org/wiki/ISO_10303-21>
    """
    Stl = ...
    r"""
    The STL file format. <https://en.wikipedia.org/wiki/STL_(file_format)>
    """

class GltfStorage(Enum):
    r"""
    Describes the storage format of a glTF 2.0 scene.
    """
    Binary = ...
    r"""
    Binary glTF 2.0.
    
    This is a single binary with .glb extension.
    """
    Standard = ...
    r"""
    Standard glTF 2.0.
    
    This is a JSON file with .gltf extension paired with a separate
    binary blob file with .bin extension.
    """
    Embedded = ...
    r"""
    Embedded glTF 2.0.
    
    Single JSON file with .gltf extension binary data encoded as
    base64 data URIs.
    
    This is the default setting.
    """

class ImageFormat(Enum):
    r"""
    Enum containing the variety of image formats snapshots may be exported to.
    """
    Png = ...
    r"""
    .png format
    """
    Jpeg = ...
    r"""
    .jpeg format
    """

class PlyStorage(Enum):
    r"""
    The storage for the output PLY file.
    """
    Ascii = ...
    r"""
    Write numbers in their ascii representation (e.g. -13, 6.28, etc.). Properties are separated by spaces and elements are separated by line breaks.
    """
    BinaryLittleEndian = ...
    r"""
    Encode payload as binary using little endian.
    """
    BinaryBigEndian = ...
    r"""
    Encode payload as binary using big endian.
    """

class StlStorage(Enum):
    r"""
    Export storage.
    """
    Ascii = ...
    r"""
    Plaintext encoding.
    """
    Binary = ...
    r"""
    Binary STL encoding.
    
    This is the default setting.
    """

class UnitAngle(Enum):
    r"""
    The valid types of angle formats.
    """
    Degrees = ...
    r"""
    Degrees <https://en.wikipedia.org/wiki/Degree_(angle)>
    """
    Radians = ...
    r"""
    Radians <https://en.wikipedia.org/wiki/Radian>
    """

class UnitArea(Enum):
    r"""
    The valid types of area units.
    """
    SquareCentimeters = ...
    r"""
    Square centimeters <https://en.wikipedia.org/wiki/Square_centimeter>
    """
    SquareDecimeters = ...
    r"""
    Square decimeters <https://en.wikipedia.org/wiki/Square_decimeter>
    """
    SquareFeet = ...
    r"""
    Square feet <https://en.wikipedia.org/wiki/Square_foot>
    """
    SquareInches = ...
    r"""
    Square inches <https://en.wikipedia.org/wiki/Square_inch>
    """
    SquareKilometers = ...
    r"""
    Square kilometers <https://en.wikipedia.org/wiki/Square_kilometer>
    """
    SquareMeters = ...
    r"""
    Square meters <https://en.wikipedia.org/wiki/Square_meter>
    """
    SquareMillimeters = ...
    r"""
    Square millimeters <https://en.wikipedia.org/wiki/Square_millimeter>
    """
    SquareYards = ...
    r"""
    Square yards <https://en.wikipedia.org/wiki/Square_mile>
    """

class UnitDensity(Enum):
    r"""
    The valid types for density units.
    """
    PoundsPerCubicFeet = ...
    r"""
    Pounds per cubic feet.
    """
    KilogramsPerCubicMeter = ...
    r"""
    Kilograms per cubic meter.
    """

class UnitLength(Enum):
    r"""
    The valid types of length units.
    """
    Centimeters = ...
    r"""
    Centimeters <https://en.wikipedia.org/wiki/Centimeter>
    """
    Feet = ...
    r"""
    Feet <https://en.wikipedia.org/wiki/Foot_(unit)>
    """
    Inches = ...
    r"""
    Inches <https://en.wikipedia.org/wiki/Inch>
    """
    Meters = ...
    r"""
    Meters <https://en.wikipedia.org/wiki/Meter>
    """
    Millimeters = ...
    r"""
    Millimeters <https://en.wikipedia.org/wiki/Millimeter>
    """
    Yards = ...
    r"""
    Yards <https://en.wikipedia.org/wiki/Yard>
    """

class UnitMass(Enum):
    r"""
    The valid types of mass units.
    """
    Grams = ...
    r"""
    Grams <https://en.wikipedia.org/wiki/Gram>
    """
    Kilograms = ...
    r"""
    Kilograms <https://en.wikipedia.org/wiki/Kilogram>
    """
    Pounds = ...
    r"""
    Pounds <https://en.wikipedia.org/wiki/Pound_(mass)>
    """

class UnitVolume(Enum):
    r"""
    The valid types of volume units.
    """
    CubicCentimeters = ...
    r"""
    Cubic centimeters (cc or cm³) <https://en.wikipedia.org/wiki/Cubic_centimeter>
    """
    CubicFeet = ...
    r"""
    Cubic feet (ft³) <https://en.wikipedia.org/wiki/Cubic_foot>
    """
    CubicInches = ...
    r"""
    Cubic inches (cu in or in³) <https://en.wikipedia.org/wiki/Cubic_inch>
    """
    CubicMeters = ...
    r"""
    Cubic meters (m³) <https://en.wikipedia.org/wiki/Cubic_meter>
    """
    CubicYards = ...
    r"""
    Cubic yards (yd³) <https://en.wikipedia.org/wiki/Cubic_yard>
    """
    FluidOunces = ...
    r"""
    US Fluid Ounces (fl oz) <https://en.wikipedia.org/wiki/Fluid_ounce>
    """
    Gallons = ...
    r"""
    US Gallons (gal US) <https://en.wikipedia.org/wiki/Gallon>
    """
    Liters = ...
    r"""
    Liters (l) <https://en.wikipedia.org/wiki/Litre>
    """
    Milliliters = ...
    r"""
    Milliliters (ml) <https://en.wikipedia.org/wiki/Litre>
    """

async def execute(path:builtins.str) -> None:
    r"""
    Execute the kcl code from a file path.
    """

async def execute_and_export(path:builtins.str, export_format:FileExportFormat) -> builtins.list[RawFile]:
    r"""
    Execute a kcl file and export it to a specific file format.
    """

async def execute_and_snapshot(path:builtins.str, image_format:ImageFormat) -> builtins.list[builtins.int]:
    r"""
    Execute a kcl file and snapshot it in a specific format.
    """

async def execute_and_snapshot_views(path:builtins.str, image_format:ImageFormat, snapshot_options:typing.Sequence[SnapshotOptions]) -> builtins.list[builtins.list[builtins.int]]: ...

async def execute_code(code:builtins.str) -> None:
    r"""
    Execute the kcl code.
    """

async def execute_code_and_export(code:builtins.str, export_format:FileExportFormat) -> builtins.list[RawFile]:
    r"""
    Execute the kcl code and export it to a specific file format.
    """

async def execute_code_and_snapshot(code:builtins.str, image_format:ImageFormat) -> builtins.list[builtins.int]:
    r"""
    Execute the kcl code and snapshot it in a specific format.
    """

async def execute_code_and_snapshot_views(code:builtins.str, image_format:ImageFormat, snapshot_options:typing.Sequence[SnapshotOptions]) -> builtins.list[builtins.list[builtins.int]]:
    r"""
    Execute the kcl code and snapshot it in a specific format.
    Returns one image for each camera angle you provide.
    If you don't provide any camera angles, a default head-on camera angle will be used.
    """

def format(code:builtins.str) -> builtins.str:
    r"""
    Format the kcl code. This will return the formatted code.
    """

async def format_dir(dir:builtins.str) -> None:
    r"""
    Format a whole directory of kcl code.
    """

async def import_and_snapshot(filepaths:typing.Sequence[builtins.str], format:InputFormat3d, image_format:ImageFormat) -> builtins.list[builtins.int]: ...

async def import_and_snapshot_views(filepaths:typing.Sequence[builtins.str], format:InputFormat3d, image_format:ImageFormat, snapshot_options:typing.Sequence[SnapshotOptions]) -> builtins.list[builtins.list[builtins.int]]: ...

def lint(code:builtins.str) -> builtins.list[Discovered]:
    r"""
    Lint the kcl code.
    """

async def mock_execute(path:builtins.str) -> builtins.bool:
    r"""
    Mock execute the kcl code from a file path.
    """

async def mock_execute_code(code:builtins.str) -> builtins.bool:
    r"""
    Mock execute the kcl code.
    """

async def parse(path:builtins.str) -> builtins.bool:
    r"""
    Parse the kcl code from a file path.
    """

def parse_code(code:builtins.str) -> builtins.bool:
    r"""
    Parse the kcl code.
    """

def relevant_file_extensions() -> builtins.list[builtins.str]:
    r"""
    Get the allowed relevant file extensions (imports + kcl).
    """

