"""
Selected accession IDs from PSI MS Ontology
Guaranteed support for psi-ms versions 4.1.1 to 4.1.119
Other versions may be partially or fully supported.
"""

UNIT_MZ = "MS:1000040"
BINARY_UNITS = {  # as [struct format character, size in bytes]
    "MS:1000521": ["f", 4],  # float32
    "MS:1000523": ["d", 8],  # float64
    "MS:1000519": ["i", 4],  # int32
    "MS:1000522": ["q", 8],  # int64
    "MS:1001479": None,  # ascii; not handled with struct
}

BINARY_COMPRESSION = {
    "MS:1000574": ["zlib"],
    "MS:1000576": ["no compression"],
    "MS:1002312": ["numpress linear"],
    "MS:1002313": ["numpress positive int"],
    "MS:1002314": ["numpress short logged float"],
    "MS:1002746": ["zlib", "numpress linear"],
    "MS:1002747": ["zlib", "numpress positive int"],
    "MS:1002748": ["zlib", "numpress short logged float"],
}
INTENSITY_ARRAY = "MS:1000515"
MZ_ARRAY = "MS:1000514"

POSITIVE_SCAN = "MS:1000130"
NEGATIVE_SCAN = "MS:1000129"
MS_LEVEL = "MS:1000511"
PROFILE = "MS:1000128"
CENTROID = "MS:1000127"
TIME = "MS:1000016"
FILTER_STRING = "MS:1000512"
LOW_MZ = "MS:1000501"
HIGH_MZ = "MS:1000500"
ISOLATION_WINDOW = "MS:1000827"
COLLISION_ENERGY = "MS:1000045"

INSTRUMENTS = [
    "MS:1002719",
    "MS:1000163",
    "MS:1003096",
    "MS:1000641",
    "MS:1003230",
    "MS:1003004",
    "MS:1000636",
    "MS:1000622",
    "MS:1000658",
    "MS:1001769",
    "MS:1000931",
    "MS:1000467",
    "MS:1001782",
    "MS:1003124",
    "MS:1000675",
    "MS:1003005",
    "MS:1000644",
    "MS:1000126",
    "MS:1002277",
    "MS:1001533",
    "MS:1002731",
    "MS:1000554",
    "MS:1000159",
    "MS:1000149",
    "MS:1000855",
    "MS:1000702",
    "MS:1002301",
    "MS:1001766",
    "MS:1000176",
    "MS:1000578",
    "MS:1000490",
    "MS:1000143",
    "MS:1002583",
    "MS:1002274",
    "MS:1002276",
    "MS:1002998",
    "MS:1000819",
    "MS:1001775",
    "MS:1002728",
    "MS:1000698",
    "MS:1000174",
    "MS:1003112",
    "MS:1002799",
    "MS:1000700",
    "MS:1000151",
    "MS:1000449",
    "MS:1000140",
    "MS:1000170",
    "MS:1001801",
    "MS:1000158",
    "MS:1000450",
    "MS:1000643",
    "MS:1002594",
    "MS:1002588",
    "MS:1003123",
    "MS:1002802",
    "MS:1000171",
    "MS:1002300",
    "MS:1000172",
    "MS:1000202",
    "MS:1001908",
    "MS:1000179",
    "MS:1002800",
    "MS:1000168",
    "MS:1001777",
    "MS:1001778",
    "MS:1002590",
    "MS:1001742",
    "MS:1000153",
    "MS:1002418",
    "MS:1000193",
    "MS:1002581",
    "MS:1002729",
    "MS:1000605",
    "MS:1001544",
    "MS:1002788",
    "MS:1000705",
    "MS:1001787",
    "MS:1000611",
    "MS:1000697",
    "MS:1001549",
    "MS:1003003",
    "MS:1002634",
    "MS:1001789",
    "MS:1000173",
    "MS:1002805",
    "MS:1000935",
    "MS:1000031",
    "MS:1000653",
    "MS:1000181",
    "MS:1000203",
    "MS:1002875",
    "MS:1002382",
    "MS:1002279",
    "MS:1001780",
    "MS:1002798",
    "MS:1002298",
    "MS:1000474",
    "MS:1003252",
    "MS:1002526",
    "MS:1000156",
    "MS:1001548",
    "MS:1000610",
    "MS:1000198",
    "MS:1000191",
    "MS:1000699",
    "MS:1002297",
    "MS:1003245",
    "MS:1001761",
    "MS:1002577",
    "MS:1000655",
    "MS:1001792",
    "MS:1002792",
    "MS:1000647",
    "MS:1000704",
    "MS:1000472",
    "MS:1001546",
    "MS:1002592",
    "MS:1001763",
    "MS:1000145",
    "MS:1001773",
    "MS:1000932",
    "MS:1000478",
    "MS:1003231",
    "MS:1000177",
    "MS:1002732",
    "MS:1000818",
    "MS:1002296",
    "MS:1001547",
    "MS:1000204",
    "MS:1000648",
    "MS:1001786",
    "MS:1000488",
    "MS:1001774",
    "MS:1001779",
    "MS:1000469",
    "MS:1000175",
    "MS:1003144",
    "MS:1002790",
    "MS:1003029",
    "MS:1000152",
    "MS:1001804",
    "MS:1002666",
    "MS:1000634",
    "MS:1002674",
    "MS:1000185",
    "MS:1000557",
    "MS:1000743",
    "MS:1000555",
    "MS:1001790",
    "MS:1002419",
    "MS:1001770",
    "MS:1002877",
    "MS:1000160",
    "MS:1002525",
    "MS:1000121",
    "MS:1000123",
    "MS:1000638",
    "MS:1000602",
    "MS:1000750",
    "MS:1001800",
    "MS:1000189",
    "MS:1000162",
    "MS:1000652",
    "MS:1003028",
    "MS:1000161",
    "MS:1002077",
    "MS:1001536",
    "MS:1000180",
    "MS:1002785",
    "MS:1000491",
    "MS:1001556",
    "MS:1000190",
    "MS:1002784",
    "MS:1001555",
    "MS:1002794",
    "MS:1000139",
    "MS:1000183",
    "MS:1001534",
    "MS:1000476",
    "MS:1000556",
    "MS:1002727",
    "MS:1000167",
    "MS:1000471",
    "MS:1000607",
    "MS:1002280",
    "MS:1002803",
    "MS:1002278",
    "MS:1002586",
    "MS:1001543",
    "MS:1001541",
    "MS:1000696",
    "MS:1002801",
    "MS:1002446",
    "MS:1001945",
    "MS:1002578",
    "MS:1001803",
    "MS:1002595",
    "MS:1000603",
    "MS:1000937",
    "MS:1000654",
    "MS:1001553",
    "MS:1002587",
    "MS:1000751",
    "MS:1000125",
    "MS:1002275",
    "MS:1000493",
    "MS:1002787",
    "MS:1002445",
    "MS:1001539",
    "MS:1000749",
    "MS:1001482",
    "MS:1001535",
    "MS:1001909",
    "MS:1002417",
    "MS:1001785",
    "MS:1000448",
    "MS:1000657",
    "MS:1001802",
    "MS:1002533",
    "MS:1002294",
    "MS:1000623",
    "MS:1001771",
    "MS:1000640",
    "MS:1002293",
    "MS:1000187",
    "MS:1000695",
    "MS:1000495",
    "MS:1000141",
    "MS:1000489",
    "MS:1001510",
    "MS:1000632",
    "MS:1002585",
    "MS:1003184",
    "MS:1002593",
    "MS:1003356",
    "MS:1002580",
    "MS:1002667",
    "MS:1002796",
    "MS:1002874",
    "MS:1000447",
    "MS:1000200",
    "MS:1000154",
    "MS:1000856",
    "MS:1000492",
    "MS:1002835",
    "MS:1002791",
    "MS:1001791",
    "MS:1000144",
    "MS:1000477",
    "MS:1000169",
    "MS:1000701",
    "MS:1000194",
    "MS:1000642",
    "MS:1002582",
    "MS:1003183",
    "MS:1003293",
    "MS:1002804",
    "MS:1003122",
    "MS:1000192",
    "MS:1000676",
    "MS:1001911",
    "MS:1000606",
    "MS:1000157",
    "MS:1001776",
    "MS:1000748",
    "MS:1000142",
    "MS:1000656",
    "MS:1001545",
    "MS:1000483",
    "MS:1000197",
    "MS:1001538",
    "MS:1000201",
    "MS:1001764",
    "MS:1000199",
    "MS:1003000",
    "MS:1003095",
    "MS:1003229",
    "MS:1000165",
    "MS:1000475",
    "MS:1001767",
    "MS:1000936",
    "MS:1002589",
    "MS:1002584",
    "MS:1001540",
    "MS:1000468",
    "MS:1000124",
    "MS:1001542",
    "MS:1002793",
    "MS:1003185",
    "MS:1002416",
    "MS:1003292",
    "MS:1000854",
    "MS:1001550",
    "MS:1002299",
    "MS:1000604",
    "MS:1002726",
    "MS:1002999",
    "MS:1000646",
    "MS:1003094",
    "MS:1001772",
    "MS:1002789",
    "MS:1000703",
    "MS:1002523",
    "MS:1000184",
    "MS:1002876",
    "MS:1000188",
    "MS:1000494",
    "MS:1000645",
    "MS:1001537",
    "MS:1002786",
    "MS:1000470",
    "MS:1002783",
    "MS:1000649",
    "MS:1000164",
    "MS:1001765",
    "MS:1002295",
    "MS:1003152",
    "MS:1000122",
    "MS:1002591",
    "MS:1000608",
    "MS:1000182",
    "MS:1000147",
    "MS:1002579",
    "MS:1001781",
    "MS:1000150",
    "MS:1000677",
    "MS:1000609",
    "MS:1001762",
    "MS:1000612",
    "MS:1001784",
    "MS:1001783",
    "MS:1002444",
    "MS:1001768",
    "MS:1002730",
    "MS:1000146",
    "MS:1000635",
    "MS:1000637",
    "MS:1000473",
    "MS:1002795",
    "MS:1003002",
    "MS:1000558",
    "MS:1000196",
    "MS:1000639",
    "MS:1001910",
    "MS:1001554",
    "MS:1000195",
    "MS:1001788",
    "MS:1000870",
    "MS:1000178",
    "MS:1000148",
    "MS:1000186",
    "MS:1003001",
    "MS:1000166",
    "MS:1000651",
    "MS:1002797",
]
