import * as ec2 from '@aws-cdk/aws-ec2';
import * as rds from '@aws-cdk/aws-rds';
import * as cdk from '@aws-cdk/core';
/**
 * @experimental
 */
export declare enum MySQLtimeZone {
    /**
     * (experimental) TIME ZONE UTC.
     *
     * @experimental
     */
    UTC = "UTC",
    /**
     * (experimental) TIME ZONE Asia/Taipei.
     *
     * @experimental
     */
    ASIA_TAIPEI = "Asia/Taipei",
    /**
     * (experimental) TIME ZONE Africa/Cairo.
     *
     * @experimental
     */
    AFRICA_CAIRO = "Africa/Cairo",
    /**
     * (experimental) TIME ZONE Asia/Bangkok.
     *
     * @experimental
     */
    ASIA_BANGKOK = "Asia/Bangkok",
    /**
     * (experimental) TIME ZONE Australia/Darwin.
     *
     * @experimental
     */
    AUSTRALIA_DARWIN = "Australia/Darwin",
    /**
     * (experimental) TIME ZONE Africa/Casablanca.
     *
     * @experimental
     */
    AFRICA_CASABLANCA = "Africa/Casablanca",
    /**
     * (experimental) TIME ZONE Asia/Beirut.
     *
     * @experimental
     */
    ASIA_BEIRUT = "Asia/Beirut",
    /**
     * (experimental) TIME ZONE Australia/Hobart.
     *
     * @experimental
     */
    AUSTRALIA_HOBART = "Australia/Hobart",
    /**
     * (experimental) TIME ZONE Africa/Harare.
     *
     * @experimental
     */
    AFRICA_HARARE = "Africa/Harare",
    /**
     * (experimental) TIME ZONE Asia/Calcutta.
     *
     * @experimental
     */
    ASIA_CALCUTTA = "Asia/Calcutta",
    /**
     * (experimental) TIME ZONE Australia/Perth.
     *
     * @experimental
     */
    AUSTRALIA_PERTH = "Australia/Perth",
    /**
     * (experimental) TIME ZONE Africa/Monrovia.
     *
     * @experimental
     */
    AFRICA_MONROVIA = "Africa/Monrovia",
    /**
     * (experimental) TIME ZONE Asia/Damascus.
     *
     * @experimental
     */
    ASIA_DAMASCUS = "Asia/Damascus",
    /**
     * (experimental) TIME ZONE Australia/Sydney.
     *
     * @experimental
     */
    AUSTRALIA_SYDNEY = "Australia/Sydney",
    /**
     * (experimental) TIME ZONE Africa/Nairobi.
     *
     * @experimental
     */
    AFRICA_NAIROBI = "Africa/Nairobi",
    /**
     * (experimental) TIME ZONE Asia/Dhaka.
     *
     * @experimental
     */
    ASIA_DHAKA = "Asia/Dhaka",
    /**
     * (experimental) TIME ZONE Brazil/East.
     *
     * @experimental
     */
    BRAZIL_EAST = "Brazil/East",
    /**
     * (experimental) TIME ZONE Africa/Tripoli.
     *
     * @experimental
     */
    AFRICA_TRIPOLI = "Africa/Tripoli",
    /**
     * (experimental) TIME ZONE Asia/Irkutsk.
     *
     * @experimental
     */
    ASIA_IRKUTSK = "Asia/Irkutsk",
    /**
     * (experimental) TIME ZONE Canada/Newfoundland.
     *
     * @experimental
     */
    CANADA_NEWFOUNDLAND = "Canada/Newfoundland",
    /**
     * (experimental) TIME ZONE Africa/Windhoek.
     *
     * @experimental
     */
    AFRICA_WINDHOEK = "Africa/Windhoek",
    /**
     * (experimental) TIME ZONE Asia/Jerusalem.
     *
     * @experimental
     */
    ASIA_JERUSALEM = "Asia/Jerusalem",
    /**
     * (experimental) TIME ZONE Canada/Saskatchewan.
     *
     * @experimental
     */
    CANADA_SASKATCHEWAN = "Canada/Saskatchewan",
    /**
     * (experimental) TIME ZONE America/Araguaina.
     *
     * @experimental
     */
    AMERICA_ARAGUAINA = "America/Araguaina",
    /**
     * (experimental) TIME ZONE Asia/Kabul.
     *
     * @experimental
     */
    ASIA_KABUL = "Asia/Kabul",
    /**
     * (experimental) TIME ZONE Europe/Amsterdam.
     *
     * @experimental
     */
    EUROPE_AMSTERDAM = "Europe/Amsterdam",
    /**
     * (experimental) TIME ZONE America/Asuncion.
     *
     * @experimental
     */
    AMERICA_ASUNCION = "America/Asuncion",
    /**
     * (experimental) TIME ZONE Asia/Karachi.
     *
     * @experimental
     */
    ASIA_KARACHI = "Asia/Karachi",
    /**
     * (experimental) TIME ZONE Europe/Athens.
     *
     * @experimental
     */
    EUROPE_ATHENS = "Europe/Athens",
    /**
     * (experimental) TIME ZONE America/Bogota.
     *
     * @experimental
     */
    AMERICA_BOGOTA = "America/Bogota",
    /**
     * (experimental) TIME ZONE Asia/Kathmandu.
     *
     * @experimental
     */
    ASIA_KATHMANDU = "Asia/Kathmandu",
    /**
     * (experimental) TIME ZONE Europe/Dublin.
     *
     * @experimental
     */
    EUROPE_DUBLIN = "Europe/Dublin",
    /**
     * (experimental) TIME ZONE America/Caracas.
     *
     * @experimental
     */
    AMERICA_CARACAS = "America/Caracas",
    /**
     * (experimental) TIME ZONE Asia/Krasnoyarsk.
     *
     * @experimental
     */
    ASIA_KRASNOYARSK = "Asia/Krasnoyarsk",
    /**
     * (experimental) TIME ZONE Europe/Helsinki.
     *
     * @experimental
     */
    EUROPE_HELSINKI = "Europe/Helsinki",
    /**
     * (experimental) TIME ZONE America/Chihuahua.
     *
     * @experimental
     */
    AMERICA_CHIHUAHUA = "America/Chihuahua",
    /**
     * (experimental) TIME ZONE Asia/Magadan.
     *
     * @experimental
     */
    ASIA_MAGADAN = "Asia/Magadan",
    /**
     * (experimental) TIME ZONE Europe/Istanbul.
     *
     * @experimental
     */
    EUROPE_ISTANBUL = "Europe/Istanbul",
    /**
     * (experimental) TIME ZONE America/Cuiaba.
     *
     * @experimental
     */
    AMERICA_CUIABA = "America/Cuiaba",
    /**
     * (experimental) TIME ZONE Asia/Muscat.
     *
     * @experimental
     */
    ASIA_MUSCAT = "Asia/Muscat",
    /**
     * (experimental) TIME ZONE Europe/Kaliningrad.
     *
     * @experimental
     */
    EUROPE_KALININGRAD = "Europe/Kaliningrad",
    /**
     * (experimental) TIME ZONE America/Denver.
     *
     * @experimental
     */
    AMERICA_DENVER = "America/Denver",
    /**
     * (experimental) TIME ZONE Asia/Novosibirsk.
     *
     * @experimental
     */
    ASIA_NOVOSIBIRSK = "Asia/Novosibirsk",
    /**
     * (experimental) TIME ZONE Europe/Moscow'.
     *
     * @experimental
     */
    EUROPE_MOSCOW = "Europe/Moscow",
    /**
     * (experimental) TIME ZONE America/Fortaleza.
     *
     * @experimental
     */
    AMERICA_FORTALEZA = "America/Fortaleza",
    /**
     * (experimental) TIME ZONE Asia/Riyadh.
     *
     * @experimental
     */
    ASIA_RIYADH = "Asia/Riyadh",
    /**
     * (experimental) TIME ZONE Europe/Paris.
     *
     * @experimental
     */
    EUROPE_PARIS = "Europe/Paris",
    /**
     * (experimental) TIME ZONE America/Guatemala.
     *
     * @experimental
     */
    AMERICA_GUATEMALA = "America/Guatemala",
    /**
     * (experimental) TIME ZONE Asia/Seoul.
     *
     * @experimental
     */
    ASIA_SEOUL = "Asia/Seoul",
    /**
     * (experimental) TIME ZONE Europe/Prague.
     *
     * @experimental
     */
    EUROPE_PRAGUE = "Europe/Prague",
    /**
     * (experimental) TIME ZONE America/Halifax.
     *
     * @experimental
     */
    AMERICA_HALIFAX = "America/Halifax",
    /**
     * (experimental) TIME ZONE Asia/Shanghai.
     *
     * @experimental
     */
    ASIA_SHANGHAI = "Asia/Shanghai",
    /**
     * (experimental) TIME ZONE Europe/Sarajevo.
     *
     * @experimental
     */
    EUROPE_SARAJEVO = "Europe/Sarajevo",
    /**
     * (experimental) TIME ZONE America/Manaus.
     *
     * @experimental
     */
    AMERICA_MANAUS = "America/Manaus",
    /**
     * (experimental) TIME ZONE Asia/Singapore.
     *
     * @experimental
     */
    ASIA_SINGAPORE = "Asia/Singapore",
    /**
     * (experimental) TIME ZONE Pacific/Auckland.
     *
     * @experimental
     */
    PACIFIC_AUCKLAND = "Pacific/Auckland",
    /**
     * (experimental) TIME ZONE America/Matamoros.
     *
     * @experimental
     */
    AMERICA_MATAMOROS = "America/Matamoros",
    /**
     * (experimental) TIME ZONE Pacific/Fiji.
     *
     * @experimental
     */
    PACIFIC_FIJI = "Pacific/Fiji",
    /**
     * (experimental) TIME ZONE America/Monterrey.
     *
     * @experimental
     */
    AMERICA_MONTERREY = "America/Monterrey",
    /**
     * (experimental) TIME ZONE Asia/Tehran.
     *
     * @experimental
     */
    ASIA_TEHRAN = "Asia/Tehran",
    /**
     * (experimental) TIME ZONE Pacific/Guam.
     *
     * @experimental
     */
    PACIFIC_GUAM = "Pacific/Guam",
    /**
     * (experimental) TIME ZONE America/Montevideo.
     *
     * @experimental
     */
    AMERICA_MONTEVIDEO = "America/Montevideo",
    /**
     * (experimental) TIME ZONE Asia/Tokyo.
     *
     * @experimental
     */
    ASIA_TOKYO = "Asia/Tokyo",
    /**
     * (experimental) TIME ZONE Pacific/Honolulu.
     *
     * @experimental
     */
    PACIFIC_HONOLULU = "Pacific/Honolulu",
    /**
     * (experimental) TIME ZONE America/Phoenix.
     *
     * @experimental
     */
    AMERICA_PHOENIX = "America/Phoenix",
    /**
     * (experimental) TIME ZONE Asia/Ulaanbaatar.
     *
     * @experimental
     */
    ASIA_ULAANBAATAR = "Asia/Ulaanbaatar",
    /**
     * (experimental) TIME ZONE Pacific/Samoa.
     *
     * @experimental
     */
    PACIFIC_SAMOA = "Pacific/Samoa",
    /**
     * (experimental) TIME ZONE America/Santiago.
     *
     * @experimental
     */
    AMERICA_SANTIAGO = "America/Santiago",
    /**
     * (experimental) TIME ZONE Asia/Vladivostok.
     *
     * @experimental
     */
    ASIA_VLADIVOSTOK = "Asia/Vladivostok",
    /**
     * (experimental) TIME ZONE US/Alaska.
     *
     * @experimental
     */
    US_ALASKA = "US/Alaska",
    /**
     * (experimental) TIME ZONE America/Tijuana.
     *
     * @experimental
     */
    AMERICA_TIJUANA = "America/Tijuana",
    /**
     * (experimental) TIME ZONE Asia/Yakutsk.
     *
     * @experimental
     */
    ASIA_YAKUTSK = "Asia/Yakutsk",
    /**
     * (experimental) TIME ZONE US/Central.
     *
     * @experimental
     */
    US_CENTRAL = "US/Central",
    /**
     * (experimental) TIME ZONE Asia/Amman.
     *
     * @experimental
     */
    ASIA_AMMAN = "Asia/Amman",
    /**
     * (experimental) TIME ZONE Asia/Yerevan.
     *
     * @experimental
     */
    ASIA_YEREVAN = "Asia/Yerevan",
    /**
     * (experimental) TIME ZONE US/Eastern.
     *
     * @experimental
     */
    US_EASTERN = "US/Eastern",
    /**
     * (experimental) TIME ZONE Asia/Ashgabat.
     *
     * @experimental
     */
    ASIA_ASHGABAT = "Asia/Ashgabat",
    /**
     * (experimental) TIME ZONE Atlantic/Azores.
     *
     * @experimental
     */
    ATLANTIC_AZORES = "Atlantic/Azores",
    /**
     * (experimental) TIME ZONE US/East-Indiana.
     *
     * @experimental
     */
    US_EAST_INDIANA = "US/East-Indiana",
    /**
     * (experimental) TIME ZONE Asia/Baghdad.
     *
     * @experimental
     */
    ASIA_BAGHDAD = "Asia/Baghdad",
    /**
     * (experimental) TIME ZONE Australia/Adelaide.
     *
     * @experimental
     */
    AUSTRALIA_ADELAIDE = "Australia/Adelaide",
    /**
     * (experimental) TIME ZONE US/Pacific.
     *
     * @experimental
     */
    US_PACIFIC = "US/Pacific",
    /**
     * (experimental) TIME ZONE Asia/Baku.
     *
     * @experimental
     */
    ASIA_BAKU = "Asia/Baku",
    /**
     * (experimental) TIME ZONE Australia/Brisbane.
     *
     * @experimental
     */
    AUSTRALIA_BRISBANE = "Australia/Brisbane"
}
/**
 * @experimental
 */
export declare enum InstanceTypeEnum {
    /**
     * (experimental) db Instance Type r4.large.
     *
     * @experimental
     */
    R4_LARGE = "r4.large",
    /**
     * (experimental) db Instance Type r4.xlarge.
     *
     * @experimental
     */
    R4_XLARGE = "r4.xlarge",
    /**
     * (experimental) db Instance Type r4.2xlarge.
     *
     * @experimental
     */
    R4_2XLARGE = "r4.2xlarge",
    /**
     * (experimental) db Instance Type r4.4xlarge.
     *
     * @experimental
     */
    R4_4XLARGE = "r4.4xlarge",
    /**
     * (experimental) db Instance Type r4.8xlarge.
     *
     * @experimental
     */
    R4_8XLARGE = "r4.8xlarge",
    /**
     * (experimental) db Instance Type r4.16xlarge.
     *
     * @experimental
     */
    R4_16XLARGE = "r4.16xlarge",
    /**
     * (experimental) db Instance Type r5.large.
     *
     * @experimental
     */
    R5_LARGE = "r5.large",
    /**
     * (experimental) db Instance Type r5.xlarge.
     *
     * @experimental
     */
    R5_XLARGE = "r5.xlarge",
    /**
     * (experimental) db Instance Type r5.2xlarge.
     *
     * @experimental
     */
    R5_2XLARGE = "r5.2xlarge",
    /**
     * (experimental) db Instance Type r5.4xlarge.
     *
     * @experimental
     */
    R5_4XLARGE = "r5.4xlarge",
    /**
     * (experimental) db Instance Type r5.8xlarge.
     *
     * @experimental
     */
    R5_8XLARGE = "r5.8xlarge",
    /**
     * (experimental) db Instance Type r5.12xlarge.
     *
     * @experimental
     */
    R5_12XLARGE = "r5.12xlarge",
    /**
     * (experimental) db Instance Type r5.16xlarge.
     *
     * @experimental
     */
    R5_16XLARGE = "r5.16xlarge",
    /**
     * (experimental) db Instance Type r5.24xlarge.
     *
     * @experimental
     */
    R5_24XLARGE = "r5.24xlarge"
}
/**
 * @experimental
 */
export interface GolbalAuroraRDSMasterProps {
    /**
     * (experimental) RDS default VPC.
     *
     * @default - new VPC
     * @experimental
     */
    readonly vpc?: ec2.IVpc;
    /**
     * (experimental) RDS default Super User Name.
     *
     * @default - sysadmin
     * @experimental
     */
    readonly dbUserName?: string;
    /**
     * (experimental) RDS default Database Name.
     *
     * @default - globaldatabase
     * @experimental
     */
    readonly defaultDatabaseName?: string;
    /**
     * (experimental) RDS ParameterGroup.
     *
     * @default - Aurora MySQL ParameterGroup
     * @experimental
     */
    readonly dbClusterpPG?: rds.IParameterGroup;
    /**
     * (experimental) RDS Instance Type only can use r4 or r5 type see more https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-global-database.html#aurora-global-database.limitations.
     *
     * @default - r5.large
     * @experimental
     */
    readonly instanceType?: InstanceTypeEnum;
    /**
     * (experimental) RDS time zone.
     *
     * @default - MySQLtimeZone.UTC
     * @experimental
     */
    readonly timeZone?: MySQLtimeZone;
    /**
     * (experimental) RDS Parameters.
     *
     * @default - {time_zone: 'UTC'}
     * @experimental
     */
    readonly parameters?: {
        [key: string]: string;
    } | undefined;
    /**
     * (experimental) RDS Database Cluster Engine .
     *
     * @default - rds.DatabaseClusterEngine.auroraMysql({version: rds.AuroraMysqlEngineVersion.VER_2_07_1,})
     * @experimental
     */
    readonly engineVersion?: rds.IClusterEngine;
    /**
     * (experimental) Global RDS Database Cluster Engine Deletion Protection Option .
     *
     * @default - false
     * @experimental
     */
    readonly deletionProtection?: boolean;
    /**
     * (experimental) Global RDS Database Cluster Engine Storage Encrypted Option .
     *
     * @default - true
     * @experimental
     */
    readonly storageEncrypted?: boolean;
    /**
     * (experimental) return RDS Cluster password.
     *
     * @experimental
     */
    readonly rdsPassword?: string;
}
/**
 * @experimental
 */
export interface RegionalOptions {
    /**
     * @experimental
     */
    readonly region: string;
    /**
     * @experimental
     */
    readonly dbSubnetGroupName?: string;
}
/**
 * @experimental
 */
export declare class GolbalAuroraRDSMaster extends cdk.Construct {
    /**
     * (experimental) return RDS Cluster.
     *
     * @experimental
     */
    readonly rdsCluster: rds.DatabaseCluster;
    /**
     * (experimental) return RDS Cluster password.
     *
     * if not define props.rdsPassword , password will stored in Secret Manager
     * Please use this command get password back , "aws secretsmanager get-secret-value --secret-id secret name"
     *
     * @experimental
     */
    readonly rdsPassword: string | undefined;
    /**
     * (experimental) return RDS Cluster ParameterGroup.
     *
     * @experimental
     */
    readonly dbClusterpPG: rds.IParameterGroup;
    /**
     * (experimental) return RDS Cluster is Public ?
     *
     * @experimental
     */
    readonly rdsIsPublic: ec2.SubnetType;
    /**
     * (experimental) return RDS Cluster Resource ARN .
     *
     * @experimental
     */
    readonly rdsClusterarn: string;
    /**
     * (experimental) return Global RDS Cluster Identifier .
     *
     * @experimental
     */
    readonly globalClusterIdentifier: string;
    /**
     * (experimental) return RDS Cluster DB Engine .
     *
     * @experimental
     */
    readonly engine: string;
    /**
     * (experimental) return RDS Cluster DB Engine Version.
     *
     * @experimental
     */
    readonly engineVersion: rds.IClusterEngine;
    /**
     * (experimental) return Global RDS Cluster Resource ARN .
     *
     * @experimental
     */
    readonly globalClusterArn: string;
    /**
     * (experimental) return Global RDS Cluster instance Type .
     *
     * @experimental
     */
    readonly rdsInstanceType: InstanceTypeEnum;
    /**
     * CustomResource for Second Regional .
     */
    private crGlobalRDSProvider;
    /**
     * (experimental) return RDS Cluster DB Engine Version.
     *
     * @experimental
     */
    readonly clusterEngineVersion: string;
    /**
     * @experimental
     */
    constructor(scope: cdk.Construct, id: string, props?: GolbalAuroraRDSMasterProps);
    private azOfSubnets;
    /**
     * @experimental
     */
    addRegionalCluster(scope: cdk.Construct, id: string, options: RegionalOptions): void;
}
/**
 * @experimental
 */
export interface GolbalAuroraRDSSlaveInfraProps {
    /**
     * (experimental) Slave region VPC.
     *
     * @default - new VPC
     * @experimental
     */
    readonly vpc?: ec2.IVpc;
    /**
     * (experimental) Slave region.
     *
     * @experimental
     */
    readonly subnetType?: ec2.SubnetType;
    /**
     * (experimental) RDS Stack.
     *
     * @experimental
     */
    readonly stack?: cdk.Stack;
    /**
     * (experimental) Global RDS Database Cluster Engine Deletion Protection Option .
     *
     * @default - false
     * @experimental
     */
    readonly deletionProtection?: boolean;
    /**
     * (experimental) Global RDS Database Cluster Engine Storage Encrypted Option .
     *
     * @default - true
     * @experimental
     */
    readonly storageEncrypted?: boolean;
}
/**
 * @experimental
 */
export declare class GolbalAuroraRDSSlaveInfra extends cdk.Construct {
    /**
     * (experimental) GolbalAuroraRDSSlaveInfra subnet group .
     *
     * @default - true
     * @experimental
     */
    readonly dbSubnetGroup: rds.CfnDBSubnetGroup;
    /**
     * @experimental
     */
    constructor(scope: cdk.Construct, id: string, props?: GolbalAuroraRDSSlaveInfraProps);
}
