"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.GolbalAuroraRDSSlaveInfra = exports.GolbalAuroraRDSMaster = exports.InstanceTypeEnum = exports.MySQLtimeZone = void 0;
const path = require("path");
const ec2 = require("@aws-cdk/aws-ec2");
const iam = require("@aws-cdk/aws-iam");
const lambda = require("@aws-cdk/aws-lambda");
const logs = require("@aws-cdk/aws-logs");
const rds = require("@aws-cdk/aws-rds");
const cdk = require("@aws-cdk/core");
const cr = require("@aws-cdk/custom-resources");
/**
 * @experimental
 */
var MySQLtimeZone;
(function (MySQLtimeZone) {
    MySQLtimeZone["UTC"] = "UTC";
    MySQLtimeZone["ASIA_TAIPEI"] = "Asia/Taipei";
    MySQLtimeZone["AFRICA_CAIRO"] = "Africa/Cairo";
    MySQLtimeZone["ASIA_BANGKOK"] = "Asia/Bangkok";
    MySQLtimeZone["AUSTRALIA_DARWIN"] = "Australia/Darwin";
    MySQLtimeZone["AFRICA_CASABLANCA"] = "Africa/Casablanca";
    MySQLtimeZone["ASIA_BEIRUT"] = "Asia/Beirut";
    MySQLtimeZone["AUSTRALIA_HOBART"] = "Australia/Hobart";
    MySQLtimeZone["AFRICA_HARARE"] = "Africa/Harare";
    MySQLtimeZone["ASIA_CALCUTTA"] = "Asia/Calcutta";
    MySQLtimeZone["AUSTRALIA_PERTH"] = "Australia/Perth";
    MySQLtimeZone["AFRICA_MONROVIA"] = "Africa/Monrovia";
    MySQLtimeZone["ASIA_DAMASCUS"] = "Asia/Damascus";
    MySQLtimeZone["AUSTRALIA_SYDNEY"] = "Australia/Sydney";
    MySQLtimeZone["AFRICA_NAIROBI"] = "Africa/Nairobi";
    MySQLtimeZone["ASIA_DHAKA"] = "Asia/Dhaka";
    MySQLtimeZone["BRAZIL_EAST"] = "Brazil/East";
    MySQLtimeZone["AFRICA_TRIPOLI"] = "Africa/Tripoli";
    MySQLtimeZone["ASIA_IRKUTSK"] = "Asia/Irkutsk";
    MySQLtimeZone["CANADA_NEWFOUNDLAND"] = "Canada/Newfoundland";
    MySQLtimeZone["AFRICA_WINDHOEK"] = "Africa/Windhoek";
    MySQLtimeZone["ASIA_JERUSALEM"] = "Asia/Jerusalem";
    MySQLtimeZone["CANADA_SASKATCHEWAN"] = "Canada/Saskatchewan";
    MySQLtimeZone["AMERICA_ARAGUAINA"] = "America/Araguaina";
    MySQLtimeZone["ASIA_KABUL"] = "Asia/Kabul";
    MySQLtimeZone["EUROPE_AMSTERDAM"] = "Europe/Amsterdam";
    MySQLtimeZone["AMERICA_ASUNCION"] = "America/Asuncion";
    MySQLtimeZone["ASIA_KARACHI"] = "Asia/Karachi";
    MySQLtimeZone["EUROPE_ATHENS"] = "Europe/Athens";
    MySQLtimeZone["AMERICA_BOGOTA"] = "America/Bogota";
    MySQLtimeZone["ASIA_KATHMANDU"] = "Asia/Kathmandu";
    MySQLtimeZone["EUROPE_DUBLIN"] = "Europe/Dublin";
    MySQLtimeZone["AMERICA_CARACAS"] = "America/Caracas";
    MySQLtimeZone["ASIA_KRASNOYARSK"] = "Asia/Krasnoyarsk";
    MySQLtimeZone["EUROPE_HELSINKI"] = "Europe/Helsinki";
    MySQLtimeZone["AMERICA_CHIHUAHUA"] = "America/Chihuahua";
    MySQLtimeZone["ASIA_MAGADAN"] = "Asia/Magadan";
    MySQLtimeZone["EUROPE_ISTANBUL"] = "Europe/Istanbul";
    MySQLtimeZone["AMERICA_CUIABA"] = "America/Cuiaba";
    MySQLtimeZone["ASIA_MUSCAT"] = "Asia/Muscat";
    MySQLtimeZone["EUROPE_KALININGRAD"] = "Europe/Kaliningrad";
    MySQLtimeZone["AMERICA_DENVER"] = "America/Denver";
    MySQLtimeZone["ASIA_NOVOSIBIRSK"] = "Asia/Novosibirsk";
    MySQLtimeZone["EUROPE_MOSCOW"] = "Europe/Moscow";
    MySQLtimeZone["AMERICA_FORTALEZA"] = "America/Fortaleza";
    MySQLtimeZone["ASIA_RIYADH"] = "Asia/Riyadh";
    MySQLtimeZone["EUROPE_PARIS"] = "Europe/Paris";
    MySQLtimeZone["AMERICA_GUATEMALA"] = "America/Guatemala";
    MySQLtimeZone["ASIA_SEOUL"] = "Asia/Seoul";
    MySQLtimeZone["EUROPE_PRAGUE"] = "Europe/Prague";
    MySQLtimeZone["AMERICA_HALIFAX"] = "America/Halifax";
    MySQLtimeZone["ASIA_SHANGHAI"] = "Asia/Shanghai";
    MySQLtimeZone["EUROPE_SARAJEVO"] = "Europe/Sarajevo";
    MySQLtimeZone["AMERICA_MANAUS"] = "America/Manaus";
    MySQLtimeZone["ASIA_SINGAPORE"] = "Asia/Singapore";
    MySQLtimeZone["PACIFIC_AUCKLAND"] = "Pacific/Auckland";
    MySQLtimeZone["AMERICA_MATAMOROS"] = "America/Matamoros";
    MySQLtimeZone["PACIFIC_FIJI"] = "Pacific/Fiji";
    MySQLtimeZone["AMERICA_MONTERREY"] = "America/Monterrey";
    MySQLtimeZone["ASIA_TEHRAN"] = "Asia/Tehran";
    MySQLtimeZone["PACIFIC_GUAM"] = "Pacific/Guam";
    MySQLtimeZone["AMERICA_MONTEVIDEO"] = "America/Montevideo";
    MySQLtimeZone["ASIA_TOKYO"] = "Asia/Tokyo";
    MySQLtimeZone["PACIFIC_HONOLULU"] = "Pacific/Honolulu";
    MySQLtimeZone["AMERICA_PHOENIX"] = "America/Phoenix";
    MySQLtimeZone["ASIA_ULAANBAATAR"] = "Asia/Ulaanbaatar";
    MySQLtimeZone["PACIFIC_SAMOA"] = "Pacific/Samoa";
    MySQLtimeZone["AMERICA_SANTIAGO"] = "America/Santiago";
    MySQLtimeZone["ASIA_VLADIVOSTOK"] = "Asia/Vladivostok";
    MySQLtimeZone["US_ALASKA"] = "US/Alaska";
    MySQLtimeZone["AMERICA_TIJUANA"] = "America/Tijuana";
    MySQLtimeZone["ASIA_YAKUTSK"] = "Asia/Yakutsk";
    MySQLtimeZone["US_CENTRAL"] = "US/Central";
    MySQLtimeZone["ASIA_AMMAN"] = "Asia/Amman";
    MySQLtimeZone["ASIA_YEREVAN"] = "Asia/Yerevan";
    MySQLtimeZone["US_EASTERN"] = "US/Eastern";
    MySQLtimeZone["ASIA_ASHGABAT"] = "Asia/Ashgabat";
    MySQLtimeZone["ATLANTIC_AZORES"] = "Atlantic/Azores";
    MySQLtimeZone["US_EAST_INDIANA"] = "US/East-Indiana";
    MySQLtimeZone["ASIA_BAGHDAD"] = "Asia/Baghdad";
    MySQLtimeZone["AUSTRALIA_ADELAIDE"] = "Australia/Adelaide";
    MySQLtimeZone["US_PACIFIC"] = "US/Pacific";
    MySQLtimeZone["ASIA_BAKU"] = "Asia/Baku";
    MySQLtimeZone["AUSTRALIA_BRISBANE"] = "Australia/Brisbane";
})(MySQLtimeZone = exports.MySQLtimeZone || (exports.MySQLtimeZone = {}));
/**
 * @experimental
 */
var InstanceTypeEnum;
(function (InstanceTypeEnum) {
    InstanceTypeEnum["R4_LARGE"] = "r4.large";
    InstanceTypeEnum["R4_XLARGE"] = "r4.xlarge";
    InstanceTypeEnum["R4_2XLARGE"] = "r4.2xlarge";
    InstanceTypeEnum["R4_4XLARGE"] = "r4.4xlarge";
    InstanceTypeEnum["R4_8XLARGE"] = "r4.8xlarge";
    InstanceTypeEnum["R4_16XLARGE"] = "r4.16xlarge";
    InstanceTypeEnum["R5_LARGE"] = "r5.large";
    InstanceTypeEnum["R5_XLARGE"] = "r5.xlarge";
    InstanceTypeEnum["R5_2XLARGE"] = "r5.2xlarge";
    InstanceTypeEnum["R5_4XLARGE"] = "r5.4xlarge";
    InstanceTypeEnum["R5_8XLARGE"] = "r5.8xlarge";
    InstanceTypeEnum["R5_12XLARGE"] = "r5.12xlarge";
    InstanceTypeEnum["R5_16XLARGE"] = "r5.16xlarge";
    InstanceTypeEnum["R5_24XLARGE"] = "r5.24xlarge";
})(InstanceTypeEnum = exports.InstanceTypeEnum || (exports.InstanceTypeEnum = {}));
const GlobalAuroraRDSSupportRegion = ['us-east-1', 'us-east-2', 'us-west-1', 'us-west-2', 'eu-west-1', 'eu-west-2', 'eu-west-3', 'eu-central-1',
    'ap-south-1', 'ap-southeast-1', 'ap-southeast-2', 'ap-northeast-1', 'ap-northeast-2', 'ca-central-1'];
/**
 * @experimental
 */
class GolbalAuroraRDSMaster extends cdk.Construct {
    /**
     * @experimental
     */
    constructor(scope, id, props) {
        var _a, _b, _c, _d, _e, _f, _g, _h, _j, _k, _l, _m;
        super(scope, id);
        const stack = cdk.Stack.of(this);
        if (GlobalAuroraRDSSupportRegion.indexOf(stack.region) == -1) {
            throw new Error(`This region ${stack.region} not Support Global RDS !!!`);
        }
        let rdsCredentials;
        if (props === null || props === void 0 ? void 0 : props.rdsPassword) {
            rdsCredentials = {
                username: (_a = props === null || props === void 0 ? void 0 : props.dbUserName) !== null && _a !== void 0 ? _a : 'sysadmin',
                password: cdk.SecretValue.plainText(props === null || props === void 0 ? void 0 : props.rdsPassword),
            };
        }
        else {
            rdsCredentials = {
                username: (_b = props === null || props === void 0 ? void 0 : props.dbUserName) !== null && _b !== void 0 ? _b : 'sysadmin',
            };
        }
        ;
        // Mysql need (MySQL 5.6 / version > 5.6.10a) , Postgres need (version 10.11 , 10.12 , 11.7 or later)
        this.engineVersion = (_c = props === null || props === void 0 ? void 0 : props.engineVersion) !== null && _c !== void 0 ? _c : rds.DatabaseClusterEngine.auroraMysql({
            version: rds.AuroraMysqlEngineVersion.VER_2_07_1,
        });
        this.rdsInstanceType = (_d = props === null || props === void 0 ? void 0 : props.instanceType) !== null && _d !== void 0 ? _d : InstanceTypeEnum.R5_LARGE;
        // Master region Vpc
        const rdsVpc = (_e = props === null || props === void 0 ? void 0 : props.vpc) !== null && _e !== void 0 ? _e : new ec2.Vpc(this, 'RDSVpcRegionMaster', {
            cidr: '10.108.0.0/16',
            enableDnsHostnames: true,
            enableDnsSupport: true,
            natGateways: 1,
        });
        this.dbClusterpPG = (_f = props === null || props === void 0 ? void 0 : props.dbClusterpPG) !== null && _f !== void 0 ? _f : new rds.ParameterGroup(this, 'dbClusterparametergroup', {
            engine: this.engineVersion,
            parameters: (_g = props === null || props === void 0 ? void 0 : props.parameters) !== null && _g !== void 0 ? _g : {
                time_zone: (_h = props === null || props === void 0 ? void 0 : props.timeZone) !== null && _h !== void 0 ? _h : MySQLtimeZone.UTC,
            },
        });
        let rdsVpcSubnetSelect = ec2.SubnetType.PRIVATE;
        if (this.azOfSubnets(rdsVpc.privateSubnets) === 0) {
            rdsVpcSubnetSelect = ec2.SubnetType.PUBLIC;
        }
        this.rdsCluster = new rds.DatabaseCluster(this, 'RDSCluster', {
            engine: this.engineVersion,
            parameterGroup: this.dbClusterpPG,
            clusterIdentifier: `${stack.stackName.toLowerCase()}-primary`,
            credentials: rdsCredentials,
            instances: 1,
            instanceProps: {
                // if want publicAccess , need to define vpcSubnets: { subnetType: ec2.SubnetType.PUBLIC } ,
                vpc: rdsVpc,
                vpcSubnets: { subnetType: rdsVpcSubnetSelect },
                instanceType: new ec2.InstanceType(this.rdsInstanceType),
            },
            removalPolicy: cdk.RemovalPolicy.DESTROY,
            defaultDatabaseName: (_j = props === null || props === void 0 ? void 0 : props.defaultDatabaseName) !== null && _j !== void 0 ? _j : 'globaldatabase',
        });
        this.rdsPassword = (_l = `Please use this command get password back , aws secretsmanager get-secret-value --secret-id ${(_k = this.rdsCluster.secret) === null || _k === void 0 ? void 0 : _k.secretName}`) !== null && _l !== void 0 ? _l : props === null || props === void 0 ? void 0 : props.rdsPassword;
        ;
        this.rdsCluster.node.addDependency(rdsVpc);
        this.rdsCluster.connections.allowDefaultPortFrom(ec2.Peer.ipv4(rdsVpc.vpcCidrBlock));
        // custom resource policy
        const CustomResourcePolicy = new iam.PolicyStatement({
            resources: ['*'],
            actions: ['rds:CreateGlobalCluster', 'rds:DeleteGlobalCluster', 'rds:RemoveFromGlobalCluster', 'rds:ModifyGlobalCluster'],
        });
        // Upgrade database to Global.
        const onEvent = new lambda.Function(this, 'onEventHandler', {
            runtime: lambda.Runtime.PYTHON_3_8,
            code: lambda.Code.fromAsset(path.join(__dirname, '../custom-resource-handler')),
            handler: 'global_index.on_event',
            timeout: cdk.Duration.minutes(5),
        });
        const UpgradeglobaldbProvider = new cr.Provider(this, 'UpgradeglobaldbProvider', {
            onEventHandler: onEvent,
            logRetention: logs.RetentionDays.ONE_DAY,
        });
        this.crGlobalRDSProvider = new cdk.CustomResource(this, 'CRUpgradeglobaldbProvider', {
            resourceType: 'Custom::UpgradeGlobalClusterProvider',
            serviceToken: UpgradeglobaldbProvider.serviceToken,
            properties: {
                SourceDBClusterIdentifier: `arn:aws:rds:${stack.region}:${stack.account}:cluster:${this.rdsCluster.clusterIdentifier}`,
                GlobalClusterIdentifier: `global-${stack.stackName.toLowerCase()}`,
            },
        });
        this.crGlobalRDSProvider.node.addDependency(this.rdsCluster);
        (_m = onEvent.role) === null || _m === void 0 ? void 0 : _m.addToPrincipalPolicy(CustomResourcePolicy);
        this.rdsIsPublic = rdsVpcSubnetSelect;
        new cdk.CfnOutput(this, 'RDSisPublic', {
            value: this.rdsIsPublic,
        });
        this.rdsClusterarn = `arn:aws:rds:${stack.region}:${stack.account}:cluster:${this.rdsCluster.clusterIdentifier}`;
        new cdk.CfnOutput(this, 'RDSClusterarn', {
            value: this.rdsClusterarn,
        });
        this.globalClusterIdentifier = `global-${stack.stackName.toLowerCase()}`;
        new cdk.CfnOutput(this, 'GlobalClusterIdentifier', {
            value: this.globalClusterIdentifier,
        });
        this.engine = cdk.Token.asString(this.crGlobalRDSProvider.getAtt('Engine'));
        new cdk.CfnOutput(this, 'Engine', {
            value: this.engine,
        });
        this.clusterEngineVersion = cdk.Token.asString(this.crGlobalRDSProvider.getAtt('EngineVersion'));
        new cdk.CfnOutput(this, 'clusterEngineVersion', {
            value: this.clusterEngineVersion,
        });
        this.globalClusterArn = cdk.Token.asString(this.crGlobalRDSProvider.getAtt('GlobalClusterArn'));
        new cdk.CfnOutput(this, 'GlobalClusterArn', {
            value: this.globalClusterArn,
        });
        new cdk.CfnOutput(this, 'GlobalClusterPrimaryEndpoint', {
            value: this.rdsCluster.clusterEndpoint.hostname,
        });
    }
    azOfSubnets(subnets) {
        return new Set(subnets.map(subnet => subnet.availabilityZone)).size;
    }
    /**
     * @experimental
     */
    addRegionalCluster(scope, id, options) {
        var _a;
        const stack = cdk.Stack.of(scope);
        // custom resource policy
        const CustomResourcePolicy = new iam.PolicyStatement({
            resources: ['*'],
            actions: [
                'rds:CreateGlobalCluster', 'rds:DeleteGlobalCluster', 'rds:RemoveFromGlobalCluster', 'rds:ModifyGlobalCluster',
                'rds:CreateDBCluster', 'rds:CreateDBInstance', 'rds:DeleteDBCluster', 'rds:DeleteDBInstance', 'rds:DescribeDBInstances',
                'rds:DescribeGlobalClusters',
            ],
        });
        // Upgrade database to Global.
        const onEvent = new lambda.Function(scope, `${id}-addRegionalonEvent`, {
            runtime: lambda.Runtime.PYTHON_3_8,
            code: lambda.Code.fromAsset(path.join(__dirname, '../custom-resource-handler')),
            handler: 'add_region_index.on_event',
            timeout: cdk.Duration.minutes(10),
        });
        const isComplete = new lambda.Function(scope, `${id}-IsComplete`, {
            code: lambda.Code.fromAsset(path.join(__dirname, '../custom-resource-handler')),
            handler: 'add_region_index.is_complete',
            runtime: lambda.Runtime.PYTHON_3_8,
            timeout: cdk.Duration.minutes(10),
            role: onEvent.role,
        });
        const addRegionalProvider = new cr.Provider(scope, `${id}-addRegionalProvider`, {
            onEventHandler: onEvent,
            isCompleteHandler: isComplete,
            logRetention: logs.RetentionDays.ONE_DAY,
        });
        const CRSecondRDSProvider = new cdk.CustomResource(scope, `${id}-addRegionalCustomResource`, {
            resourceType: 'Custom::addRegionalClusterProvider',
            serviceToken: addRegionalProvider.serviceToken,
            properties: {
                SourceDBClusterIdentifier: this.rdsClusterarn,
                GlobalClusterIdentifier: this.globalClusterIdentifier,
                REGION: options.region,
                DBSubnetGroupName: options.dbSubnetGroupName,
                Engine: this.engine,
                EngineVersion: this.clusterEngineVersion,
                ClusterIdentifier: `${stack.stackName.toLowerCase()}-${options.region}`,
                InstanceType: this.rdsInstanceType,
                rdsIsPublic: this.rdsIsPublic,
                secondRDSClusterArn: `arn:aws:rds:${options.region}:${stack.account}:cluster:${stack.stackName.toLowerCase()}-${options.region}`,
                seconddbInstanceIdentifier: `${stack.stackName.toLowerCase()}-${options.region}-1`,
            },
        });
        CRSecondRDSProvider.node.addDependency(this.crGlobalRDSProvider);
        (_a = onEvent.role) === null || _a === void 0 ? void 0 : _a.addToPrincipalPolicy(CustomResourcePolicy);
        new cdk.CfnOutput(scope, 'secondRDSClusterArn', {
            value: cdk.Token.asString(CRSecondRDSProvider.getAtt('secondRDSClusterArn')),
        });
        new cdk.CfnOutput(scope, 'seconddbInstanceIdentifier', {
            value: cdk.Token.asString(CRSecondRDSProvider.getAtt('seconddbInstanceIdentifier')),
        });
    }
}
exports.GolbalAuroraRDSMaster = GolbalAuroraRDSMaster;
/**
 * @experimental
 */
class GolbalAuroraRDSSlaveInfra extends cdk.Construct {
    /**
     * @experimental
     */
    constructor(scope, id, props) {
        var _a, _b;
        super(scope, id);
        const stack = cdk.Stack.of(this);
        if (GlobalAuroraRDSSupportRegion.indexOf(stack.region) == -1) {
            throw new Error(`This region ${stack.region} not Support Global RDS !!!`);
        }
        // Slave region Vpc
        const rdsVpcSecond = (_a = props === null || props === void 0 ? void 0 : props.vpc) !== null && _a !== void 0 ? _a : new ec2.Vpc(this, 'RDSVpcRegionSlave', {
            cidr: '10.109.0.0/16',
            enableDnsHostnames: true,
            enableDnsSupport: true,
            natGateways: 1,
        });
        const DBsubnetType = (_b = props === null || props === void 0 ? void 0 : props.subnetType) !== null && _b !== void 0 ? _b : ec2.SubnetType.PRIVATE;
        if (DBsubnetType === ec2.SubnetType.PRIVATE) {
            const PrivateSubnet = rdsVpcSecond.selectSubnets({ subnetType: ec2.SubnetType.PRIVATE });
            this.dbSubnetGroup = new rds.CfnDBSubnetGroup(this, 'Subnets', {
                dbSubnetGroupName: `${stack.stackName.toLowerCase()}-privatesubnetgroup`,
                dbSubnetGroupDescription: 'Private Subnets for database',
                subnetIds: PrivateSubnet.subnetIds,
            });
            cdk.Tags.of(this.dbSubnetGroup).add('Name', 'PrivateDBSubnetGroup');
            this.dbSubnetGroup.node.addDependency(rdsVpcSecond);
        }
        else {
            const PublicSubnet = rdsVpcSecond.selectSubnets({ subnetType: ec2.SubnetType.PUBLIC });
            this.dbSubnetGroup = new rds.CfnDBSubnetGroup(this, 'Subnets', {
                dbSubnetGroupName: `${stack.stackName.toLowerCase()}-publicsubnetgroup`,
                dbSubnetGroupDescription: 'Public Subnets for database',
                subnetIds: PublicSubnet.subnetIds,
            });
            cdk.Tags.of(this.dbSubnetGroup).add('Name', 'PublicDBSubnetGroup');
            this.dbSubnetGroup.node.addDependency(rdsVpcSecond);
        }
        new cdk.CfnOutput(this, 'newDBSubnetGroup', {
            value: `${this.dbSubnetGroup.dbSubnetGroupName}`,
        });
        new cdk.CfnOutput(this, 'stackRegion', {
            value: `${stack.region}`,
        });
    }
}
exports.GolbalAuroraRDSSlaveInfra = GolbalAuroraRDSSlaveInfra;
//# sourceMappingURL=data:application/json;base64,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