import type { github, GitOptions, IgnoreFileOptions, javascript, LoggerOptions, Project, ProjectType, ProjenrcJsonOptions, python, RenovatebotOptions, typescript } from 'projen';
import type { ReadmeOptions } from '../../';
/**
 * PythonPackageOptions
 */
export interface PythonPackageOptions {
    /**
     * Venv options.
     * @default - defaults
     * @stability experimental
     */
    readonly venvOptions?: python.VenvOptions;
    /**
     * Use venv to manage a virtual environment for installing dependencies inside.
     * @default - true, unless poetry is true, then false
     * @stability experimental
     * @featured true
     */
    readonly venv?: boolean;
    /**
     * Use setuptools with a setup.py script for packaging and publishing.
     * @default - true, unless poetry is true, then false
     * @stability experimental
     * @featured true
     */
    readonly setuptools?: boolean;
    /**
     * Location of sample tests.
     * Typically the same directory where project tests will be located.
     * @default "tests"
     * @stability experimental
     */
    readonly sampleTestdir?: string;
    /**
     * Include sample code and test if the relevant directories don't exist.
     * @default true
     * @stability experimental
     */
    readonly sample?: boolean;
    /**
     * pytest options.
     * @default - defaults
     * @stability experimental
     */
    readonly pytestOptions?: python.PytestOptions;
    /**
     * Include pytest tests.
     * @default true
     * @stability experimental
     * @featured true
     */
    readonly pytest?: boolean;
    /**
     * Options related to projenrc in TypeScript.
     * @default - default options
     * @stability experimental
     */
    readonly projenrcTsOptions?: typescript.ProjenrcTsOptions;
    /**
     * Use projenrc in TypeScript.
     * This will create a tsconfig file (default: `tsconfig.projen.json`)
     * and use `ts-node` in the default task to parse the project source files.
     * @default false
     * @stability experimental
     */
    readonly projenrcTs?: boolean;
    /**
     * Options related to projenrc in python.
     * @default - default options
     * @stability experimental
     */
    readonly projenrcPythonOptions?: python.ProjenrcOptions;
    /**
     * Use projenrc in Python.
     * This will install `projen` as a Python dependency and add a `synth`
     * task which will run `.projenrc.py`.
     * @default true
     * @stability experimental
     */
    readonly projenrcPython?: boolean;
    /**
     * Options related to projenrc in JavaScript.
     * @default - default options
     * @stability experimental
     */
    readonly projenrcJsOptions?: javascript.ProjenrcOptions;
    /**
     * Use projenrc in javascript.
     * This will install `projen` as a JavaScript dependency and add a `synth`
     * task which will run `.projenrc.js`.
     * @default false
     * @stability experimental
     */
    readonly projenrcJs?: boolean;
    /**
     * Use poetry to manage your project dependencies, virtual environment, and (optional) packaging/publishing.
     * This feature is incompatible with pip, setuptools, or venv.
     * If you set this option to `true`, then pip, setuptools, and venv must be set to `false`.
     * @default false
     * @stability experimental
     * @featured true
     */
    readonly poetry?: boolean;
    /**
     * Use pip with a requirements.txt file to track project dependencies.
     * @default - true, unless poetry is true, then false
     * @stability experimental
     * @featured true
     */
    readonly pip?: boolean;
    /**
     * List of dev dependencies for this project.
     * Dependencies use the format: `<module>@<semver>`
     *
     * Additional dependencies can be added via `project.addDevDependency()`.
     * @default []
     * @stability experimental
     * @featured true
     */
    readonly devDeps?: Array<string>;
    /**
     * List of runtime dependencies for this project.
     * Dependencies use the format: `<module>@<semver>`
     *
     * Additional dependencies can be added via `project.addDependency()`.
     * @default []
     * @stability experimental
     * @featured true
     */
    readonly deps?: Array<string>;
    /**
     * Name of the python package as used in imports and filenames.
     * Must only consist of alphanumeric characters and underscores.
     * @default $PYTHON_MODULE_NAME
     * @stability experimental
     */
    readonly moduleName: string;
    /**
     * Path to the python executable to use.
     * @default "python"
     * @stability experimental
     */
    readonly pythonExec?: string;
    /**
     * Additional fields to pass in the setup() function if using setuptools.
     * @stability experimental
     */
    readonly setupConfig?: Record<string, any>;
    /**
     * Additional options to set for poetry if using poetry.
     * @stability experimental
     */
    readonly poetryOptions?: python.PoetryPyprojectOptionsWithoutDeps;
    /**
     * Package name.
     * @stability experimental
     */
    readonly packageName?: string;
    /**
     * License of this package as an SPDX identifier.
     * @stability experimental
     */
    readonly license?: string;
    /**
     * A URL to the website of the project.
     * @stability experimental
     */
    readonly homepage?: string;
    /**
     * A short description of the package.
     * @stability experimental
     * @featured true
     */
    readonly description?: string;
    /**
     * A list of PyPI trove classifiers that describe the project.
     * @stability experimental
     */
    readonly classifiers?: Array<string>;
    /**
     * Version of the package.
     * @default "0.1.0"
     * @stability experimental
     * @featured true
     */
    readonly version: string;
    /**
     * Author's name.
     * @default $GIT_USER_NAME
     * @stability experimental
     */
    readonly authorName: string;
    /**
     * Author's e-mail.
     * @default $GIT_USER_EMAIL
     * @stability experimental
     */
    readonly authorEmail: string;
    /**
     * Enable VSCode integration.
     * Enabled by default for root projects. Disabled for non-root projects.
     * @default true
     * @stability experimental
     */
    readonly vscode?: boolean;
    /**
     * Auto-close stale issues and pull requests.
     * To disable set `stale` to `false`.
     * @default - see defaults in `StaleOptions`
     * @stability experimental
     */
    readonly staleOptions?: github.StaleOptions;
    /**
     * Auto-close of stale issues and pull request.
     * See `staleOptions` for options.
     * @default false
     * @stability experimental
     */
    readonly stale?: boolean;
    /**
     * Configuration of the README.md file
     */
    readonly readme?: ReadmeOptions;
    /**
     * The name of a secret which includes a GitHub Personal Access Token to be used by projen workflows.
     * This token needs to have the `repo`, `workflows`
     * and `packages` scope.
     * @default "PROJEN_GITHUB_TOKEN"
     * @deprecated use `projenCredentials`
     * @stability deprecated
     */
    readonly projenTokenSecret?: string;
    /**
     * Choose a method of providing GitHub API access for projen workflows.
     * @default - use a personal access token named PROJEN_GITHUB_TOKEN
     * @stability experimental
     */
    readonly projenCredentials?: github.GithubCredentials;
    /**
     * Which type of project this is (library/app).
     * @default ProjectType.UNKNOWN
     * @deprecated no longer supported at the base project level
     * @stability deprecated
     */
    readonly projectType?: ProjectType;
    /**
     * Options for mergify.
     * @default - default options
     * @deprecated use `githubOptions.mergifyOptions` instead
     * @stability deprecated
     */
    readonly mergifyOptions?: github.MergifyOptions;
    /**
     * Whether mergify should be enabled on this repository or not.
     * @default true
     * @deprecated use `githubOptions.mergify` instead
     * @stability deprecated
     */
    readonly mergify?: boolean;
    /**
     * Add a Gitpod development environment.
     * @default false
     * @stability experimental
     */
    readonly gitpod?: boolean;
    /**
     * Options for GitHub integration.
     * @default - see GitHubOptions
     * @stability experimental
     */
    readonly githubOptions?: github.GitHubOptions;
    /**
     * Enable GitHub integration.
     * Enabled by default for root projects. Disabled for non-root projects.
     * @default true
     * @stability experimental
     */
    readonly github?: boolean;
    /**
     * Add a VSCode development environment (used for GitHub Codespaces).
     * @default false
     * @stability experimental
     */
    readonly devContainer?: boolean;
    /**
     * Add a `clobber` task which resets the repo to origin.
     * @default - true, but false for subprojects
     * @stability experimental
     */
    readonly clobber?: boolean;
    /**
     * Configure options for automatic merging on GitHub.
     * Has no effect if
     * `github.mergify` or `autoMerge` is set to false.
     * @default - see defaults in `AutoMergeOptions`
     * @stability experimental
     */
    readonly autoMergeOptions?: github.AutoMergeOptions;
    /**
     * Enable automatic merging on GitHub.
     * Has no effect if `github.mergify`
     * is set to false.
     * @default true
     * @stability experimental
     */
    readonly autoMerge?: boolean;
    /**
     * Enable and configure the 'auto approve' workflow.
     * @default - auto approve is disabled
     * @stability experimental
     */
    readonly autoApproveOptions?: github.AutoApproveOptions;
    /**
     * Options for renovatebot.
     * @default - default options
     * @stability experimental
     */
    readonly renovatebotOptions?: RenovatebotOptions;
    /**
     * Use renovatebot to handle dependency upgrades.
     * @default false
     * @stability experimental
     */
    readonly renovatebot?: boolean;
    /**
     * Options for .projenrc.json.
     * @default - default options
     * @stability experimental
     */
    readonly projenrcJsonOptions?: ProjenrcJsonOptions;
    /**
     * Generate (once) .projenrc.json (in JSON). Set to `false` in order to disable .projenrc.json generation.
     * @default false
     * @stability experimental
     */
    readonly projenrcJson?: boolean;
    /**
     * The shell command to use in order to run the projen CLI.
     * Can be used to customize in special environments.
     * @default "npx projen"
     * @stability experimental
     */
    readonly projenCommand?: string;
    /**
     * The parent project, if this project is part of a bigger project.
     * @stability experimental
     */
    readonly parent?: Project;
    /**
     * The root directory of the project.
     * Relative to this directory, all files are synthesized.
     *
     * If this project has a parent, this directory is relative to the parent
     * directory and it cannot be the same as the parent or any of it's other
     * subprojects.
     * @default "."
     * @stability experimental
     */
    readonly outdir?: string;
    /**
     * Configure logging options such as verbosity.
     * @default {}
     * @stability experimental
     */
    readonly logging?: LoggerOptions;
    /**
     * Configuration options for git.
     * @stability experimental
     */
    readonly gitOptions?: GitOptions;
    /**
     * Configuration options for .gitignore file.
     * @stability experimental
     */
    readonly gitIgnoreOptions?: IgnoreFileOptions;
    /**
     * Whether to commit the managed files by default.
     * @default true
     * @stability experimental
     */
    readonly commitGenerated?: boolean;
    /**
     * This is the name of your project.
     * @default $BASEDIR
     * @stability experimental
     * @featured true
     */
    readonly name: string;
    /**
     * List of teams used to generate the CODEOWNERS file
     */
    readonly codeOwners: Array<string>;
    /**
     * Include a GitHub pull request template.
     * @default true
     */
    readonly pullRequestTemplate?: boolean;
    /**
     * The contents of the pull request template.
     * @default default content
     */
    readonly pullRequestTemplateContents?: Array<string>;
}
