# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['CertificateArgs', 'Certificate']

@pulumi.input_type
class CertificateArgs:
    def __init__(__self__, *,
                 certificate: pulumi.Input[_builtins.str],
                 private_key: Optional[pulumi.Input[_builtins.str]] = None,
                 snis: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a Certificate resource.
        :param pulumi.Input[_builtins.str] certificate: should be the public key of your certificate it is mapped to the `Cert` parameter on the Kong API.
        :param pulumi.Input[_builtins.str] private_key: should be the private key of your certificate it is mapped to the `Key` parameter on the Kong API.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] snis: A list of strings associated with the Certificate for grouping and filtering
        """
        pulumi.set(__self__, "certificate", certificate)
        if private_key is not None:
            pulumi.set(__self__, "private_key", private_key)
        if snis is not None:
            pulumi.set(__self__, "snis", snis)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter
    def certificate(self) -> pulumi.Input[_builtins.str]:
        """
        should be the public key of your certificate it is mapped to the `Cert` parameter on the Kong API.
        """
        return pulumi.get(self, "certificate")

    @certificate.setter
    def certificate(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "certificate", value)

    @_builtins.property
    @pulumi.getter(name="privateKey")
    def private_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        should be the private key of your certificate it is mapped to the `Key` parameter on the Kong API.
        """
        return pulumi.get(self, "private_key")

    @private_key.setter
    def private_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "private_key", value)

    @_builtins.property
    @pulumi.getter
    def snis(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of strings associated with the Certificate for grouping and filtering
        """
        return pulumi.get(self, "snis")

    @snis.setter
    def snis(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "snis", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _CertificateState:
    def __init__(__self__, *,
                 certificate: Optional[pulumi.Input[_builtins.str]] = None,
                 private_key: Optional[pulumi.Input[_builtins.str]] = None,
                 snis: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering Certificate resources.
        :param pulumi.Input[_builtins.str] certificate: should be the public key of your certificate it is mapped to the `Cert` parameter on the Kong API.
        :param pulumi.Input[_builtins.str] private_key: should be the private key of your certificate it is mapped to the `Key` parameter on the Kong API.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] snis: A list of strings associated with the Certificate for grouping and filtering
        """
        if certificate is not None:
            pulumi.set(__self__, "certificate", certificate)
        if private_key is not None:
            pulumi.set(__self__, "private_key", private_key)
        if snis is not None:
            pulumi.set(__self__, "snis", snis)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter
    def certificate(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        should be the public key of your certificate it is mapped to the `Cert` parameter on the Kong API.
        """
        return pulumi.get(self, "certificate")

    @certificate.setter
    def certificate(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "certificate", value)

    @_builtins.property
    @pulumi.getter(name="privateKey")
    def private_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        should be the private key of your certificate it is mapped to the `Key` parameter on the Kong API.
        """
        return pulumi.get(self, "private_key")

    @private_key.setter
    def private_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "private_key", value)

    @_builtins.property
    @pulumi.getter
    def snis(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of strings associated with the Certificate for grouping and filtering
        """
        return pulumi.get(self, "snis")

    @snis.setter
    def snis(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "snis", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.type_token("kong:index/certificate:Certificate")
class Certificate(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 certificate: Optional[pulumi.Input[_builtins.str]] = None,
                 private_key: Optional[pulumi.Input[_builtins.str]] = None,
                 snis: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        ## # Certificate

        For more information on creating certificates in Kong [see their documentation](https://docs.konghq.com/gateway-oss/2.5.x/admin-api/#certificate-object)

        ## Example Usage

        ```python
        import pulumi
        import pulumi_kong as kong

        certificate = kong.Certificate("certificate",
            certificate="public key --- 123 ----",
            private_key="private key --- 456 ----",
            snis=[
                "foo.com",
                "bar.com",
            ],
            tags=["myTag"])
        ```

        ## Import

        To import a certificate:

        ```sh
        $ pulumi import kong:index/certificate:Certificate <certifcate_identifier> <certificate_id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] certificate: should be the public key of your certificate it is mapped to the `Cert` parameter on the Kong API.
        :param pulumi.Input[_builtins.str] private_key: should be the private key of your certificate it is mapped to the `Key` parameter on the Kong API.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] snis: A list of strings associated with the Certificate for grouping and filtering
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CertificateArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## # Certificate

        For more information on creating certificates in Kong [see their documentation](https://docs.konghq.com/gateway-oss/2.5.x/admin-api/#certificate-object)

        ## Example Usage

        ```python
        import pulumi
        import pulumi_kong as kong

        certificate = kong.Certificate("certificate",
            certificate="public key --- 123 ----",
            private_key="private key --- 456 ----",
            snis=[
                "foo.com",
                "bar.com",
            ],
            tags=["myTag"])
        ```

        ## Import

        To import a certificate:

        ```sh
        $ pulumi import kong:index/certificate:Certificate <certifcate_identifier> <certificate_id>
        ```

        :param str resource_name: The name of the resource.
        :param CertificateArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CertificateArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 certificate: Optional[pulumi.Input[_builtins.str]] = None,
                 private_key: Optional[pulumi.Input[_builtins.str]] = None,
                 snis: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CertificateArgs.__new__(CertificateArgs)

            if certificate is None and not opts.urn:
                raise TypeError("Missing required property 'certificate'")
            __props__.__dict__["certificate"] = certificate
            __props__.__dict__["private_key"] = None if private_key is None else pulumi.Output.secret(private_key)
            __props__.__dict__["snis"] = snis
            __props__.__dict__["tags"] = tags
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["privateKey"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Certificate, __self__).__init__(
            'kong:index/certificate:Certificate',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            certificate: Optional[pulumi.Input[_builtins.str]] = None,
            private_key: Optional[pulumi.Input[_builtins.str]] = None,
            snis: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None) -> 'Certificate':
        """
        Get an existing Certificate resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] certificate: should be the public key of your certificate it is mapped to the `Cert` parameter on the Kong API.
        :param pulumi.Input[_builtins.str] private_key: should be the private key of your certificate it is mapped to the `Key` parameter on the Kong API.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] snis: A list of strings associated with the Certificate for grouping and filtering
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CertificateState.__new__(_CertificateState)

        __props__.__dict__["certificate"] = certificate
        __props__.__dict__["private_key"] = private_key
        __props__.__dict__["snis"] = snis
        __props__.__dict__["tags"] = tags
        return Certificate(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def certificate(self) -> pulumi.Output[_builtins.str]:
        """
        should be the public key of your certificate it is mapped to the `Cert` parameter on the Kong API.
        """
        return pulumi.get(self, "certificate")

    @_builtins.property
    @pulumi.getter(name="privateKey")
    def private_key(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        should be the private key of your certificate it is mapped to the `Key` parameter on the Kong API.
        """
        return pulumi.get(self, "private_key")

    @_builtins.property
    @pulumi.getter
    def snis(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        A list of strings associated with the Certificate for grouping and filtering
        """
        return pulumi.get(self, "snis")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        return pulumi.get(self, "tags")

