# Generated by Django 4.2.9 on 2024-02-15 17:18

import django.db.models.deletion
from django.db import migrations, models


class Migration(migrations.Migration):
    initial = True

    dependencies = [
        ("geography", "0001_initial"),
        ("currency", "0001_initial"),
        ("directory", "0006_employeremployeerelationship_position_name"),
    ]

    operations = [
        migrations.SeparateDatabaseAndState(
            state_operations=[
                migrations.CreateModel(
                    name="AssetAllocationType",
                    fields=[
                        (
                            "id",
                            models.BigAutoField(
                                auto_created=True, primary_key=True, serialize=False, verbose_name="ID"
                            ),
                        ),
                        ("name", models.CharField(max_length=255)),
                        (
                            "default_max_investment",
                            models.DecimalField(
                                decimal_places=4,
                                default=0.1,
                                help_text="The default percentage this allocation is counted towards the potential.",
                                max_digits=5,
                            ),
                        ),
                    ],
                    options={
                        "verbose_name": "Asset Allocation Type",
                        "verbose_name_plural": "Asset Allocation Types",
                    },
                ),
                migrations.CreateModel(
                    name="GeographicFocus",
                    fields=[
                        (
                            "id",
                            models.BigAutoField(
                                auto_created=True, primary_key=True, serialize=False, verbose_name="ID"
                            ),
                        ),
                        ("percent", models.DecimalField(decimal_places=4, max_digits=5)),
                        ("comment", models.TextField(default="")),
                        (
                            "company",
                            models.ForeignKey(
                                on_delete=django.db.models.deletion.CASCADE,
                                related_name="geographic_focuses",
                                to="directory.company",
                            ),
                        ),
                        (
                            "country",
                            models.ForeignKey(
                                on_delete=django.db.models.deletion.PROTECT,
                                to="geography.geography",
                                verbose_name="Location",
                            ),
                        ),
                    ],
                    options={
                        "verbose_name": "Geographic Focus",
                        "verbose_name_plural": "Geographic Focuses",
                    },
                ),
                migrations.CreateModel(
                    name="CompanyPortfolioData",
                    fields=[
                        (
                            "id",
                            models.BigAutoField(
                                auto_created=True, primary_key=True, serialize=False, verbose_name="ID"
                            ),
                        ),
                        (
                            "assets_under_management",
                            models.DecimalField(
                                blank=True,
                                decimal_places=2,
                                help_text="The Assets under Management (AUM) that is managed by this company or this person's primary employer.",
                                max_digits=17,
                                null=True,
                                verbose_name="AUM",
                            ),
                        ),
                        (
                            "invested_assets_under_management_usd",
                            models.DecimalField(
                                blank=True,
                                decimal_places=2,
                                help_text="The invested Assets under Management (AUM).",
                                max_digits=17,
                                null=True,
                                verbose_name="Invested AUM ($)",
                            ),
                        ),
                        (
                            "investment_discretion",
                            models.CharField(
                                choices=[
                                    ("FULLY_DISCRETIONAIRY", "Fully Discretionairy"),
                                    ("MOSTLY_DISCRETIONAIRY", "Mostly Discretionairy"),
                                    ("MIXED", "Mixed"),
                                    ("MOSTLY_ADVISORY", "Mostly Advisory"),
                                    ("FULLY_ADVISORY", "Fully Advisory"),
                                ],
                                default="MIXED",
                                help_text="What discretion this company or this person's primary employer has to invest its assets.",
                                max_length=21,
                                verbose_name="Investment Discretion",
                            ),
                        ),
                        (
                            "potential",
                            models.DecimalField(
                                blank=True,
                                decimal_places=2,
                                help_text="\n        The potential reflects how much potential a company (regardless whether client/propective) has. The formula to calculate the potential is:\n\n        AUM * Asset Allocation Percent * Asset Allocation Max Investment - Invested AUM.\n    ",
                                max_digits=19,
                                null=True,
                            ),
                        ),
                        (
                            "assets_under_management_currency",
                            models.ForeignKey(
                                blank=True,
                                null=True,
                                on_delete=django.db.models.deletion.PROTECT,
                                to="currency.currency",
                                verbose_name="AUM Currency",
                            ),
                        ),
                        (
                            "company",
                            models.OneToOneField(
                                on_delete=django.db.models.deletion.CASCADE,
                                related_name="portfolio_data",
                                to="directory.company",
                            ),
                        ),
                        (
                            "potential_currency",
                            models.ForeignKey(
                                blank=True,
                                null=True,
                                on_delete=django.db.models.deletion.PROTECT,
                                related_name="wbportfolio_potential_currencies",
                                to="currency.currency",
                            ),
                        ),
                    ],
                    options={
                        "verbose_name": "Company Portfolio Data",
                        "verbose_name_plural": "Company Portfolio Data",
                    },
                ),
                migrations.CreateModel(
                    name="AssetAllocation",
                    fields=[
                        (
                            "id",
                            models.BigAutoField(
                                auto_created=True, primary_key=True, serialize=False, verbose_name="ID"
                            ),
                        ),
                        ("percent", models.DecimalField(decimal_places=4, max_digits=5)),
                        (
                            "max_investment",
                            models.DecimalField(
                                blank=True,
                                decimal_places=4,
                                help_text="The percentage this allocation is counted towards the potential. Defaults to the default provided in the asset type.",
                                max_digits=5,
                                null=True,
                            ),
                        ),
                        ("comment", models.TextField(default="")),
                        (
                            "asset_type",
                            models.ForeignKey(
                                on_delete=django.db.models.deletion.PROTECT,
                                related_name="asset_allocations",
                                to="company_portfolio.assetallocationtype",
                            ),
                        ),
                        (
                            "company",
                            models.ForeignKey(
                                on_delete=django.db.models.deletion.CASCADE,
                                related_name="asset_allocations",
                                to="directory.company",
                            ),
                        ),
                    ],
                    options={
                        "verbose_name": "Asset Allocation",
                        "verbose_name_plural": "Asset Allocations",
                    },
                ),
            ],
            database_operations=[],
        ),
    ]
