# Generated by Django 5.0.14 on 2025-07-30 14:40

from decimal import Decimal
from django.db import migrations, models
from tqdm import tqdm

def migrate_desired_target_weight(apps, schema_editor):
    from wbportfolio.models.orders import Order, OrderProposal
    objs = []
    qs = OrderProposal.objects.filter(orders__isnull=False).distinct()
    for op in tqdm(qs, total=qs.count()):
        for o in op.get_orders():
            o.desired_target_weight = o._target_weight
            objs.append(o)
    Order.objects.bulk_update(objs, ["desired_target_weight"], batch_size=10000)


class Migration(migrations.Migration):

    dependencies = [
        ('wbportfolio', '0084_orderproposal_min_order_value'),
    ]

    operations = [
        migrations.RunPython(migrate_desired_target_weight)
    ]
