# Generated by Django 5.0.14 on 2025-08-11 14:01

import django.db.models.deletion
import django_fsm
from django.db import migrations, models

def migrate_approve_to_apply(apps, schema_editor):
    OrderProposal = apps.get_model("wbportfolio", "OrderProposal")
    OrderProposal.objects.filter(status="APPROVED").update(status="APPLIED")


class Migration(migrations.Migration):

    dependencies = [
        ('wbportfolio', '0086_orderproposal_total_cash_weight'),
    ]

    operations = [
        migrations.AddField(
            model_name='product',
            name='order_routing_custodian_adapter',
            field=models.CharField(blank=True, help_text='The dotted path to the order routing custodian adapter', max_length=1024, null=True, verbose_name='Order Routing Custodian Adapter'),
        ),
        migrations.AddField(
            model_name='order',
            name='execution_comment',
            field=models.TextField(blank=True, default='', verbose_name='Execution Comment'),
        ),
        migrations.AddField(
            model_name='order',
            name='execution_confirmed',
            field=models.BooleanField(default=False, verbose_name='Execution Confirmed'),
        ),
        migrations.AddField(
            model_name='orderproposal',
            name='approver',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT,
                                    related_name='approver_order_proposals', to='directory.person',
                                    verbose_name='Approver'),
        ),
        migrations.AddField(
            model_name='orderproposal',
            name='execution_comment',
            field=models.CharField(blank=True, default='', verbose_name='Execution Comment'),
        ),
        migrations.AddField(
            model_name='orderproposal',
            name='execution_status',
            field=models.CharField(blank=True, choices=[('PENDING', 'Pending'), ('IN_DRAFT', 'In Draft'),
                                                        ('COMPLETED', 'Completed'), ('CANCELLED', 'Cancelled'),
                                                        ('REJECTED', 'Rejected'), ('FAILED', 'Failed'),
                                                        ('UNKNOWN', 'Unknown')], default='',
                                   verbose_name='Execution Status'),
        ),
        migrations.AddField(
            model_name='orderproposal',
            name='execution_status_detail',
            field=models.CharField(blank=True, default='', verbose_name='Execution Status Detail'),
        ),
        migrations.AlterField(
            model_name='orderproposal',
            name='status',
            field=django_fsm.FSMField(choices=[('DRAFT', 'Draft'), ('SUBMIT', 'Pending'), ('APPROVED', 'Approved'),
                                               ('PENDING_EXECUTION', 'Pending Execution'), ('EXECUTED', 'Executed'),
                                               ('DENIED', 'Denied'), ('FAILED', 'Failed')], default='DRAFT',
                                      max_length=50, verbose_name='Status'),
        ),
        migrations.AddField(
            model_name='index',
            name='order_routing_custodian_adapter',
            field=models.CharField(blank=True, help_text='The dotted path to the order routing custodian adapter',
                                   max_length=1024, null=True, verbose_name='Order Routing Custodian Adapter'),
        ),
        migrations.AddField(
            model_name='productgroup',
            name='order_routing_custodian_adapter',
            field=models.CharField(blank=True, help_text='The dotted path to the order routing custodian adapter',
                                   max_length=1024, null=True, verbose_name='Order Routing Custodian Adapter'),
        ),
        migrations.RenameField(
            model_name='rebalancer',
            old_name='approve_order_proposal_automatically',
            new_name='apply_order_proposal_automatically',
        ),
        migrations.RunPython(migrate_approve_to_apply),
        migrations.AlterField(
            model_name='orderproposal',
            name='status',
            field=django_fsm.FSMField(
                choices=[('DRAFT', 'Draft'), ('PENDING', 'Pending'), ('APPROVED', 'Approved'), ('DENIED', 'Denied'),
                         ('APPLIED', 'Applied'), ('EXECUTION', 'Execution'), ('FAILED', 'Failed')], default='DRAFT',
                max_length=50, verbose_name='Status'),
        ),
    ]
