# Project Memory Configuration

This project uses KuzuMemory for intelligent context management.

## Project Information
- **Path**: /Users/masa/Projects/claude-mpm
- **Language**: Python
- **Framework**: Flask

## Memory Integration

KuzuMemory is configured to enhance all AI interactions with project-specific context.

### Available Commands:
- `kuzu-memory enhance <prompt>` - Enhance prompts with project context
- `kuzu-memory learn <content>` - Store learning from conversations (async)
- `kuzu-memory recall <query>` - Query project memories
- `kuzu-memory stats` - View memory statistics

### MCP Tools Available:
When interacting with Claude Desktop, the following MCP tools are available:
- **kuzu_enhance**: Enhance prompts with project memories
- **kuzu_learn**: Store new learnings asynchronously
- **kuzu_recall**: Query specific memories
- **kuzu_stats**: Get memory system statistics

## Project Context

Claude Multi-Agent Project Manager - Orchestrate Claude with agent delegation and ticket tracking

## Key Technologies
- Python
- Flask
- Flask

## Development Guidelines

**📚 IMPORTANT: Read [CONTRIBUTING.md](CONTRIBUTING.md) first for complete development guidelines.**

CONTRIBUTING.md is your primary guide for:
- **Quality Workflow**: `make lint-fix`, `make quality`, `make safe-release-build`
- **Code Structure**: Where files belong (scripts, tests, modules)
- **Commit Guidelines**: Conventional commits format (feat:, fix:, docs:, etc.)
- **Testing Requirements**: 85%+ coverage, comprehensive test suites
- **Architecture Standards**: Service-oriented architecture, interface contracts

### Quick Development Commands

```bash
# During development - auto-fix issues
make lint-fix

# Before every commit - comprehensive checks
make quality

# For releases - quality gate + build
make safe-release-build
```

### Project Organization

- See [CONTRIBUTING.md](CONTRIBUTING.md) for complete file placement rules
- ALL scripts go in `/scripts/`, NEVER in project root
- ALL tests go in `/tests/`, NEVER in project root
- Python modules always under `/src/claude_mpm/`

### Memory Integration (KuzuMemory)

- Use kuzu-memory enhance for all AI interactions
- Store important decisions with kuzu-memory learn
- Query context with kuzu-memory recall when needed
- Keep memories project-specific and relevant

## Memory Guidelines

- Store project decisions and conventions
- Record technical specifications and API details
- Capture user preferences and patterns
- Document error solutions and workarounds

## Deployment and Release

**Complete deployment guide**: See [docs/reference/DEPLOY.md](docs/reference/DEPLOY.md)

### Homebrew Tap Integration

The Homebrew tap is automatically updated during release workflow (Phase 5.5):

**Quick Commands**:
```bash
# Test update without changes
make update-homebrew-tap-dry-run

# Trigger manual update (if automation fails)
make update-homebrew-tap

# Update via manage_version script
./scripts/manage_version.py update-homebrew --dry-run
```

**Automatic Integration**:
- Runs automatically during `make release-publish`
- Non-blocking: Homebrew failures don't stop PyPI releases
- Phase 1: Requires manual push confirmation
- Retry logic: 10 attempts with exponential backoff

**Manual Fallback** (if automation fails):
```bash
cd /path/to/homebrew-claude-mpm
./scripts/update_formula.sh $(cat VERSION)
git add Formula/claude-mpm.rb
git commit -m "feat: update to v$(cat VERSION)"
git push origin main
```

**Key Points**:
- ✅ Non-blocking design ensures PyPI always releases
- ✅ Automatic SHA256 fetching from PyPI
- ✅ Local formula testing before commit
- ✅ Comprehensive error handling and logging
- ⚠️ See [docs/reference/HOMEBREW_UPDATE_TROUBLESHOOTING.md](docs/reference/HOMEBREW_UPDATE_TROUBLESHOOTING.md) for troubleshooting

---

*Generated by KuzuMemory Claude Hooks Installer*
