const e=window.io;class t{constructor(){this.socket=null,this.port=null,this.connectionCallbacks={connect:[],disconnect:[],error:[],event:[]},this.eventSchema={required:["source","type","subtype","timestamp","data"],optional:["event","session_id"]},this.isConnected=!1,this.isConnecting=!1,this.lastConnectTime=null,this.disconnectTime=null,this.events=[],this.sessions=new Map,this.currentSessionId=null,this.eventQueue=[],this.maxQueueSize=100,this.retryAttempts=0,this.maxRetryAttempts=5,this.retryDelays=[1e3,2e3,3e3,4e3,5e3],this.pendingEmissions=new Map,this.lastPingTime=null,this.lastPongTime=null,this.pingTimeout=12e4,this.healthCheckInterval=null,this.startStatusCheckFallback(),this.startHealthMonitoring()}connect(e="8765"){this.port=e;const t=`http://localhost:${e}`;if(this.socket&&(this.socket.connected||this.socket.connecting))return console.log("Already connected or connecting, disconnecting first..."),this.socket.disconnect(),void setTimeout(()=>this.doConnect(t),100);this.doConnect(t)}doConnect(t){if(console.log(`Connecting to Socket.IO server at ${t}`),void 0===e)return console.error("Socket.IO library not loaded! Make sure socket.io.min.js is loaded before this script."),void this.notifyConnectionStatus("Socket.IO library not loaded","error");this.isConnecting=!0,this.notifyConnectionStatus("Connecting...","connecting"),this.socket=e(t,{autoConnect:!0,reconnection:!0,reconnectionDelay:1e3,reconnectionDelayMax:1e4,reconnectionAttempts:10,timeout:3e4,forceNew:!0,transports:["websocket","polling"]}),this.setupSocketHandlers()}setupSocketHandlers(){this.socket.on("connect",()=>{console.log("Connected to Socket.IO server");const e=this.isConnected;if(this.isConnected=!0,this.isConnecting=!1,this.lastConnectTime=Date.now(),this.retryAttempts=0,this.disconnectTime&&!1===e){const e=(Date.now()-this.disconnectTime)/1e3;console.log(`Reconnected after ${e.toFixed(1)}s downtime`),this.flushEventQueue()}this.notifyConnectionStatus("Connected","connected"),window.socket=this.socket,console.log("SocketClient: Exposed socket globally as window.socket"),this.connectionCallbacks.connect.forEach(e=>e(this.socket.id)),this.requestStatus()}),this.socket.on("disconnect",e=>{const t={reason:e,timestamp:(new Date).toISOString(),wasConnected:this.isConnected,uptimeSeconds:this.lastConnectTime?((Date.now()-this.lastConnectTime)/1e3).toFixed(1):0,lastPing:this.lastPingTime?((Date.now()-this.lastPingTime)/1e3).toFixed(1)+"s ago":"never",lastPong:this.lastPongTime?((Date.now()-this.lastPongTime)/1e3).toFixed(1)+"s ago":"never"};console.log("Disconnected from server:",t),this.isConnected=!1,this.isConnecting=!1,this.disconnectTime=Date.now(),this.notifyConnectionStatus(`Disconnected: ${e}`,"disconnected"),this.connectionCallbacks.disconnect.forEach(t=>t(e));["transport close","ping timeout","transport error","io server disconnect"].includes(e)?(console.log(`Auto-reconnect triggered for reason: ${e}`),this.scheduleReconnect()):"io client disconnect"===e?console.log("Client-initiated disconnect, not auto-reconnecting"):(console.log(`Unknown disconnect reason: ${e}, attempting reconnect anyway`),this.scheduleReconnect())}),this.socket.on("connect_error",e=>{console.error("Connection error:",e),this.isConnecting=!1;const t=e.message||e.description||"Unknown error";this.notifyConnectionStatus(`Connection Error: ${t}`,"disconnected"),this.addEvent({type:"connection.error",timestamp:(new Date).toISOString(),data:{error:t,url:this.socket.io.uri,retry_attempt:this.retryAttempts}}),this.connectionCallbacks.error.forEach(e=>e(t)),this.scheduleReconnect()}),this.socket.on("claude_event",e=>{console.log("Received claude_event:",e);const t=this.validateEventSchema(e);if(!t)return void console.warn("Invalid event schema received:",e);t.type&&t.type.startsWith("code:")&&console.log("Code analysis event received via claude_event, adding to events list for troubleshooting:",t.type);const n=this.transformEvent(t);console.log("Transformed event:",n),this.addEvent(n)}),this.socket.on("ping",e=>{this.lastPingTime=Date.now(),this.socket.emit("pong",{timestamp:e.timestamp,client_time:Date.now()})}),this.socket.on("pong",e=>{this.lastPongTime=Date.now()}),this.socket.on("heartbeat",e=>{console.log("🫀 Received server heartbeat:",e),this.addEvent({type:"system",subtype:"heartbeat",timestamp:e.timestamp||(new Date).toISOString(),data:e}),this.lastPingTime=Date.now(),console.log(`Server heartbeat #${e.heartbeat_number}: ${e.server_uptime_formatted} uptime, ${e.connected_clients} clients connected`)}),this.socket.on("session.started",e=>{this.addEvent({type:"session",subtype:"started",timestamp:(new Date).toISOString(),data:e})}),this.socket.on("session.ended",e=>{this.addEvent({type:"session",subtype:"ended",timestamp:(new Date).toISOString(),data:e})}),this.socket.on("claude.request",e=>{this.addEvent({type:"claude",subtype:"request",timestamp:(new Date).toISOString(),data:e})}),this.socket.on("claude.response",e=>{this.addEvent({type:"claude",subtype:"response",timestamp:(new Date).toISOString(),data:e})}),this.socket.on("agent.loaded",e=>{this.addEvent({type:"agent",subtype:"loaded",timestamp:(new Date).toISOString(),data:e})}),this.socket.on("agent.executed",e=>{this.addEvent({type:"agent",subtype:"executed",timestamp:(new Date).toISOString(),data:e})}),this.socket.on("todo.updated",e=>{this.addEvent({type:"todo",subtype:"updated",timestamp:(new Date).toISOString(),data:e})}),this.socket.on("memory.operation",e=>{this.addEvent({type:"memory",subtype:"operation",timestamp:(new Date).toISOString(),data:e})}),this.socket.on("log.entry",e=>{this.addEvent({type:"log",subtype:"entry",timestamp:(new Date).toISOString(),data:e})}),this.socket.on("code:analysis:queued",e=>{console.log("Code analysis queued event received, adding to events list for troubleshooting"),this.addEvent({type:"code",subtype:"analysis:queued",timestamp:(new Date).toISOString(),data:e})}),this.socket.on("code:analysis:accepted",e=>{console.log("Code analysis accepted event received, adding to events list for troubleshooting"),this.addEvent({type:"code",subtype:"analysis:accepted",timestamp:(new Date).toISOString(),data:e})}),this.socket.on("code:analysis:start",e=>{console.log("Code analysis start event received, adding to events list for troubleshooting"),this.addEvent({type:"code",subtype:"analysis:start",timestamp:(new Date).toISOString(),data:e})}),this.socket.on("code:analysis:complete",e=>{console.log("Code analysis complete event received, adding to events list for troubleshooting"),this.addEvent({type:"code",subtype:"analysis:complete",timestamp:(new Date).toISOString(),data:e})}),this.socket.on("code:analysis:error",e=>{console.log("Code analysis error event received, adding to events list for troubleshooting"),this.addEvent({type:"code",subtype:"analysis:error",timestamp:(new Date).toISOString(),data:e})}),this.socket.on("code:file:start",e=>{console.log("Code file start event received, adding to events list for troubleshooting"),this.addEvent({type:"code",subtype:"file:start",timestamp:(new Date).toISOString(),data:e})}),this.socket.on("code:node:found",e=>{console.log("Code node found event received, adding to events list for troubleshooting"),this.addEvent({type:"code",subtype:"node:found",timestamp:(new Date).toISOString(),data:e})}),this.socket.on("code:analysis:progress",e=>{console.log("Code analysis progress event received, adding to events list for troubleshooting"),this.addEvent({type:"code",subtype:"analysis:progress",timestamp:(new Date).toISOString(),data:e})}),this.socket.on("history",e=>{console.log("Received event history:",e),e&&Array.isArray(e.events)?(console.log(`Processing ${e.events.length} historical events (${e.count} sent, ${e.total_available} total available)`),e.events.forEach(e=>{const t=this.transformEvent(e);this.addEvent(t,!1)}),this.notifyEventUpdate(),console.log(`Event history loaded: ${e.events.length} events added to dashboard`),document.dispatchEvent(new CustomEvent("historyLoaded",{detail:{eventCount:e.events.length,totalAvailable:e.total_available}}))):Array.isArray(e)&&(console.log("Received legacy event history format:",e.length,"events"),e.forEach(e=>{const t=this.transformEvent(e);this.addEvent(t,!1)}),this.notifyEventUpdate(),document.dispatchEvent(new CustomEvent("historyLoaded",{detail:{eventCount:e.length,totalAvailable:e.length}})))}),this.socket.on("system.status",e=>{console.log("Received system status:",e),e.sessions&&this.updateSessions(e.sessions),e.current_session&&(this.currentSessionId=e.current_session)})}disconnect(){this.socket&&(this.socket.disconnect(),this.socket=null),this.port=null,this.isConnected=!1,this.isConnecting=!1}emitWithRetry(e,t=null,n={}){const{maxRetries:o=3,retryDelays:s=[1e3,2e3,4e3],onSuccess:i=null,onFailure:a=null}=n,c=`${e}_${Date.now()}_${Math.random()}`,l=(n=0)=>{if(this.socket&&this.socket.connected)try{this.socket.emit(e,t),console.log(`Emitted ${e} successfully`),this.pendingEmissions.delete(c),i&&i()}catch(r){if(console.error(`Failed to emit ${e} (attempt ${n+1}):`,r),n<o-1){const o=s[n]||s[s.length-1];console.log(`Retrying ${e} in ${o}ms...`),this.pendingEmissions.set(c,{event:e,data:t,attemptNum:n+1,scheduledTime:Date.now()+o}),setTimeout(()=>l(n+1),o)}else console.error(`Failed to emit ${e} after ${o} attempts`),this.pendingEmissions.delete(c),a&&a("max_retries_exceeded")}else 0===n&&(this.queueEvent(e,t),console.log(`Queued ${e} for later emission (disconnected)`),a&&a("disconnected"))};l()}queueEvent(e,t){if(this.eventQueue.length>=this.maxQueueSize){const e=this.eventQueue.shift();console.warn(`Event queue full, dropped oldest event: ${e.event}`)}this.eventQueue.push({event:e,data:t,timestamp:Date.now()})}flushEventQueue(){if(0===this.eventQueue.length)return;console.log(`Flushing ${this.eventQueue.length} queued events...`);const e=[...this.eventQueue];this.eventQueue=[],e.forEach((e,t)=>{setTimeout(()=>{this.socket&&this.socket.connected&&(this.socket.emit(e.event,e.data),console.log(`Flushed queued event: ${e.event}`))},100*t)})}scheduleReconnect(){if(this.retryAttempts>=this.maxRetryAttempts)return console.log("Max reconnection attempts reached, stopping auto-reconnect"),void this.notifyConnectionStatus("Reconnection failed","disconnected");const e=this.retryDelays[this.retryAttempts]||this.retryDelays[this.retryDelays.length-1];this.retryAttempts++,console.log(`Scheduling reconnect attempt ${this.retryAttempts}/${this.maxRetryAttempts} in ${e}ms...`),this.notifyConnectionStatus(`Reconnecting in ${e/1e3}s...`,"connecting"),setTimeout(()=>{!this.isConnected&&this.port&&(console.log(`Attempting reconnection ${this.retryAttempts}/${this.maxRetryAttempts}...`),this.connect(this.port))},e)}requestStatus(){this.socket&&this.socket.connected&&(console.log("Requesting server status..."),this.emitWithRetry("request.status",null,{maxRetries:2,retryDelays:[500,1e3]}))}requestHistory(e={}){if(this.socket&&this.socket.connected){const t={limit:e.limit||50,event_types:e.event_types||[]};console.log("Requesting event history...",t),this.emitWithRetry("get_history",t,{maxRetries:3,retryDelays:[1e3,2e3,3e3],onFailure:e=>{console.error(`Failed to request history: ${e}`)}})}else console.warn("Cannot request history: not connected to server")}addEvent(e,t=!0){if(e.timestamp||(e.timestamp=(new Date).toISOString()),e.id||(e.id=Date.now()+Math.random()),this.events.push(e),e.data&&e.data.session_id){const t=e.data.session_id;this.sessions.has(t)||this.sessions.set(t,{id:t,startTime:e.timestamp,lastActivity:e.timestamp,eventCount:0,working_directory:null,git_branch:null});const n=this.sessions.get(t);n.lastActivity=e.timestamp,n.eventCount++;const o=[e.data.cwd,e.data.working_directory,e.data.working_dir,e.data.workingDirectory,e.data.instance_info?.working_dir,e.data.instance_info?.working_directory,e.data.instance_info?.cwd,e.cwd,e.working_directory,e.working_dir];for(const e of o)if(e&&"string"==typeof e&&e.trim()){n.working_directory=e,console.log(`[SOCKET-CLIENT] Found working directory for session ${t}:`,e);break}e.data.git_branch?n.git_branch=e.data.git_branch:e.data.instance_info&&e.data.instance_info.git_branch&&(n.git_branch=e.data.instance_info.git_branch)}t&&this.notifyEventUpdate()}updateSessions(e){Array.isArray(e)&&e.forEach(e=>{this.sessions.set(e.id,e)})}clearEvents(){this.events=[],this.sessions.clear(),this.notifyEventUpdate()}refreshHistory(e={}){this.clearEvents(),this.requestHistory(e)}getEventsBySession(e=null){return e?this.events.filter(t=>t.data&&t.data.session_id===e):this.events}onConnection(e,t){this.connectionCallbacks[e]&&this.connectionCallbacks[e].push(t)}onEventUpdate(e){this.connectionCallbacks.event.push(e)}on(e,t){if(this.socket)return this.socket.on(e,t);console.warn(`Cannot subscribe to '${e}': socket not initialized`)}off(e,t){if(this.socket)return this.socket.off(e,t);console.warn(`Cannot unsubscribe from '${e}': socket not initialized`)}notifyConnectionStatus(e,t){console.log(`SocketClient: Connection status changed to '${e}' (${t})`),this.updateConnectionStatusDOM(e,t),document.dispatchEvent(new CustomEvent("socketConnectionStatus",{detail:{status:e,type:t}}))}updateConnectionStatusDOM(e,t){const n=document.getElementById("connection-status");n?(n.innerHTML=`<span>●</span> ${e}`,n.className=`status-badge status-${t}`,console.log(`SocketClient: Direct DOM update - status: '${e}' (${t})`)):console.warn("SocketClient: Could not find connection-status element in DOM")}notifyEventUpdate(){this.connectionCallbacks.event.forEach(e=>e(this.events,this.sessions)),document.dispatchEvent(new CustomEvent("socketEventUpdate",{detail:{events:this.events,sessions:this.sessions}}))}getConnectionState(){return{isConnected:this.isConnected,isConnecting:this.isConnecting,socketId:this.socket?this.socket.id:null}}validateEventSchema(e){if(!e||"object"!=typeof e)return console.warn("Event data is not an object:",e),null;const t={...e};return t.source||(t.source="system"),t.type||(t.event?t.type=t.event:t.type="unknown"),t.subtype||(t.subtype="generic"),t.timestamp||(t.timestamp=(new Date).toISOString()),t.data||(t.data={}),t.data&&"object"!=typeof t.data&&(t.data={value:t.data}),console.log("Validated event:",t),t}transformEvent(e){if(!e)return e;let t={...e};if(e.type&&e.subtype&&!e.type.includes(".")&&!e.type.includes(":"))t.originalEventName||("generic"===e.subtype||e.type===e.subtype?t.originalEventName=e.type:t.originalEventName=`${e.type}.${e.subtype}`);else if(!e.type&&e.event){const n=e.event;"TestStart"===n||"TestEnd"===n?(t.type="test",t.subtype=n.toLowerCase().replace("test","")):"SubagentStart"===n||"SubagentStop"===n?(t.type="subagent",t.subtype=n.toLowerCase().replace("subagent","")):"ToolCall"===n?(t.type="tool",t.subtype="call"):"UserPrompt"===n?(t.type="hook",t.subtype="user_prompt"):(t.type="unknown",t.subtype=n.toLowerCase(),t.type===t.subtype&&(t.subtype="event")),delete t.event,t.originalEventName=n}else if(e.type){const n=e.type;if(n.startsWith("hook.")){const e=n.substring(5);t.type="hook",t.subtype=e,t.originalEventName=n}else if(n.startsWith("code:")){t.type="code";const e=n.substring(5);t.subtype=e.replace(/:/g,"_"),t.originalEventName=n}else if(n.includes(".")){const[e,...o]=n.split(".");t.type=e,t.subtype=o.join("."),t.originalEventName=n}else if(n.includes(":")){const e=n.split(":",2);t.type=e[0],t.subtype=e.length>1?e[1].replace(/:/g,"_"):"generic",t.originalEventName=n}else e.subtype||(t.subtype="generic",t.originalEventName=n)}else t.type="unknown",t.subtype="",t.originalEventName="unknown";if(e.data&&"object"==typeof e.data){const n=["type","subtype","timestamp","id","event","event_type","originalEventName"];Object.keys(e.data).forEach(o=>{n.includes(o)?"timestamp"!==o&&console.debug(`Protected field '${o}' in data object was not copied to top level to preserve event structure`):"tool_parameters"===o&&"object"==typeof e.data[o]?t[o]=JSON.parse(JSON.stringify(e.data[o])):t[o]=e.data[o]}),t.data=e.data}if("hook"===t.type?"pre_tool"===t.subtype?t.hook_event_name="PreToolUse":"post_tool"===t.subtype?t.hook_event_name="PostToolUse":"subagent_start"===t.subtype?t.hook_event_name="SubagentStart":"subagent_stop"===t.subtype?t.hook_event_name="SubagentStop":"todo_write"===t.subtype?t.hook_event_name="TodoWrite":"start"===t.subtype?t.hook_event_name="Start":"stop"===t.subtype&&(t.hook_event_name="Stop"):"subagent"===t.type?"start"===t.subtype?t.hook_event_name="SubagentStart":"stop"===t.subtype&&(t.hook_event_name="SubagentStop"):"todo"===t.type&&"updated"===t.subtype&&(t.hook_event_name="TodoWrite"),"hook"===t.type&&("pre_tool"===t.subtype||"post_tool"===t.subtype)){console.log("Transformed tool event:",{type:t.type,subtype:t.subtype,hook_event_name:t.hook_event_name,tool_name:t.tool_name,has_tool_parameters:!!t.tool_parameters,tool_parameters:t.tool_parameters,has_data:!!t.data,keys:Object.keys(t).filter(e=>"data"!==e)});["Read","Write","Edit","MultiEdit","NotebookEdit"].includes(t.tool_name)&&console.log("File tool event details:",{tool_name:t.tool_name,file_path:t.tool_parameters?.file_path,path:t.tool_parameters?.path,notebook_path:t.tool_parameters?.notebook_path,full_parameters:t.tool_parameters})}return t}getState(){return{events:this.events,sessions:this.sessions,currentSessionId:this.currentSessionId}}startHealthMonitoring(){this.healthCheckInterval=setInterval(()=>{if(this.isConnected&&this.lastPingTime){const e=Date.now()-this.lastPingTime;e>this.pingTimeout&&(console.warn(`No ping from server for ${e/1e3}s, connection may be stale`),this.socket&&(console.log("Forcing reconnection due to stale connection..."),this.socket.disconnect(),setTimeout(()=>{this.port&&this.connect(this.port)},1e3)))}},1e4)}stopHealthMonitoring(){this.healthCheckInterval&&(clearInterval(this.healthCheckInterval),this.healthCheckInterval=null)}startStatusCheckFallback(){setInterval(()=>{this.checkAndUpdateStatus()},2e3),"loading"===document.readyState?document.addEventListener("DOMContentLoaded",()=>{setTimeout(()=>this.checkAndUpdateStatus(),100)}):setTimeout(()=>this.checkAndUpdateStatus(),100)}checkAndUpdateStatus(){let e="Disconnected",t="disconnected";this.socket&&(this.socket.connected?(e="Connected",t="connected",this.isConnected=!0,this.isConnecting=!1,window.socket||(window.socket=this.socket,console.log("SocketClient: Exposed socket globally as window.socket"))):this.socket.connecting||this.isConnecting?(e="Connecting...",t="connecting",this.isConnected=!1):(e="Disconnected",t="disconnected",this.isConnected=!1,this.isConnecting=!1)),this.updateConnectionStatusDOM(e,t);const n=document.getElementById("connection-status");if(n){const t=n.textContent.replace("●","").trim();t!==e&&console.log(`SocketClient: Status sync - updating from '${t}' to '${e}'`)}}destroy(){this.stopHealthMonitoring(),this.socket&&(this.socket.disconnect(),this.socket=null),this.eventQueue=[],this.pendingEmissions.clear()}getConnectionMetrics(){return{isConnected:this.isConnected,uptime:this.lastConnectTime?(Date.now()-this.lastConnectTime)/1e3:0,lastPing:this.lastPingTime?(Date.now()-this.lastPingTime)/1e3:null,queuedEvents:this.eventQueue.length,pendingEmissions:this.pendingEmissions.size,retryAttempts:this.retryAttempts}}}window.SocketClient=t;class n{constructor(){this.socketClient=null,this.connectionCallbacks=new Set,this.eventUpdateCallbacks=new Set,this.socketClient=new t,window.socketClient=this.socketClient,this.setupSocketEventHandlers(),setTimeout(()=>{this.updateInitialConnectionStatus()},100),console.log("Socket manager initialized")}setupSocketEventHandlers(){document.addEventListener("socketConnectionStatus",e=>{console.log(`SocketManager: Processing connection status update: ${e.detail.status} (${e.detail.type})`),this.handleConnectionStatusChange(e.detail.status,e.detail.type),this.connectionCallbacks.forEach(t=>{try{t(e.detail.status,e.detail.type)}catch(n){console.error("Error in connection callback:",n)}})}),this.socketClient&&this.socketClient.onEventUpdate(e=>{this.eventUpdateCallbacks.forEach(t=>{try{t(e)}catch(n){console.error("Error in event update callback:",n)}})})}handleConnectionStatusChange(e,t){this.updateConnectionStatus(e,t),"connected"===t&&this.socketClient&&this.socketClient.socket&&(window.socket=this.socketClient.socket,console.log("SocketManager: Exposed socket globally as window.socket"),this.setupGitBranchListener())}updateInitialConnectionStatus(){console.log("SocketManager: Updating initial connection status"),this.socketClient&&"function"==typeof this.socketClient.checkAndUpdateStatus?(console.log("SocketManager: Using socket client checkAndUpdateStatus method"),this.socketClient.checkAndUpdateStatus()):this.socketClient&&this.socketClient.socket?(console.log("SocketManager: Checking socket state directly",{connected:this.socketClient.socket.connected,connecting:this.socketClient.socket.connecting,isConnecting:this.socketClient.isConnecting,isConnected:this.socketClient.isConnected}),this.socketClient.socket.connected?(console.log("SocketManager: Socket is already connected, updating status"),window.socket=this.socketClient.socket,console.log("SocketManager: Exposed socket globally as window.socket"),this.updateConnectionStatus("Connected","connected")):this.socketClient.isConnecting||this.socketClient.socket.connecting?(console.log("SocketManager: Socket is connecting, updating status"),this.updateConnectionStatus("Connecting...","connecting")):(console.log("SocketManager: Socket is disconnected, updating status"),this.updateConnectionStatus("Disconnected","disconnected"))):(console.log("SocketManager: No socket client or socket found, setting disconnected status"),this.updateConnectionStatus("Disconnected","disconnected")),setTimeout(()=>{console.log("SocketManager: Secondary status check after 1 second"),this.socketClient&&this.socketClient.socket&&this.socketClient.socket.connected&&(console.log("SocketManager: Socket connected in secondary check, updating status"),window.socket||(window.socket=this.socketClient.socket,console.log("SocketManager: Exposed socket globally as window.socket (secondary check)")),this.updateConnectionStatus("Connected","connected"))},1e3)}setupGitBranchListener(){this.socketClient.socket.off("git_branch_response"),this.socketClient.socket.on("git_branch_response",e=>{if(e.success){const t=document.getElementById("footer-git-branch");t&&(t.textContent=e.branch||"unknown"),t&&(t.style.display="inline")}else console.error("Git branch request failed:",e.error)})}updateConnectionStatus(e,t){const n=document.getElementById("connection-status");if(n){if(n.querySelector("span")){const t="●";n.innerHTML=`<span>${t}</span> ${e}`}else n.textContent=e;n.className=`status-badge status-${t}`,console.log(`SocketManager: UI updated - status: '${e}' (${t})`)}else console.error("SocketManager: Could not find connection-status element in DOM")}connect(e){this.socketClient&&this.socketClient.connect(e)}disconnect(){this.socketClient&&this.socketClient.disconnect()}isConnected(){return this.socketClient&&this.socketClient.isConnected}isConnecting(){return this.socketClient&&this.socketClient.isConnecting}getSocketClient(){return this.socketClient}getSocket(){return this.socketClient?this.socketClient.socket:null}onConnectionStatusChange(e){this.connectionCallbacks.add(e)}offConnectionStatusChange(e){this.connectionCallbacks.delete(e)}onEventUpdate(e){this.eventUpdateCallbacks.add(e)}offEventUpdate(e){this.eventUpdateCallbacks.delete(e)}toggleConnectionControls(){const e=document.getElementById("connection-controls-row"),t=document.getElementById("connection-toggle-btn");if(e&&t){e.classList.contains("show")?(e.classList.remove("show"),e.style.display="none",t.textContent="Connection Settings"):(e.classList.add("show"),e.style.display="block",t.textContent="Hide Settings")}}setupConnectionControls(){const e=document.getElementById("connect-btn"),t=document.getElementById("disconnect-btn"),n=document.getElementById("connection-toggle-btn");e&&e.addEventListener("click",()=>{const e=document.getElementById("port-input").value||8765;this.connect(e)}),t&&t.addEventListener("click",()=>{this.disconnect()}),n&&n.addEventListener("click",()=>{this.toggleConnectionControls()})}initializeFromURL(e){const t=e.get("port"),n=document.getElementById("port-input");let o=t;o||"http:"!==window.location.protocol||(o=window.location.port||"8765"),o||(o=n?.value||"8765"),n&&(n.value=o);!("false"!==e.get("connect"))||this.isConnected()||this.isConnecting()||(console.log(`SocketManager: Auto-connecting to port ${o}`),this.connect(o))}}window.SocketManager=n;class o{constructor(){this._switching=!1,this.hashToTab={"#events":"events","#agents":"agents","#tools":"tools","#files":"files","#activity":"activity","#file_tree":"claude-tree","":"events"},this.tabToHash={events:"#events",agents:"#agents",tools:"#tools",files:"#files",activity:"#activity","claude-tree":"#file_tree"},this.currentTab=this.getTabFromHash(),this.autoScroll=!0,this.selectedCard={tab:null,index:null,type:null,data:null},this.tabNavigation={events:{selectedIndex:-1,items:[]},agents:{selectedIndex:-1,items:[]},tools:{selectedIndex:-1,items:[]},files:{selectedIndex:-1,items:[]}},this.setupEventHandlers(),console.log("UI state manager initialized with hash navigation"),this.handleHashChange()}getTabFromHash(){const e=window.location.hash||"";return this.hashToTab[e]||"events"}setupEventHandlers(){this.setupHashNavigation(),this.setupTabClickHandlers(),this.setupUnifiedKeyboardNavigation()}setupHashNavigation(){window.addEventListener("hashchange",e=>{console.log("[Hash Navigation] Hash changed from",new URL(e.oldURL).hash,"to",window.location.hash),this.handleHashChange()}),document.addEventListener("DOMContentLoaded",()=>{console.log("[Hash Navigation] Initial hash:",window.location.hash),this.handleHashChange()})}handleHashChange(){const e=window.location.hash||"";console.log("[Hash Navigation] DETAILED DEBUG:"),console.log("[Hash Navigation] - Current hash:",e),console.log("[Hash Navigation] - hashToTab mapping:",this.hashToTab),console.log("[Hash Navigation] - Direct lookup result:",this.hashToTab[e]),console.log("[Hash Navigation] - Is hash in mapping?",e in this.hashToTab),console.log("[Hash Navigation] - Hash length:",e.length),console.log("[Hash Navigation] - Hash char codes:",e.split("").map(e=>e.charCodeAt(0)));const t=this.hashToTab[e]||"events";console.log("[Hash Navigation] Final resolved tab name:",t),"claude-tree"!==t&&"#file_tree"!==e||(console.log("[UIStateManager] FILE TREE TAB SELECTED via hash:",e),console.log("[UIStateManager] Tab name resolved to:",t)),this.switchTab(t,!1)}setupTabNavigation(){console.log("[Hash Navigation] setupTabNavigation is deprecated - using hash navigation instead")}setupTabClickHandlers(){document.querySelectorAll(".tab-button").forEach(e=>{e.addEventListener("click",e=>{console.log("[UIStateManager] Tab button clicked:",e.target);const t=this.getTabNameFromButton(e.target);console.log("[UIStateManager] Resolved tab name:",t),t&&setTimeout(()=>{const e=this.tabToHash[t];window.location.hash!==e&&e&&(console.log("[UIStateManager] Hash not updated, forcing update:",e),window.location.hash=e)},10)})}),console.log("[UIStateManager] Tab click handlers set up for",document.querySelectorAll(".tab-button").length,"buttons")}setupUnifiedKeyboardNavigation(){document.addEventListener("keydown",e=>{document.activeElement&&["INPUT","TEXTAREA","SELECT"].includes(document.activeElement.tagName)||("ArrowUp"===e.key||"ArrowDown"===e.key?(e.preventDefault(),this.handleUnifiedArrowNavigation("ArrowDown"===e.key?1:-1)):"Enter"===e.key?(e.preventDefault(),this.handleUnifiedEnterKey()):"Escape"===e.key&&this.clearUnifiedSelection())})}getTabNameFromButton(e){console.log("[getTabNameFromButton] DEBUG: button object:",e),console.log("[getTabNameFromButton] DEBUG: button.nodeType:",e.nodeType),console.log("[getTabNameFromButton] DEBUG: button.tagName:",e.tagName);let t=e;e&&e.closest&&e.closest(".tab-button")&&(t=e.closest(".tab-button"),console.log("[getTabNameFromButton] DEBUG: Used closest() to find actual button"));const n=t?t.getAttribute("data-tab"):null;if(console.log("[getTabNameFromButton] DEBUG: data-tab attribute:",n),console.log("[getTabNameFromButton] DEBUG: dataTab truthy:",!!n),"claude-tree"===n)return console.log("[getTabNameFromButton] DEBUG: Found claude-tree data-tab, returning it"),"claude-tree";if(n)return console.log("[getTabNameFromButton] DEBUG: Returning dataTab:",n),n;const o=t?t.textContent.toLowerCase():"";return console.log("[getTabNameFromButton] DEBUG: text content:",o),console.log("[getTabNameFromButton] DEBUG: text includes file tree:",o.includes("file tree")),console.log("[getTabNameFromButton] DEBUG: text includes events:",o.includes("events")),o.includes("file tree")||o.includes("📝")?(console.log("[getTabNameFromButton] DEBUG: Matched file tree, returning claude-tree"),"claude-tree"):o.includes("activity")||o.includes("🌳")?"activity":o.includes("agents")||o.includes("🤖")?"agents":o.includes("tools")||o.includes("🔧")?"tools":o.includes("files")||o.includes("📁")?"files":o.includes("code")?"code":o.includes("sessions")?"sessions":o.includes("system")?"system":(o.includes("events")||o.includes("📊")||console.log("[getTabNameFromButton] DEBUG: No match, falling back to events"),"events")}switchTab(e,t=!0){if(this._switching)return console.log(`[UIStateManager] Tab switch already in progress, queuing: ${e}`),void setTimeout(()=>this.switchTab(e,t),50);this._switching=!0,console.log(`[UIStateManager] BULLETPROOF switchTab: ${e}, updateHash: ${t}`);try{if("claude-tree"===e&&(console.log("[UIStateManager] SWITCHING TO FILE TREE TAB"),console.log("[UIStateManager] Current tab before switch:",this.currentTab)),t&&this.tabToHash[e]){const t=this.tabToHash[e];if(window.location.hash!==t)return console.log(`[UIStateManager] Updating hash to: ${t}`),this._switching=!1,void(window.location.hash=t)}const n=this.currentTab;this.currentTab=e,this._removeAllActiveStates(),this._setActiveTab(e),this._showTabContent(e),this._validateTabState(e),this.clearUnifiedSelection(),document.dispatchEvent(new CustomEvent("tabChanged",{detail:{newTab:e,previousTab:n}})),setTimeout(()=>{this.autoScroll&&this.scrollCurrentTabToBottom(),"claude-tree"===e&&window.CodeViewer&&(window.CodeViewer.renderContent?window.CodeViewer.renderContent():window.CodeViewer.show())},100)}finally{setTimeout(()=>{this._switching=!1},200)}}_removeAllActiveStates(){document.querySelectorAll(".tab-button").forEach(e=>{e.classList.remove("active"),e.style.removeProperty("border-bottom"),e.style.removeProperty("color")}),document.querySelectorAll(".tab-content").forEach(e=>{e.classList.remove("active"),e.style.removeProperty("display"),"events-tab"!==e.id&&this._cleanLeakedEventContent(e)}),console.log("[UIStateManager] NUCLEAR: All active states removed")}_setActiveTab(e){const t=document.querySelector(`[data-tab="${e}"]`);t?(t.classList.add("active"),console.log(`[UIStateManager] Set active: ${e}`)):console.error(`[UIStateManager] Could not find tab button for: ${e}`)}_showTabContent(e){const t=document.getElementById(`${e}-tab`);t?(t.classList.add("active"),console.log(`[UIStateManager] Showing content: ${e}-tab`),"claude-tree"===e&&this._prepareFileTreeContent(t)):console.error(`[UIStateManager] Could not find content for: ${e}`)}_cleanLeakedEventContent(e){const t=e.querySelectorAll(".event-item");t.length>0&&(console.warn(`[UIStateManager] Found ${t.length} leaked event items in ${e.id}, removing...`),t.forEach(e=>e.remove()));const n=e.querySelectorAll("#events-list, .events-list");n.length>0&&(console.warn(`[UIStateManager] Found leaked events-list in ${e.id}, removing...`),n.forEach(e=>e.remove()))}_prepareFileTreeContent(e){const t=document.getElementById("claude-tree-container");t&&(this._cleanLeakedEventContent(t),t.setAttribute("data-owner","code-viewer"),t.setAttribute("data-component","CodeViewer"),console.log("[UIStateManager] File Tree container prepared"))}_validateTabState(e){setTimeout(()=>{const t=document.querySelectorAll(".tab-button.active"),n=document.querySelectorAll(".tab-content.active");1!==t.length&&(console.error(`[UIStateManager] VALIDATION FAILED: Expected 1 active tab, found ${t.length}`),t.forEach((e,t)=>{console.error(`  - Active tab ${t+1}: ${e.textContent.trim()} (${e.getAttribute("data-tab")})`)}),this._removeAllActiveStates(),this._setActiveTab(e)),1!==n.length&&(console.error(`[UIStateManager] VALIDATION FAILED: Expected 1 active content, found ${n.length}`),n.forEach((e,t)=>{console.error(`  - Active content ${t+1}: ${e.id}`)}),this._removeAllActiveStates(),this._showTabContent(e)),console.log(`[UIStateManager] Tab state validated for: ${e}`)},50)}handleUnifiedArrowNavigation(e){const t=this.tabNavigation[this.currentTab];if(!t)return;let n=t.selectedIndex+e;0!==t.items.length&&(n<0?n=t.items.length-1:n>=t.items.length&&(n=0),this.selectCardByIndex(this.currentTab,n))}handleUnifiedEnterKey(){const e=this.tabNavigation[this.currentTab];if(!e||-1===e.selectedIndex)return;const t=e.items[e.selectedIndex];t&&t.onclick&&t.onclick()}clearUnifiedSelection(){Object.keys(this.tabNavigation).forEach(e=>{this.tabNavigation[e].selectedIndex=-1}),this.clearCardSelection()}updateTabNavigationItems(){const e=this.tabNavigation[this.currentTab];if(!e)return;let t;switch(this.currentTab){case"events":t="#events-list .event-item";break;case"agents":t="#agents-list .event-item";break;case"tools":t="#tools-list .event-item";break;case"files":t="#files-list .event-item"}t&&(e.items=Array.from(document.querySelectorAll(t)))}selectCardByIndex(e,t){const n=this.tabNavigation[e];if(!n||t<0||t>=n.items.length)return;n.selectedIndex=t,this.updateUnifiedSelectionUI();n.items[t]&&this.selectCard(e,t,this.getCardType(e),t),this.showCardDetails(e,t)}updateUnifiedSelectionUI(){document.querySelectorAll(".event-item.keyboard-selected").forEach(e=>{e.classList.remove("keyboard-selected")});const e=this.tabNavigation[this.currentTab];e&&-1!==e.selectedIndex&&e.items[e.selectedIndex]&&e.items[e.selectedIndex].classList.add("keyboard-selected")}showCardDetails(e,t){document.dispatchEvent(new CustomEvent("showCardDetails",{detail:{tabName:e,index:t}}))}selectCard(e,t,n,o){this.clearCardSelection(),this.selectedCard={tab:e,index:t,type:n,data:o},this.updateCardSelectionUI(),console.log("Card selected:",this.selectedCard)}clearCardSelection(){document.querySelectorAll(".event-item.selected, .file-item.selected").forEach(e=>{e.classList.remove("selected")}),this.selectedCard={tab:null,index:null,type:null,data:null}}updateCardSelectionUI(){if(!this.selectedCard.tab||null===this.selectedCard.index)return;let e;switch(this.selectedCard.tab){case"events":e=document.getElementById("events-list");break;case"agents":e=document.getElementById("agents-list");break;case"tools":e=document.getElementById("tools-list");break;case"files":e=document.getElementById("files-list")}if(e){const t=e.querySelectorAll(".event-item, .file-item");t[this.selectedCard.index]&&t[this.selectedCard.index].classList.add("selected")}}getCardType(e){switch(e){case"events":return"event";case"agents":return"agent";case"tools":return"tool";case"files":return"file";default:return"unknown"}}scrollCurrentTabToBottom(){const e=`${this.currentTab}-list`,t=document.getElementById(e);t&&this.autoScroll&&(t.scrollTop=t.scrollHeight)}clearSelection(){this.clearCardSelection(),this.clearUnifiedSelection()}getCurrentTab(){return this.currentTab}getSelectedCard(){return{...this.selectedCard}}getTabNavigation(){return{...this.tabNavigation}}setAutoScroll(e){this.autoScroll=e}getAutoScroll(){return this.autoScroll}}window.UIStateManager=o;export{n as S,o as U};
//# sourceMappingURL=socket-client.js.map
