# coding: utf-8

"""
    MailSlurp API

    MailSlurp is an API for sending and receiving emails from dynamically allocated email addresses. It's designed for developers and QA teams to test applications, process inbound emails, send templated notifications, attachments, and more.  ## Resources  - [Homepage](https://www.mailslurp.com) - Get an [API KEY](https://app.mailslurp.com/sign-up/) - Generated [SDK Clients](https://www.mailslurp.com/docs/) - [Examples](https://github.com/mailslurp/examples) repository  # noqa: E501

    The version of the OpenAPI document: 6.5.2
    Contact: contact@mailslurp.dev
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from mailslurp_client.configuration import Configuration


class SendSMTPEnvelopeOptions(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'rcpt_to': 'list[str]',
        'mail_from': 'str',
        'data': 'str'
    }

    attribute_map = {
        'rcpt_to': 'rcptTo',
        'mail_from': 'mailFrom',
        'data': 'data'
    }

    def __init__(self, rcpt_to=None, mail_from=None, data=None, local_vars_configuration=None):  # noqa: E501
        """SendSMTPEnvelopeOptions - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._rcpt_to = None
        self._mail_from = None
        self._data = None
        self.discriminator = None

        self.rcpt_to = rcpt_to
        self.mail_from = mail_from
        self.data = data

    @property
    def rcpt_to(self):
        """Gets the rcpt_to of this SendSMTPEnvelopeOptions.  # noqa: E501


        :return: The rcpt_to of this SendSMTPEnvelopeOptions.  # noqa: E501
        :rtype: list[str]
        """
        return self._rcpt_to

    @rcpt_to.setter
    def rcpt_to(self, rcpt_to):
        """Sets the rcpt_to of this SendSMTPEnvelopeOptions.


        :param rcpt_to: The rcpt_to of this SendSMTPEnvelopeOptions.  # noqa: E501
        :type: list[str]
        """
        if self.local_vars_configuration.client_side_validation and rcpt_to is None:  # noqa: E501
            raise ValueError("Invalid value for `rcpt_to`, must not be `None`")  # noqa: E501

        self._rcpt_to = rcpt_to

    @property
    def mail_from(self):
        """Gets the mail_from of this SendSMTPEnvelopeOptions.  # noqa: E501


        :return: The mail_from of this SendSMTPEnvelopeOptions.  # noqa: E501
        :rtype: str
        """
        return self._mail_from

    @mail_from.setter
    def mail_from(self, mail_from):
        """Sets the mail_from of this SendSMTPEnvelopeOptions.


        :param mail_from: The mail_from of this SendSMTPEnvelopeOptions.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and mail_from is None:  # noqa: E501
            raise ValueError("Invalid value for `mail_from`, must not be `None`")  # noqa: E501

        self._mail_from = mail_from

    @property
    def data(self):
        """Gets the data of this SendSMTPEnvelopeOptions.  # noqa: E501


        :return: The data of this SendSMTPEnvelopeOptions.  # noqa: E501
        :rtype: str
        """
        return self._data

    @data.setter
    def data(self, data):
        """Sets the data of this SendSMTPEnvelopeOptions.


        :param data: The data of this SendSMTPEnvelopeOptions.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and data is None:  # noqa: E501
            raise ValueError("Invalid value for `data`, must not be `None`")  # noqa: E501

        self._data = data

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, SendSMTPEnvelopeOptions):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, SendSMTPEnvelopeOptions):
            return True

        return self.to_dict() != other.to_dict()
