r"""
    This code was generated by
   ___ _ _ _ _ _    _ ____    ____ ____ _    ____ ____ _  _ ____ ____ ____ ___ __   __
    |  | | | | |    | |  | __ |  | |__| | __ | __ |___ |\ | |___ |__/ |__|  | |  | |__/
    |  |_|_| | |___ | |__|    |__| |  | |    |__] |___ | \| |___ |  \ |  |  | |__| |  \

    Twilio - Lookups
    This is the public Twilio REST API.

    NOTE: This class is auto generated by OpenAPI Generator.
    https://openapi-generator.tech
    Do not edit the class manually.
"""

from datetime import datetime
from typing import Any, Dict, Optional, Union
from twilio.base import deserialize, values
from twilio.base.instance_context import InstanceContext
from twilio.base.instance_resource import InstanceResource
from twilio.base.list_resource import ListResource
from twilio.base.version import Version


class LookupOverrideInstance(InstanceResource):

    class OverridesRequest(object):
        """
        :ivar line_type:
        :ivar reason:
        """

        def __init__(self, payload: Dict[str, Any]):

            self.line_type: Optional["LookupOverrideInstance.str"] = payload.get(
                "line_type"
            )
            self.reason: Optional[str] = payload.get("reason")

        def to_dict(self):
            return {
                "line_type": self.line_type,
                "reason": self.reason,
            }

    """
    :ivar phone_number: 
    :ivar original_line_type: 
    :ivar overridden_line_type: 
    :ivar override_reason: The reason for the override
    :ivar override_timestamp: 
    :ivar overridden_by_account_sid: The user who overrode the line type
    :ivar code: Twilio-specific error code
    :ivar message: Error message
    :ivar more_info: Link to Error Code References
    :ivar status: HTTP response status code
    :ivar field: Limit of requests for the bucket
    :ivar limit: Limit of requests for the bucket
    :ivar bucket: Name of the bucket
    :ivar owner: Owner of the rule
    :ivar ttl: Time to live of the rule
    """

    def __init__(
        self,
        version: Version,
        payload: Dict[str, Any],
        field: Optional[str] = None,
        phone_number: Optional[str] = None,
    ):
        super().__init__(version)

        self.phone_number: Optional[str] = payload.get("phone_number")
        self.original_line_type: Optional[str] = payload.get("original_line_type")
        self.overridden_line_type: Optional[str] = payload.get("overridden_line_type")
        self.override_reason: Optional[str] = payload.get("override_reason")
        self.override_timestamp: Optional[datetime] = deserialize.iso8601_datetime(
            payload.get("override_timestamp")
        )
        self.overridden_by_account_sid: Optional[str] = payload.get(
            "overridden_by_account_sid"
        )
        self.code: Optional[int] = payload.get("code")
        self.message: Optional[str] = payload.get("message")
        self.more_info: Optional[str] = payload.get("more_info")
        self.status: Optional[int] = payload.get("status")
        self.field: Optional[str] = payload.get("field")
        self.limit: Optional[int] = payload.get("limit")
        self.bucket: Optional[str] = payload.get("bucket")
        self.owner: Optional[str] = payload.get("owner")
        self.ttl: Optional[int] = payload.get("ttl")

        self._solution = {
            "field": field or self.field,
            "phone_number": phone_number or self.phone_number,
        }
        self._context: Optional[LookupOverrideContext] = None

    @property
    def _proxy(self) -> "LookupOverrideContext":
        """
        Generate an instance context for the instance, the context is capable of
        performing various actions. All instance actions are proxied to the context

        :returns: LookupOverrideContext for this LookupOverrideInstance
        """
        if self._context is None:
            self._context = LookupOverrideContext(
                self._version,
                field=self._solution["field"],
                phone_number=self._solution["phone_number"],
            )
        return self._context

    def create(
        self, overrides_request: Union[OverridesRequest, object] = values.unset
    ) -> "LookupOverrideInstance":
        """
        Create the LookupOverrideInstance

        :param overrides_request:

        :returns: The created LookupOverrideInstance
        """
        return self._proxy.create(
            overrides_request=overrides_request,
        )

    async def create_async(
        self, overrides_request: Union[OverridesRequest, object] = values.unset
    ) -> "LookupOverrideInstance":
        """
        Asynchronous coroutine to create the LookupOverrideInstance

        :param overrides_request:

        :returns: The created LookupOverrideInstance
        """
        return await self._proxy.create_async(
            overrides_request=overrides_request,
        )

    def delete(self) -> bool:
        """
        Deletes the LookupOverrideInstance


        :returns: True if delete succeeds, False otherwise
        """
        return self._proxy.delete()

    async def delete_async(self) -> bool:
        """
        Asynchronous coroutine that deletes the LookupOverrideInstance


        :returns: True if delete succeeds, False otherwise
        """
        return await self._proxy.delete_async()

    def fetch(self) -> "LookupOverrideInstance":
        """
        Fetch the LookupOverrideInstance


        :returns: The fetched LookupOverrideInstance
        """
        return self._proxy.fetch()

    async def fetch_async(self) -> "LookupOverrideInstance":
        """
        Asynchronous coroutine to fetch the LookupOverrideInstance


        :returns: The fetched LookupOverrideInstance
        """
        return await self._proxy.fetch_async()

    def update(
        self, overrides_request: Union[OverridesRequest, object] = values.unset
    ) -> "LookupOverrideInstance":
        """
        Update the LookupOverrideInstance

        :param overrides_request:

        :returns: The updated LookupOverrideInstance
        """
        return self._proxy.update(
            overrides_request=overrides_request,
        )

    async def update_async(
        self, overrides_request: Union[OverridesRequest, object] = values.unset
    ) -> "LookupOverrideInstance":
        """
        Asynchronous coroutine to update the LookupOverrideInstance

        :param overrides_request:

        :returns: The updated LookupOverrideInstance
        """
        return await self._proxy.update_async(
            overrides_request=overrides_request,
        )

    def __repr__(self) -> str:
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        """
        context = " ".join("{}={}".format(k, v) for k, v in self._solution.items())
        return "<Twilio.Lookups.V2.LookupOverrideInstance {}>".format(context)


class LookupOverrideContext(InstanceContext):

    class OverridesRequest(object):
        """
        :ivar line_type:
        :ivar reason:
        """

        def __init__(self, payload: Dict[str, Any]):

            self.line_type: Optional["LookupOverrideInstance.str"] = payload.get(
                "line_type"
            )
            self.reason: Optional[str] = payload.get("reason")

        def to_dict(self):
            return {
                "line_type": self.line_type,
                "reason": self.reason,
            }

    def __init__(self, version: Version, field: str, phone_number: str):
        """
        Initialize the LookupOverrideContext

        :param version: Version that contains the resource
        :param field:
        :param phone_number:
        """
        super().__init__(version)

        # Path Solution
        self._solution = {
            "field": field,
            "phone_number": phone_number,
        }
        self._uri = "/PhoneNumbers/{phone_number}/Overrides/{field}".format(
            **self._solution
        )

    def create(
        self, overrides_request: Union[OverridesRequest, object] = values.unset
    ) -> LookupOverrideInstance:
        """
        Create the LookupOverrideInstance

        :param overrides_request:

        :returns: The created LookupOverrideInstance
        """
        data = values.of(
            {
                "OverridesRequest": overrides_request,
            }
        )

        payload = self._version.create(method="POST", uri=self._uri, data=data)

        return LookupOverrideInstance(
            self._version,
            payload,
            field=self._solution["field"],
            phone_number=self._solution["phone_number"],
        )

    async def create_async(
        self, overrides_request: Union[OverridesRequest, object] = values.unset
    ) -> LookupOverrideInstance:
        """
        Asynchronous coroutine to create the LookupOverrideInstance

        :param overrides_request:

        :returns: The created LookupOverrideInstance
        """
        data = values.of(
            {
                "OverridesRequest": overrides_request,
            }
        )

        payload = await self._version.create_async(
            method="POST", uri=self._uri, data=data
        )

        return LookupOverrideInstance(
            self._version,
            payload,
            field=self._solution["field"],
            phone_number=self._solution["phone_number"],
        )

    def delete(self) -> bool:
        """
        Deletes the LookupOverrideInstance


        :returns: True if delete succeeds, False otherwise
        """

        headers = values.of({})

        headers["Accept"] = "application/json"

        return self._version.delete(method="DELETE", uri=self._uri, headers=headers)

    async def delete_async(self) -> bool:
        """
        Asynchronous coroutine that deletes the LookupOverrideInstance


        :returns: True if delete succeeds, False otherwise
        """

        headers = values.of({})

        headers["Accept"] = "application/json"

        return await self._version.delete_async(
            method="DELETE", uri=self._uri, headers=headers
        )

    def fetch(self) -> LookupOverrideInstance:
        """
        Fetch the LookupOverrideInstance


        :returns: The fetched LookupOverrideInstance
        """

        headers = values.of({})

        headers["Accept"] = "application/json"

        payload = self._version.fetch(method="GET", uri=self._uri, headers=headers)

        return LookupOverrideInstance(
            self._version,
            payload,
            field=self._solution["field"],
            phone_number=self._solution["phone_number"],
        )

    async def fetch_async(self) -> LookupOverrideInstance:
        """
        Asynchronous coroutine to fetch the LookupOverrideInstance


        :returns: The fetched LookupOverrideInstance
        """

        headers = values.of({})

        headers["Accept"] = "application/json"

        payload = await self._version.fetch_async(
            method="GET", uri=self._uri, headers=headers
        )

        return LookupOverrideInstance(
            self._version,
            payload,
            field=self._solution["field"],
            phone_number=self._solution["phone_number"],
        )

    def update(
        self, overrides_request: Union[OverridesRequest, object] = values.unset
    ) -> LookupOverrideInstance:
        """
        Update the LookupOverrideInstance

        :param overrides_request:

        :returns: The updated LookupOverrideInstance
        """
        data = overrides_request.to_dict()

        headers = values.of({})

        headers["Content-Type"] = "application/json"

        headers["Accept"] = "application/json"

        payload = self._version.update(
            method="PUT", uri=self._uri, data=data, headers=headers
        )

        return LookupOverrideInstance(
            self._version,
            payload,
            field=self._solution["field"],
            phone_number=self._solution["phone_number"],
        )

    async def update_async(
        self, overrides_request: Union[OverridesRequest, object] = values.unset
    ) -> LookupOverrideInstance:
        """
        Asynchronous coroutine to update the LookupOverrideInstance

        :param overrides_request:

        :returns: The updated LookupOverrideInstance
        """
        data = overrides_request.to_dict()

        headers = values.of({})

        headers["Content-Type"] = "application/json"

        headers["Accept"] = "application/json"

        payload = await self._version.update_async(
            method="PUT", uri=self._uri, data=data, headers=headers
        )

        return LookupOverrideInstance(
            self._version,
            payload,
            field=self._solution["field"],
            phone_number=self._solution["phone_number"],
        )

    def __repr__(self) -> str:
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        """
        context = " ".join("{}={}".format(k, v) for k, v in self._solution.items())
        return "<Twilio.Lookups.V2.LookupOverrideContext {}>".format(context)


class LookupOverrideList(ListResource):

    class OverridesRequest(object):
        """
        :ivar line_type:
        :ivar reason:
        """

        def __init__(self, payload: Dict[str, Any]):

            self.line_type: Optional["LookupOverrideInstance.str"] = payload.get(
                "line_type"
            )
            self.reason: Optional[str] = payload.get("reason")

        def to_dict(self):
            return {
                "line_type": self.line_type,
                "reason": self.reason,
            }

    def __init__(self, version: Version):
        """
        Initialize the LookupOverrideList

        :param version: Version that contains the resource

        """
        super().__init__(version)

    def get(self, field: str, phone_number: str) -> LookupOverrideContext:
        """
        Constructs a LookupOverrideContext

        :param field:
        :param phone_number:
        """
        return LookupOverrideContext(
            self._version, field=field, phone_number=phone_number
        )

    def __call__(self, field: str, phone_number: str) -> LookupOverrideContext:
        """
        Constructs a LookupOverrideContext

        :param field:
        :param phone_number:
        """
        return LookupOverrideContext(
            self._version, field=field, phone_number=phone_number
        )

    def __repr__(self) -> str:
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        """
        return "<Twilio.Lookups.V2.LookupOverrideList>"
