# Generated by Django 5.2 on 2025-09-05 12:25

import django.db.models.deletion
from django.db import migrations, models

import lamindb.base.fields
import lamindb.models.sqlrecord


class Migration(migrations.Migration):
    dependencies = [
        ("lamindb", "0120_add_record_fk_constraint"),
    ]

    operations = [
        migrations.CreateModel(
            name="RecordUser",
            fields=[
                ("id", models.BigAutoField(primary_key=True, serialize=False)),
                (
                    "feature",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="links_recorduser",
                        to="lamindb.feature",
                    ),
                ),
                (
                    "record",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="values_user",
                        to="lamindb.record",
                    ),
                ),
                (
                    "value",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="links_record",
                        to="lamindb.user",
                    ),
                ),
            ],
            options={
                "unique_together": {("record", "feature", "value")},
            },
            bases=(models.Model, lamindb.models.sqlrecord.IsLink),
        ),
        migrations.AddField(
            model_name="record",
            name="linked_users",
            field=models.ManyToManyField(
                related_name="records", through="lamindb.RecordUser", to="lamindb.user"
            ),
        ),
    ]
