# Generated by Django 5.1.12 on 2025-10-01 16:44

import django.db.models.deletion
import django.db.models.functions.datetime
from django.db import migrations, models

import lamindb.base.fields


class Migration(migrations.Migration):
    dependencies = [
        ("lamindb", "0128_artifact__real_key"),
    ]

    operations = [
        migrations.CreateModel(
            name="ArtifactBlock",
            fields=[
                (
                    "version",
                    lamindb.base.fields.CharField(
                        blank=True,
                        db_index=True,
                        default=None,
                        max_length=30,
                        null=True,
                    ),
                ),
                (
                    "is_latest",
                    lamindb.base.fields.BooleanField(
                        blank=True, db_index=True, default=True
                    ),
                ),
                ("id", models.BigAutoField(primary_key=True, serialize=False)),
                (
                    "uid",
                    models.CharField(
                        db_index=True, editable=False, max_length=20, unique=True
                    ),
                ),
                ("content", models.TextField()),
                ("hash", models.CharField(db_index=True, max_length=22, null=True)),
                (
                    "type",
                    models.CharField(
                        db_default="mdpage",
                        db_index=True,
                        default="mdpage",
                        max_length=22,
                    ),
                ),
                (
                    "vertical_pos",
                    models.SmallIntegerField(db_default=0, db_index=True, default=0),
                ),
                (
                    "created_at",
                    models.DateTimeField(
                        db_default=django.db.models.functions.datetime.Now(),
                        db_index=True,
                        editable=False,
                    ),
                ),
                (
                    "artifact",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="blocks",
                        to="lamindb.artifact",
                    ),
                ),
                (
                    "created_by",
                    models.ForeignKey(
                        default=None,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="+",
                        to="lamindb.user",
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name="BranchBlock",
            fields=[
                (
                    "version",
                    lamindb.base.fields.CharField(
                        blank=True,
                        db_index=True,
                        default=None,
                        max_length=30,
                        null=True,
                    ),
                ),
                (
                    "is_latest",
                    lamindb.base.fields.BooleanField(
                        blank=True, db_index=True, default=True
                    ),
                ),
                ("id", models.BigAutoField(primary_key=True, serialize=False)),
                (
                    "uid",
                    models.CharField(
                        db_index=True, editable=False, max_length=20, unique=True
                    ),
                ),
                ("content", models.TextField()),
                ("hash", models.CharField(db_index=True, max_length=22, null=True)),
                (
                    "type",
                    models.CharField(
                        db_default="mdpage",
                        db_index=True,
                        default="mdpage",
                        max_length=22,
                    ),
                ),
                (
                    "vertical_pos",
                    models.SmallIntegerField(db_default=0, db_index=True, default=0),
                ),
                (
                    "created_at",
                    models.DateTimeField(
                        db_default=django.db.models.functions.datetime.Now(),
                        db_index=True,
                        editable=False,
                    ),
                ),
                (
                    "branch",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="blocks",
                        to="lamindb.branch",
                    ),
                ),
                (
                    "created_by",
                    models.ForeignKey(
                        default=None,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="+",
                        to="lamindb.user",
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name="CollectionBlock",
            fields=[
                (
                    "version",
                    lamindb.base.fields.CharField(
                        blank=True,
                        db_index=True,
                        default=None,
                        max_length=30,
                        null=True,
                    ),
                ),
                (
                    "is_latest",
                    lamindb.base.fields.BooleanField(
                        blank=True, db_index=True, default=True
                    ),
                ),
                ("id", models.BigAutoField(primary_key=True, serialize=False)),
                (
                    "uid",
                    models.CharField(
                        db_index=True, editable=False, max_length=20, unique=True
                    ),
                ),
                ("content", models.TextField()),
                ("hash", models.CharField(db_index=True, max_length=22, null=True)),
                (
                    "type",
                    models.CharField(
                        db_default="mdpage",
                        db_index=True,
                        default="mdpage",
                        max_length=22,
                    ),
                ),
                (
                    "vertical_pos",
                    models.SmallIntegerField(db_default=0, db_index=True, default=0),
                ),
                (
                    "created_at",
                    models.DateTimeField(
                        db_default=django.db.models.functions.datetime.Now(),
                        db_index=True,
                        editable=False,
                    ),
                ),
                (
                    "collection",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="blocks",
                        to="lamindb.collection",
                    ),
                ),
                (
                    "created_by",
                    models.ForeignKey(
                        default=None,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="+",
                        to="lamindb.user",
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name="FeatureBlock",
            fields=[
                (
                    "version",
                    lamindb.base.fields.CharField(
                        blank=True,
                        db_index=True,
                        default=None,
                        max_length=30,
                        null=True,
                    ),
                ),
                (
                    "is_latest",
                    lamindb.base.fields.BooleanField(
                        blank=True, db_index=True, default=True
                    ),
                ),
                ("id", models.BigAutoField(primary_key=True, serialize=False)),
                (
                    "uid",
                    models.CharField(
                        db_index=True, editable=False, max_length=20, unique=True
                    ),
                ),
                ("content", models.TextField()),
                ("hash", models.CharField(db_index=True, max_length=22, null=True)),
                (
                    "type",
                    models.CharField(
                        db_default="mdpage",
                        db_index=True,
                        default="mdpage",
                        max_length=22,
                    ),
                ),
                (
                    "vertical_pos",
                    models.SmallIntegerField(db_default=0, db_index=True, default=0),
                ),
                (
                    "created_at",
                    models.DateTimeField(
                        db_default=django.db.models.functions.datetime.Now(),
                        db_index=True,
                        editable=False,
                    ),
                ),
                (
                    "created_by",
                    models.ForeignKey(
                        default=None,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="+",
                        to="lamindb.user",
                    ),
                ),
                (
                    "feature",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="blocks",
                        to="lamindb.feature",
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name="ProjectBlock",
            fields=[
                (
                    "version",
                    lamindb.base.fields.CharField(
                        blank=True,
                        db_index=True,
                        default=None,
                        max_length=30,
                        null=True,
                    ),
                ),
                (
                    "is_latest",
                    lamindb.base.fields.BooleanField(
                        blank=True, db_index=True, default=True
                    ),
                ),
                ("id", models.BigAutoField(primary_key=True, serialize=False)),
                (
                    "uid",
                    models.CharField(
                        db_index=True, editable=False, max_length=20, unique=True
                    ),
                ),
                ("content", models.TextField()),
                ("hash", models.CharField(db_index=True, max_length=22, null=True)),
                (
                    "type",
                    models.CharField(
                        db_default="mdpage",
                        db_index=True,
                        default="mdpage",
                        max_length=22,
                    ),
                ),
                (
                    "vertical_pos",
                    models.SmallIntegerField(db_default=0, db_index=True, default=0),
                ),
                (
                    "created_at",
                    models.DateTimeField(
                        db_default=django.db.models.functions.datetime.Now(),
                        db_index=True,
                        editable=False,
                    ),
                ),
                (
                    "created_by",
                    models.ForeignKey(
                        default=None,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="+",
                        to="lamindb.user",
                    ),
                ),
                (
                    "project",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="blocks",
                        to="lamindb.project",
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name="RecordBlock",
            fields=[
                (
                    "version",
                    lamindb.base.fields.CharField(
                        blank=True,
                        db_index=True,
                        default=None,
                        max_length=30,
                        null=True,
                    ),
                ),
                (
                    "is_latest",
                    lamindb.base.fields.BooleanField(
                        blank=True, db_index=True, default=True
                    ),
                ),
                ("id", models.BigAutoField(primary_key=True, serialize=False)),
                (
                    "uid",
                    models.CharField(
                        db_index=True, editable=False, max_length=20, unique=True
                    ),
                ),
                ("content", models.TextField()),
                ("hash", models.CharField(db_index=True, max_length=22, null=True)),
                (
                    "type",
                    models.CharField(
                        db_default="mdpage",
                        db_index=True,
                        default="mdpage",
                        max_length=22,
                    ),
                ),
                (
                    "vertical_pos",
                    models.SmallIntegerField(db_default=0, db_index=True, default=0),
                ),
                (
                    "created_at",
                    models.DateTimeField(
                        db_default=django.db.models.functions.datetime.Now(),
                        db_index=True,
                        editable=False,
                    ),
                ),
                (
                    "created_by",
                    models.ForeignKey(
                        default=None,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="+",
                        to="lamindb.user",
                    ),
                ),
                (
                    "record",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="blocks",
                        to="lamindb.record",
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name="RootBlock",
            fields=[
                (
                    "version",
                    lamindb.base.fields.CharField(
                        blank=True,
                        db_index=True,
                        default=None,
                        max_length=30,
                        null=True,
                    ),
                ),
                (
                    "is_latest",
                    lamindb.base.fields.BooleanField(
                        blank=True, db_index=True, default=True
                    ),
                ),
                ("id", models.BigAutoField(primary_key=True, serialize=False)),
                (
                    "uid",
                    models.CharField(
                        db_index=True, editable=False, max_length=20, unique=True
                    ),
                ),
                ("content", models.TextField()),
                ("hash", models.CharField(db_index=True, max_length=22, null=True)),
                (
                    "type",
                    models.CharField(
                        db_default="mdpage",
                        db_index=True,
                        default="mdpage",
                        max_length=22,
                    ),
                ),
                (
                    "vertical_pos",
                    models.SmallIntegerField(db_default=0, db_index=True, default=0),
                ),
                (
                    "created_at",
                    models.DateTimeField(
                        db_default=django.db.models.functions.datetime.Now(),
                        db_index=True,
                        editable=False,
                    ),
                ),
                ("name", models.CharField(db_index=True, max_length=255)),
                (
                    "created_by",
                    models.ForeignKey(
                        default=None,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="+",
                        to="lamindb.user",
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name="RunBlock",
            fields=[
                (
                    "version",
                    lamindb.base.fields.CharField(
                        blank=True,
                        db_index=True,
                        default=None,
                        max_length=30,
                        null=True,
                    ),
                ),
                (
                    "is_latest",
                    lamindb.base.fields.BooleanField(
                        blank=True, db_index=True, default=True
                    ),
                ),
                ("id", models.BigAutoField(primary_key=True, serialize=False)),
                (
                    "uid",
                    models.CharField(
                        db_index=True, editable=False, max_length=20, unique=True
                    ),
                ),
                ("content", models.TextField()),
                ("hash", models.CharField(db_index=True, max_length=22, null=True)),
                (
                    "type",
                    models.CharField(
                        db_default="mdpage",
                        db_index=True,
                        default="mdpage",
                        max_length=22,
                    ),
                ),
                (
                    "vertical_pos",
                    models.SmallIntegerField(db_default=0, db_index=True, default=0),
                ),
                (
                    "created_at",
                    models.DateTimeField(
                        db_default=django.db.models.functions.datetime.Now(),
                        db_index=True,
                        editable=False,
                    ),
                ),
                (
                    "created_by",
                    models.ForeignKey(
                        default=None,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="+",
                        to="lamindb.user",
                    ),
                ),
                (
                    "run",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="blocks",
                        to="lamindb.run",
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name="SchemaBlock",
            fields=[
                (
                    "version",
                    lamindb.base.fields.CharField(
                        blank=True,
                        db_index=True,
                        default=None,
                        max_length=30,
                        null=True,
                    ),
                ),
                (
                    "is_latest",
                    lamindb.base.fields.BooleanField(
                        blank=True, db_index=True, default=True
                    ),
                ),
                ("id", models.BigAutoField(primary_key=True, serialize=False)),
                (
                    "uid",
                    models.CharField(
                        db_index=True, editable=False, max_length=20, unique=True
                    ),
                ),
                ("content", models.TextField()),
                ("hash", models.CharField(db_index=True, max_length=22, null=True)),
                (
                    "type",
                    models.CharField(
                        db_default="mdpage",
                        db_index=True,
                        default="mdpage",
                        max_length=22,
                    ),
                ),
                (
                    "vertical_pos",
                    models.SmallIntegerField(db_default=0, db_index=True, default=0),
                ),
                (
                    "created_at",
                    models.DateTimeField(
                        db_default=django.db.models.functions.datetime.Now(),
                        db_index=True,
                        editable=False,
                    ),
                ),
                (
                    "created_by",
                    models.ForeignKey(
                        default=None,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="+",
                        to="lamindb.user",
                    ),
                ),
                (
                    "schema",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="blocks",
                        to="lamindb.schema",
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name="SpaceBlock",
            fields=[
                (
                    "version",
                    lamindb.base.fields.CharField(
                        blank=True,
                        db_index=True,
                        default=None,
                        max_length=30,
                        null=True,
                    ),
                ),
                (
                    "is_latest",
                    lamindb.base.fields.BooleanField(
                        blank=True, db_index=True, default=True
                    ),
                ),
                ("id", models.BigAutoField(primary_key=True, serialize=False)),
                (
                    "uid",
                    models.CharField(
                        db_index=True, editable=False, max_length=20, unique=True
                    ),
                ),
                ("content", models.TextField()),
                ("hash", models.CharField(db_index=True, max_length=22, null=True)),
                (
                    "type",
                    models.CharField(
                        db_default="mdpage",
                        db_index=True,
                        default="mdpage",
                        max_length=22,
                    ),
                ),
                (
                    "vertical_pos",
                    models.SmallIntegerField(db_default=0, db_index=True, default=0),
                ),
                (
                    "created_at",
                    models.DateTimeField(
                        db_default=django.db.models.functions.datetime.Now(),
                        db_index=True,
                        editable=False,
                    ),
                ),
                (
                    "created_by",
                    models.ForeignKey(
                        default=None,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="+",
                        to="lamindb.user",
                    ),
                ),
                (
                    "space",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="blocks",
                        to="lamindb.space",
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name="TransformBlock",
            fields=[
                (
                    "version",
                    lamindb.base.fields.CharField(
                        blank=True,
                        db_index=True,
                        default=None,
                        max_length=30,
                        null=True,
                    ),
                ),
                (
                    "is_latest",
                    lamindb.base.fields.BooleanField(
                        blank=True, db_index=True, default=True
                    ),
                ),
                ("id", models.BigAutoField(primary_key=True, serialize=False)),
                (
                    "uid",
                    models.CharField(
                        db_index=True, editable=False, max_length=20, unique=True
                    ),
                ),
                ("content", models.TextField()),
                ("hash", models.CharField(db_index=True, max_length=22, null=True)),
                (
                    "type",
                    models.CharField(
                        db_default="mdpage",
                        db_index=True,
                        default="mdpage",
                        max_length=22,
                    ),
                ),
                (
                    "vertical_pos",
                    models.SmallIntegerField(db_default=0, db_index=True, default=0),
                ),
                (
                    "created_at",
                    models.DateTimeField(
                        db_default=django.db.models.functions.datetime.Now(),
                        db_index=True,
                        editable=False,
                    ),
                ),
                ("line_number", models.IntegerField(null=True)),
                (
                    "created_by",
                    models.ForeignKey(
                        default=None,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="+",
                        to="lamindb.user",
                    ),
                ),
                (
                    "transform",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="blocks",
                        to="lamindb.transform",
                    ),
                ),
            ],
        ),
    ]
