# Generated by Django 5.2 on 2025-10-20 15:33

import django.db.models.deletion
import django.db.models.functions.datetime
from django.db import migrations, models

import lamindb.base.fields
import lamindb.base.users
import lamindb.models.run
import lamindb.models.sqlrecord


class Migration(migrations.Migration):
    dependencies = [
        ("lamindb", "0136_remove_record_unique_name_type_space_and_more"),
    ]

    operations = [
        migrations.RemoveField(
            model_name="recordrecord",
            name="_aux",
        ),
        migrations.RemoveField(
            model_name="recordrecord",
            name="branch",
        ),
        migrations.RemoveField(
            model_name="recordrecord",
            name="is_locked",
        ),
        migrations.RemoveField(
            model_name="recordrecord",
            name="space",
        ),
        migrations.AddField(
            model_name="artifactrecord",
            name="created_at",
            field=lamindb.base.fields.DateTimeField(
                blank=True,
                db_default=django.db.models.functions.datetime.Now(),
                db_index=True,
                editable=False,
            ),
        ),
        migrations.AddField(
            model_name="artifactrecord",
            name="created_by",
            field=lamindb.base.fields.ForeignKey(
                blank=True,
                default=lamindb.base.users.current_user_id,
                editable=False,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="+",
                to="lamindb.user",
            ),
        ),
        migrations.AddField(
            model_name="artifactrecord",
            name="run",
            field=lamindb.base.fields.ForeignKey(
                blank=True,
                default=lamindb.models.run.current_run,
                null=True,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="+",
                to="lamindb.run",
            ),
        ),
        migrations.AlterField(
            model_name="recordrun",
            name="value",
            field=lamindb.base.fields.ForeignKey(
                blank=True,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="links_in_record",
                to="lamindb.run",
            ),
        ),
        migrations.CreateModel(
            name="RunRecord",
            fields=[
                ("id", models.BigAutoField(primary_key=True, serialize=False)),
                (
                    "created_at",
                    lamindb.base.fields.DateTimeField(
                        blank=True,
                        db_default=django.db.models.functions.datetime.Now(),
                        db_index=True,
                        editable=False,
                    ),
                ),
                (
                    "created_by",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        default=lamindb.base.users.current_user_id,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="lamindb.user",
                    ),
                ),
                (
                    "feature",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="links_runrecord",
                        to="lamindb.feature",
                    ),
                ),
                (
                    "record",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="links_run",
                        to="lamindb.record",
                    ),
                ),
                (
                    "run",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="links_record",
                        to="lamindb.run",
                    ),
                ),
            ],
            options={
                "unique_together": {("run", "record", "feature")},
            },
            bases=(models.Model, lamindb.models.sqlrecord.IsLink),
        ),
        migrations.AddField(
            model_name="record",
            name="runs",
            field=models.ManyToManyField(
                related_name="records", through="lamindb.RunRecord", to="lamindb.run"
            ),
        ),
        migrations.AlterField(
            model_name="record",
            name="linked_runs",
            field=models.ManyToManyField(
                related_name="linked_in_records",
                through="lamindb.RecordRun",
                to="lamindb.run",
            ),
        ),
    ]
