"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CompliantDynamoDb = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const services_1 = require("./services");
/**
 * Creates a DynamoDB table that is secured by an AWS backup plan und with point in time recovery
 * enabled by default.
 */
class CompliantDynamoDb extends aws_cdk_lib_1.aws_dynamodb.Table {
    constructor(scope, id, props) {
        super(scope, id, {
            ...props,
            encryption: services_1.getEncrytion(props),
            pointInTimeRecovery: services_1.getPitr(props),
            billingMode: services_1.getBillingMode(props),
        });
        services_1.createBackupPlan(this, props);
    }
}
exports.CompliantDynamoDb = CompliantDynamoDb;
_a = JSII_RTTI_SYMBOL_1;
CompliantDynamoDb[_a] = { fqn: "cdk-compliant-dynamodb.CompliantDynamoDb", version: "0.0.8" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW5kZXguanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi9zcmMvaW5kZXgudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7Ozs7QUFBQSw2Q0FBbUU7QUFFbkUseUNBS29CO0FBZ0NwQjs7O0dBR0c7QUFDSCxNQUFhLGlCQUFrQixTQUFRLDBCQUFZLENBQUMsS0FBSztJQUd2RCxZQUFZLEtBQWdCLEVBQUUsRUFBVSxFQUFFLEtBQTZCO1FBQ3JFLEtBQUssQ0FBQyxLQUFLLEVBQUUsRUFBRSxFQUFFO1lBQ2YsR0FBRyxLQUFLO1lBQ1IsVUFBVSxFQUFFLHVCQUFZLENBQUMsS0FBSyxDQUFDO1lBQy9CLG1CQUFtQixFQUFFLGtCQUFPLENBQUMsS0FBSyxDQUFDO1lBQ25DLFdBQVcsRUFBRSx5QkFBYyxDQUFDLEtBQUssQ0FBQztTQUNuQyxDQUFDLENBQUM7UUFFSCwyQkFBZ0IsQ0FBQyxJQUFJLEVBQUUsS0FBSyxDQUFDLENBQUM7SUFDaEMsQ0FBQzs7QUFaSCw4Q0FhQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IGF3c19iYWNrdXAsIGF3c19keW5hbW9kYiwgYXdzX2V2ZW50cyB9IGZyb20gJ2F3cy1jZGstbGliJztcbmltcG9ydCB7IENvbnN0cnVjdCB9IGZyb20gJ2NvbnN0cnVjdHMnO1xuaW1wb3J0IHtcbiAgZ2V0RW5jcnl0aW9uLFxuICBnZXRQaXRyLFxuICBnZXRCaWxsaW5nTW9kZSxcbiAgY3JlYXRlQmFja3VwUGxhbixcbn0gZnJvbSAnLi9zZXJ2aWNlcyc7XG5leHBvcnQgaW50ZXJmYWNlIENvbXBsaWFudER5bmFtb0RiUHJvcHMgZXh0ZW5kcyBhd3NfZHluYW1vZGIuVGFibGVQcm9wcyB7XG4gIC8qKlxuICAgKiBVc2UgYW4gZXhpc3RpbmcgQmFja3VwVmF1bHQgYW5kIGltcG9ydCBpdCBieSBuYW1lXG4gICAqIEBkZWZhdWx0IC0gY3JlYXRlIGEgbmV3IEJhY2t1cFZhdWx0XG4gICAqL1xuICByZWFkb25seSBiYWNrdXBWYXVsdE5hbWU/OiBzdHJpbmc7XG4gIC8qKlxuICAgKiBEYXlzIHVudGlsIHRoZSBiYWNrdXAgaXMgZGVsZXRlZCBmcm9tIHRoZSB2YXVsdFxuICAgKiBAZGVmYXVsdCAtIDM1IGRheXNcbiAgICovXG4gIHJlYWRvbmx5IGRlbGV0ZUJhY2t1cEFmdGVyRGF5cz86IG51bWJlcjtcbiAgLyoqXG4gICAqIEFXUyBDb25maWcgcnVsZXMgdGhhdCBJIHdhbnQgdG8gb3B0IG91dFxuICAgKiBAZGVmYXVsdCAtIHRhYmxlIGlzIGNvbXBsaWFudCBhZ2FpbnN0IGFsbCBydWxlc1xuICAgKlxuICAgKiBMaXN0IG9mIHJ1bGVzIHRvIG9wdCBvdXQ6XG4gICAqICAnQkFDS1VQX1JFQ09WRVJZX1BPSU5UX01BTlVBTF9ERUxFVElPTl9ESVNBQkxFRCcsXG4gICAgICAnRFlOQU1PREJfSU5fQkFDS1VQX1BMQU4nLFxuICAgICAgJ0RZTkFNT0RCX1BJVFJfRU5BQkxFRCcsXG4gICAgICAnRFlOQU1PREJfQVVUT1NDQUxJTkdfRU5BQkxFRCcsXG4gICAgICAnRFlOQU1PREJfVEhST1VHSFBVVF9MSU1JVF9DSEVDSycsXG4gICAgICAnRFlOQU1PREJfVEFCTEVfRU5DUllQVEVEX0tNUycsXG4gICAqL1xuICByZWFkb25seSBkaXNhYmxlZFJ1bGVzPzogc3RyaW5nW107XG4gIC8qKlxuICAgKiBUaW1lIHRvIHN0YXJ0IHRoZSBiYWNrdXBcbiAgICogQGRlZmF1bHQgLSA5cG1cbiAgICovXG4gIHJlYWRvbmx5IGJhY2t1cFBsYW5TdGFydFRpbWU/OiBhd3NfZXZlbnRzLlNjaGVkdWxlO1xufVxuXG4vKipcbiAqIENyZWF0ZXMgYSBEeW5hbW9EQiB0YWJsZSB0aGF0IGlzIHNlY3VyZWQgYnkgYW4gQVdTIGJhY2t1cCBwbGFuIHVuZCB3aXRoIHBvaW50IGluIHRpbWUgcmVjb3ZlcnlcbiAqIGVuYWJsZWQgYnkgZGVmYXVsdC5cbiAqL1xuZXhwb3J0IGNsYXNzIENvbXBsaWFudER5bmFtb0RiIGV4dGVuZHMgYXdzX2R5bmFtb2RiLlRhYmxlIHtcbiAgcmVhZG9ubHkgYmFja3VwUGxhbiE6IGF3c19iYWNrdXAuQmFja3VwUGxhbjtcbiAgcmVhZG9ubHkgYmFja3VwVmF1bHQhOiBhd3NfYmFja3VwLkJhY2t1cFZhdWx0O1xuICBjb25zdHJ1Y3RvcihzY29wZTogQ29uc3RydWN0LCBpZDogc3RyaW5nLCBwcm9wczogQ29tcGxpYW50RHluYW1vRGJQcm9wcykge1xuICAgIHN1cGVyKHNjb3BlLCBpZCwge1xuICAgICAgLi4ucHJvcHMsXG4gICAgICBlbmNyeXB0aW9uOiBnZXRFbmNyeXRpb24ocHJvcHMpLFxuICAgICAgcG9pbnRJblRpbWVSZWNvdmVyeTogZ2V0UGl0cihwcm9wcyksXG4gICAgICBiaWxsaW5nTW9kZTogZ2V0QmlsbGluZ01vZGUocHJvcHMpLFxuICAgIH0pO1xuXG4gICAgY3JlYXRlQmFja3VwUGxhbih0aGlzLCBwcm9wcyk7XG4gIH1cbn1cbiJdfQ==