# SPDX-License-Identifier: AGPL-3.0-or-later
# Copyright (C) 2022 Edith Coates
# Copyright (C) 2022 Brennen Chiu
# Copyright (C) 2023-2024 Andrew Rechnitzer
# Copyright (C) 2025 Colin B. Macdonald

"""Services of the Plom Server Scan app."""

from .scan_service import ScanService
from .cast_service import ScanCastService
from .image_process import PageImageProcessor
from .qr_service import QRService
from .image_rotate import ImageRotateService

from .hard_rotate import hard_rotate_image_from_file_by_exif_and_angle
from .util import (
    check_bundle_object_is_neither_locked_nor_pushed,
    check_any_bundle_push_locked,
    update_thumbnail_after_rotation,
)

from .manage_scan import ManageScanService
from .manage_discard import ManageDiscardService
