# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ....core.datetime_utils import serialize_datetime
from .problem_context import ProblemContext

try:
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class ProblemDetails(pydantic.BaseModel):
    message: str = pydantic.Field()
    """
    A short, display-friendly summary of the problem.
    """

    detail: typing.Optional[str] = pydantic.Field(default=None)
    """
    A display-friendly and more detailed explanation of the problem. It may offer additional contextual detail, but may also be just a generic description of the problem.
    """

    remediation: typing.Optional[str] = pydantic.Field(default=None)
    """
    A display-friendly explanation for how to remediate the problem. This field may be omitted in case there are multiple problems, each with its own remediation, or if no remediation is possible.
    """

    context: typing.Optional[ProblemContext] = pydantic.Field(default=None)
    """
    Additional context providing further detail about the problem, such as a problematic input parameter and/or a list of related resources.
    """

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        extra = pydantic.Extra.allow
        json_encoders = {dt.datetime: serialize_datetime}
