# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ..........core.datetime_utils import serialize_datetime
from ...base.types.url_string import UrlString
from .ticket_type_id import TicketTypeId

try:
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class Ticket(pydantic.BaseModel):
    """
    The Ticket object represents ticket in the customer's systems like Salesforce, jira etc.
    """

    src_url: typing.Optional[UrlString] = pydantic.Field(default=None)
    """
    The url of a ticket in the ticket system.
    """

    title: typing.Optional[str] = pydantic.Field(default=None)
    """
    The title of the ticket.
    """

    type: typing.Optional[str] = pydantic.Field(default=None)
    """
    The linked ticket type determines whether the ticket is internal or in an external ticketing system.
    """

    type_id: typing.Optional[TicketTypeId] = pydantic.Field(default=None)
    """
    The normalized identifier for the ticket type.
    """

    uid: typing.Optional[str] = pydantic.Field(default=None)
    """
    Unique ticket identifier like ticket id.
    """

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        extra = pydantic.Extra.allow
        json_encoders = {dt.datetime: serialize_datetime}
