# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ..........core.datetime_utils import serialize_datetime
from ...base.types.timestamp import Timestamp
from ...base.types.url_string import UrlString
from .advisory_install_state_id import AdvisoryInstallStateId
from .cve import Cve
from .cwe import Cwe
from .os import Os
from .product import Product
from .timespan import Timespan

try:
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class Advisory(pydantic.BaseModel):
    """
    The Advisory object represents publicly disclosed cybersecurity vulnerabilities defined in a Secruity advisory. e.g. <code> Microsoft KB Article, Apple Security Advisory</code>
    """

    avg_timespan: typing.Optional[Timespan] = pydantic.Field(default=None)
    """
    The average time to patch.
    """

    bulletin: typing.Optional[str] = pydantic.Field(default=None)
    """
    The Advisory bulletin identifier.
    """

    classification: typing.Optional[str] = pydantic.Field(default=None)
    """
    The vendors classification of the Advisory.
    """

    created_time: typing.Optional[Timestamp] = pydantic.Field(default=None)
    """
    The time when the Advisory record was created.
    """

    created_time_dt: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The time when the Advisory record was created.
    """

    desc: typing.Optional[str] = pydantic.Field(default=None)
    """
    A brief description of the Advisory Record.
    """

    install_state: typing.Optional[str] = pydantic.Field(default=None)
    """
    The install state of the Advisory.
    """

    install_state_id: typing.Optional[AdvisoryInstallStateId] = pydantic.Field(default=None)
    """
    The normalized install state ID of the Advisory.
    """

    is_superseded: typing.Optional[bool] = pydantic.Field(default=None)
    """
    The Advisory has been replaced by another.
    """

    modified_time: typing.Optional[Timestamp] = pydantic.Field(default=None)
    """
    The time when the Advisory record was last updated.
    """

    modified_time_dt: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The time when the Advisory record was last updated.
    """

    os: typing.Optional[Os] = pydantic.Field(default=None)
    """
    The operating system the Advisory applies to.
    """

    product: typing.Optional[Product] = pydantic.Field(default=None)
    """
    The product where the vulnerability was discovered.
    """

    references: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    A list of reference URLs with additional information about the vulnerabilities disclosed in the Advisory.
    """

    related_cves: typing.Optional[typing.List[Cve]] = pydantic.Field(default=None)
    """
    A list of Common Vulnerabilities and Exposures <a target='_blank' href='https://cve.mitre.org/'>(CVE)</a> identifiers related to the vulnerabilities disclosed in the Advisory.
    """

    related_cwes: typing.Optional[typing.List[Cwe]] = pydantic.Field(default=None)
    """
    A list of Common Weakness Enumeration <a target='_blank' href='https://cwe.mitre.org/'>(CWE)</a> identifiers related to the vulnerabilities disclosed in the Advisory.
    """

    size: typing.Optional[int] = pydantic.Field(default=None)
    """
    The size in bytes for the Advisory. Usually populated for a KB Article patch.
    """

    src_url: typing.Optional[UrlString] = pydantic.Field(default=None)
    """
    The Advisory link from the source vendor.
    """

    title: typing.Optional[str] = pydantic.Field(default=None)
    """
    A title or a brief phrase summarizing the Advisory.
    """

    uid: str = pydantic.Field()
    """
    The unique number assigned to the disclosed vulnerability.
    """

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        extra = pydantic.Extra.allow
        json_encoders = {dt.datetime: serialize_datetime}
