# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ..........core.datetime_utils import serialize_datetime
from .observable_type_id import ObservableTypeId
from .reputation import Reputation

try:
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class Observable(pydantic.BaseModel):
    """
    The observable object is a pivot element that contains related information found in many places in the event.
    """

    name: typing.Optional[str] = pydantic.Field(default=None)
    """
    The full name of the observable attribute. The <code>name</code> is a pointer/reference to an attribute within the OCSF event data. For example: <code>file.name</code>.
    """

    reputation: typing.Optional[Reputation] = pydantic.Field(default=None)
    """
    Contains the original and normalized reputation scores.
    """

    type: typing.Optional[str] = pydantic.Field(default=None)
    """
    The observable value type name.
    """

    type_id: ObservableTypeId = pydantic.Field()
    """
    The observable value type identifier.
    """

    value: typing.Optional[str] = pydantic.Field(default=None)
    """
    The value associated with the observable attribute. The meaning of the value depends on the observable type.<br/>If the <code>name</code> refers to a scalar attribute, then the <code>value</code> is the value of the attribute.<br/>If the <code>name</code> refers to an object attribute, then the <code>value</code> is not populated.
    """

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        extra = pydantic.Extra.allow
        json_encoders = {dt.datetime: serialize_datetime}
