# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ..........core.datetime_utils import serialize_datetime
from .policy import Policy

try:
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class Assessment(pydantic.BaseModel):
    """
    The Assessment object describes a point-in-time assessment, check, or evaluation of a specific configuration or signal against an asset, entity, person, or otherwise. For example, this can encapsulate <code>os_signals</code> from CrowdStrike Falcon Zero Trust Assessments, or account for <code>Datastore</code> configurations from Cyera, or capture details of Microsoft Intune configuration policies.
    """

    category: typing.Optional[str] = pydantic.Field(default=None)
    """
    The category that the assessment is part of. For example: <code>Prevention</code> or <code>Windows 10</code>.
    """

    desc: typing.Optional[str] = pydantic.Field(default=None)
    """
    The description of the assessment criteria, or a description of the specific configuration or signal the assessment is targeting.
    """

    meets_criteria: bool = pydantic.Field()
    """
    Determines whether the assessment against the specific configuration or signal meets the assessments criteria. For example, if the assessment checks if a <code>Datastore</code> is encrypted or not, having encryption would be evaluated as <code>true</code>.
    """

    name: typing.Optional[str] = pydantic.Field(default=None)
    """
    The name of the configuration or signal being assessed. For example: <code>Kernel Mode Code Integrity (KMCI)</code> or <code>publicAccessibilityState</code>.
    """

    policy: typing.Optional[Policy] = pydantic.Field(default=None)
    """
    The details of any policy associated with an assessment.
    """

    uid: typing.Optional[str] = pydantic.Field(default=None)
    """
    The unique identifier of the configuration or signal being assessed. For example: the <code>signal_id</code>.
    """

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        extra = pydantic.Extra.allow
        json_encoders = {dt.datetime: serialize_datetime}
