# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ..........core.datetime_utils import serialize_datetime

try:
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class Edge(pydantic.BaseModel):
    """
    Represents a connection or relationship between two nodes in a graph.
    """

    data: typing.Optional[typing.Any] = pydantic.Field(default=None)
    """
    Additional data about the edge such as weight, distance, or custom properties.
    """

    is_directed: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Indicates whether the edge is (<code>true</code>) or undirected (<code>false</code>).
    """

    name: typing.Optional[str] = pydantic.Field(default=None)
    """
    The human-readable name or label for the edge.
    """

    relation: typing.Optional[str] = pydantic.Field(default=None)
    """
    The type of relationship between nodes (e.g. is-attached-to , depends-on, etc).
    """

    source: str = pydantic.Field()
    """
    The unique identifier of the node where the edge originates.
    """

    target: str = pydantic.Field()
    """
    The unique identifier of the node where the edge terminates.
    """

    uid: typing.Optional[str] = pydantic.Field(default=None)
    """
    Unique identifier of the edge.
    """

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        extra = pydantic.Extra.allow
        json_encoders = {dt.datetime: serialize_datetime}
