# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ..........core.datetime_utils import serialize_datetime
from ...base.types.email_address import EmailAddress
from ...base.types.timestamp import Timestamp
from .key_value_object import KeyValueObject
from .location import Location
from .object import Object

try:
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class LdapPerson(pydantic.BaseModel):
    """
    The additional LDAP attributes that describe a person.
    """

    cost_center: typing.Optional[str] = pydantic.Field(default=None)
    """
    The cost center associated with the user.
    """

    created_time: typing.Optional[Timestamp] = pydantic.Field(default=None)
    """
    The timestamp when the user was created.
    """

    created_time_dt: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The timestamp when the user was created.
    """

    deleted_time: typing.Optional[Timestamp] = pydantic.Field(default=None)
    """
    The timestamp when the user was deleted. In Active Directory (AD), when a user is deleted they are moved to a temporary container and then removed after 30 days. So, this field can be populated even after a user is deleted for the next 30 days.
    """

    deleted_time_dt: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The timestamp when the user was deleted. In Active Directory (AD), when a user is deleted they are moved to a temporary container and then removed after 30 days. So, this field can be populated even after a user is deleted for the next 30 days.
    """

    display_name: typing.Optional[str] = pydantic.Field(default=None)
    """
    The display name of the LDAP person. According to RFC 2798, this is the preferred name of a person to be used when displaying entries.
    """

    email_addrs: typing.Optional[typing.List[EmailAddress]] = pydantic.Field(default=None)
    """
    A list of additional email addresses for the user.
    """

    employee_uid: typing.Optional[str] = pydantic.Field(default=None)
    """
    The employee identifier assigned to the user by the organization.
    """

    given_name: typing.Optional[str] = pydantic.Field(default=None)
    """
    The given or first name of the user.
    """

    hire_time: typing.Optional[Timestamp] = pydantic.Field(default=None)
    """
    The timestamp when the user was or will be hired by the organization.
    """

    hire_time_dt: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The timestamp when the user was or will be hired by the organization.
    """

    job_title: typing.Optional[str] = pydantic.Field(default=None)
    """
    The user's job title.
    """

    labels: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    The labels associated with the user. For example in AD this could be the <code>userType</code>, <code>employeeType</code>. For example: <code>Member, Employee</code>.
    """

    last_login_time: typing.Optional[Timestamp] = pydantic.Field(default=None)
    """
    The last time when the user logged in.
    """

    last_login_time_dt: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The last time when the user logged in.
    """

    ldap_cn: typing.Optional[str] = pydantic.Field(default=None)
    """
    The LDAP and X.500 <code>commonName</code> attribute, typically the full name of the person. For example, <code>John Doe</code>.
    """

    ldap_dn: typing.Optional[str] = pydantic.Field(default=None)
    """
    The X.500 Distinguished Name (DN) is a structured string that uniquely identifies an entry, such as a user, in an X.500 directory service For example, <code>cn=John Doe,ou=People,dc=example,dc=com</code>.
    """

    leave_time: typing.Optional[Timestamp] = pydantic.Field(default=None)
    """
    The timestamp when the user left or will be leaving the organization.
    """

    leave_time_dt: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The timestamp when the user left or will be leaving the organization.
    """

    location: typing.Optional[Location] = pydantic.Field(default=None)
    """
    The geographical location associated with a user. This is typically the user's usual work location.
    """

    manager: typing.Optional[Object] = pydantic.Field(default=None)
    """
    The user's manager. This helps in understanding an org hierarchy. This should only ever be populated once in an event. I.e. there should not be a manager's manager in an event.
    """

    modified_time: typing.Optional[Timestamp] = pydantic.Field(default=None)
    """
    The timestamp when the user entry was last modified.
    """

    modified_time_dt: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The timestamp when the user entry was last modified.
    """

    office_location: typing.Optional[str] = pydantic.Field(default=None)
    """
    The primary office location associated with the user. This could be any string and isn't a specific address. For example, <code>South East Virtual</code>.
    """

    phone_number: typing.Optional[str] = pydantic.Field(default=None)
    """
    The telephone number of the user. Corresponds to the LDAP <code>Telephone-Number</code> CN.
    """

    surname: typing.Optional[str] = pydantic.Field(default=None)
    """
    The last or family name for the user.
    """

    tags: typing.Optional[typing.List[KeyValueObject]] = pydantic.Field(default=None)
    """
    The list of tags; <code>{key:value}</code> pairs associated to the user.
    """

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        extra = pydantic.Extra.allow
        json_encoders = {dt.datetime: serialize_datetime}
