# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ..........core.datetime_utils import serialize_datetime

try:
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class LongString(pydantic.BaseModel):
    """
    This object is a used to capture strings which may be truncated by a security product due to their length.
    """

    is_truncated: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Indicates that <code>value</code> has been truncated. May be omitted if truncation has not occurred.
    """

    untruncated_size: typing.Optional[int] = pydantic.Field(default=None)
    """
    The size in bytes of the string represented by <code>value</code> before truncation. Should be omitted if truncation has not occurred.
    """

    value: str = pydantic.Field()
    """
    The string value, truncated if <code>is_truncated</code> is <code>true</code>.
    """

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        extra = pydantic.Extra.allow
        json_encoders = {dt.datetime: serialize_datetime}
