# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ..........core.datetime_utils import serialize_datetime
from ...base.types.file_path import FilePath
from .cve import Cve
from .file import File
from .malware_classification_ids import MalwareClassificationIds
from .malware_severity_id import MalwareSeverityId

try:
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class Malware(pydantic.BaseModel):
    """
    The Malware object describes the classification of known malicious software, which is intentionally designed to cause damage to a computer, server, client, or computer network.
    """

    classification_ids: typing.List[MalwareClassificationIds] = pydantic.Field()
    """
    The list of normalized identifiers of the malware classifications.
    """

    classifications: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    The list of malware classifications, normalized to the captions of the <code>classification_ids</code> values. In the case of 'Other', they are defined by the event source.
    """

    cves: typing.Optional[typing.List[Cve]] = pydantic.Field(default=None)
    """
    The list of Common Vulnerabilities and Exposures (CVE) identifiers associated with the malware. Reference: <a target='_blank' href='https://cve.mitre.org/'>CVE</a>
    """

    files: typing.Optional[typing.List[File]] = pydantic.Field(default=None)
    """
    The list of file objects representing files that were identified as infected by the malware.
    """

    name: typing.Optional[str] = pydantic.Field(default=None)
    """
    The malware name, as reported by the detection engine.
    """

    num_infected: typing.Optional[int] = pydantic.Field(default=None)
    """
    The number of files that were identified to be infected by the malware.
    """

    path: typing.Optional[FilePath] = pydantic.Field(default=None)
    """
    The filesystem path of the malware that was observed.
    """

    provider: typing.Optional[str] = pydantic.Field(default=None)
    """
    The name or identifier of the security solution or service that provided the malware detection information.
    """

    severity: typing.Optional[str] = pydantic.Field(default=None)
    """
    The severity of the malware, normalized to the captions of the <code>severity_id</code> values. In the case of 'Other', they are defined by the event source.
    """

    severity_id: typing.Optional[MalwareSeverityId] = pydantic.Field(default=None)
    """
    The normalized identifier of the malware severity.
    """

    uid: typing.Optional[str] = pydantic.Field(default=None)
    """
    A unique identifier for the specific malware instance, as assigned by the detection engine (e.g., virus signature ID or IPS rule ID).
    """

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        extra = pydantic.Extra.allow
        json_encoders = {dt.datetime: serialize_datetime}
