# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ..........core.datetime_utils import serialize_datetime
from .cis_control import CisControl
from .kb_article import KbArticle

try:
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class Remediation(pydantic.BaseModel):
    """
    The Remediation object describes the recommended remediation steps to address identified issue(s).
    """

    cis_controls: typing.Optional[typing.List[CisControl]] = pydantic.Field(default=None)
    """
    An array of Center for Internet Security (CIS) Controls that can be optionally mapped to provide additional remediation details.
    """

    desc: str = pydantic.Field()
    """
    The description of the remediation strategy.
    """

    kb_article_list: typing.Optional[typing.List[KbArticle]] = pydantic.Field(default=None)
    """
    A list of KB articles or patches related to an endpoint. A KB Article contains metadata that describes the patch or an update.
    """

    kb_articles: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    The KB article/s related to the entity. A KB Article contains metadata that describes the patch or an update.
    """

    references: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    A list of supporting URL/s, references that help describe the remediation strategy.
    """

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        extra = pydantic.Extra.allow
        json_encoders = {dt.datetime: serialize_datetime}
