# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ..........core.datetime_utils import serialize_datetime
from ...base.types.timestamp import Timestamp
from ...base.types.url_string import UrlString
from .scim_auth_protocol_id import ScimAuthProtocolId
from .scim_state_id import ScimStateId

try:
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class Scim(pydantic.BaseModel):
    """
    The System for Cross-domain Identity Management (SCIM) Configuration object provides a structured set of attributes related to SCIM protocols used for identity provisioning and management across cloud-based platforms. It standardizes user and group provisioning details, enabling identity synchronization and lifecycle management with compatible Identity Providers (IdPs) and applications. SCIM is defined in <a target='_blank' href='https://datatracker.ietf.org/doc/html/rfc7643'>RFC-7634</a>
    """

    auth_protocol: typing.Optional[str] = pydantic.Field(default=None)
    """
    The authorization protocol as defined by the caption of <code>auth_protocol_id</code>. In the case of <code>Other</code>, it is defined by the event source.
    """

    auth_protocol_id: typing.Optional[ScimAuthProtocolId] = pydantic.Field(default=None)
    """
    The normalized identifier of the authorization protocol used by the SCIM resource.
    """

    created_time: typing.Optional[Timestamp] = pydantic.Field(default=None)
    """
    When the SCIM resource was added to the service provider.
    """

    created_time_dt: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    When the SCIM resource was added to the service provider.
    """

    error_message: typing.Optional[str] = pydantic.Field(default=None)
    """
    Message or code associated with the last encountered error.
    """

    is_group_provisioning_enabled: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Indicates whether the SCIM resource is configured to provision groups, automatically or otherwise.
    """

    is_user_provisioning_enabled: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Indicates whether the SCIM resource is configured to provision users, automatically or otherwise.
    """

    last_run_time: typing.Optional[Timestamp] = pydantic.Field(default=None)
    """
    Timestamp of the most recent successful synchronization.
    """

    last_run_time_dt: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    Timestamp of the most recent successful synchronization.
    """

    modified_time: typing.Optional[Timestamp] = pydantic.Field(default=None)
    """
    The most recent time when the SCIM resource was updated at the service provider.
    """

    modified_time_dt: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The most recent time when the SCIM resource was updated at the service provider.
    """

    name: typing.Optional[str] = pydantic.Field(default=None)
    """
    The name of the SCIM resource.
    """

    protocol_name: typing.Optional[str] = pydantic.Field(default=None)
    """
    The supported protocol for the SCIM resource. E.g., <code>SAML</code>, <code>OIDC</code>, or <code>OAuth2</code>.
    """

    rate_limit: typing.Optional[int] = pydantic.Field(default=None)
    """
    Maximum number of requests allowed by the SCIM resource within a specified time frame to avoid throttling.
    """

    scim_group_schema: typing.Optional[typing.Any] = pydantic.Field(default=None)
    """
    SCIM provides a schema for representing groups, identified using the following schema URI: <code>urn:ietf:params:scim:schemas:core:2.0:Group</code> as defined in <a target='_blank' href='https://datatracker.ietf.org/doc/html/rfc7643'>RFC-7634</a>. This attribute will capture key-value pairs for the scheme implemented in a SCIM resource.
    """

    scim_user_schema: typing.Optional[typing.Any] = pydantic.Field(default=None)
    """
    SCIM provides a resource type for user resources. The core schema for user is identified using the following schema URI: <code>urn:ietf:params:scim:schemas:core:2.0:User</code> as defined in <a target='_blank' href='https://datatracker.ietf.org/doc/html/rfc7643'>RFC-7634</a>. his attribute will capture key-value pairs for the scheme implemented in a SCIM resource. This object is inclusive of both the basic and Enterprise User Schema Extension.
    """

    state: typing.Optional[str] = pydantic.Field(default=None)
    """
    The provisioning state of the SCIM resource, normalized to the caption of the <code>state_id</code> value. In the case of <code>Other</code>, it is defined by the event source.
    """

    state_id: typing.Optional[ScimStateId] = pydantic.Field(default=None)
    """
    The normalized state ID of the SCIM resource to reflect its activation status.
    """

    uid: typing.Optional[str] = pydantic.Field(default=None)
    """
    A unique identifier for a SCIM resource as defined by the service provider.
    """

    uid_alt: typing.Optional[str] = pydantic.Field(default=None)
    """
    A String that is an identifier for the resource as defined by the provisioning client. The <code>externalId</code> may simplify identification of a resource between the provisioning client and the service provider by allowing the client to use a filter to locate the resource with an identifier from the provisioning domain, obviating the need to store a local mapping between the provisioning domain's identifier of the resource and the identifier used by the service provider.
    """

    url_string: typing.Optional[UrlString] = pydantic.Field(default=None)
    """
    The primary URL for SCIM API requests.
    """

    vendor_name: typing.Optional[str] = pydantic.Field(default=None)
    """
    Name of the vendor or service provider implementing SCIM. E.g., <code>Okta</code>, <code>Auth0</code>, <code>Microsoft</code>.
    """

    version: typing.Optional[str] = pydantic.Field(default=None)
    """
    SCIM protocol version supported e.g., <code>SCIM 2.0</code>.
    """

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        extra = pydantic.Extra.allow
        json_encoders = {dt.datetime: serialize_datetime}
