# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ..........core.datetime_utils import serialize_datetime
from .vendor_attributes_severity_id import VendorAttributesSeverityId

try:
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class VendorAttributes(pydantic.BaseModel):
    """
    The Vendor Attributes object can be used to represent values of attributes populated by the Vendor/Finding Provider. It can help distinguish between the vendor-prodvided values and consumer-updated values, of key attributes like <code>severity_id</code>.<br>The original finding producer should not populate this object. It should be populated by consuming systems that support data mutability.
    """

    severity: typing.Optional[str] = pydantic.Field(default=None)
    """
    The finding severity, as reported by the Vendor (Finding Provider). The value should be normalized to the caption of the <code>severity_id</code> value. In the case of 'Other', it is defined by the source.
    """

    severity_id: typing.Optional[VendorAttributesSeverityId] = pydantic.Field(default=None)
    """
    The finding severity ID, as reported by the Vendor (Finding Provider).
    """

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        extra = pydantic.Extra.allow
        json_encoders = {dt.datetime: serialize_datetime}
