# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ....core.datetime_utils import serialize_datetime
from ...common.types.id import Id
from .async_operation_request_id import AsyncOperationRequestId
from .operation_error import OperationError
from .operation_input import OperationInput
from .operation_schedule import OperationSchedule
from .operation_status import OperationStatus

try:
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class Operation(pydantic.BaseModel):
    id: AsyncOperationRequestId = pydantic.Field()
    """
    ID of the operation
    """

    created_at: dt.datetime = pydantic.Field()
    """
    Time object was originally created
    """

    updated_at: dt.datetime = pydantic.Field()
    """
    Last time object was updated
    """

    account_id: Id = pydantic.Field()
    """
    Account ID containing the integration.
    """

    integration_id: Id = pydantic.Field()
    """
    Integration ID to use for the operation.
    """

    schedule: typing.Optional[OperationSchedule] = pydantic.Field(default=None)
    """
    Run now or on the specified schedule.
    """

    operation: str = pydantic.Field()
    """
    Name of the operation that will be run for this operation.
    """

    input: OperationInput = pydantic.Field()
    """
    Parameters for the operation that will be run for this operation.
    """

    status: OperationStatus = pydantic.Field()
    """
    Status of the operation
    """

    errors: typing.Optional[typing.List[OperationError]] = pydantic.Field(default=None)
    """
    Errors that occurred during the operation
    """

    cpu_time: int = pydantic.Field()
    """
    Cpu time in microseconds
    """

    in_bytes: int = pydantic.Field()
    """
    Number of bytes sent to sink integration
    """

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        extra = pydantic.Extra.allow
        json_encoders = {dt.datetime: serialize_datetime}
