# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ....core.datetime_utils import serialize_datetime
from ...common.types.id import Id

try:
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class AgentSummary(pydantic.BaseModel):
    """
    The agent summary object gives a summary of an agent in an escalation policy. An agent is a human that can be notified when certain conditions are met
    """

    id: Id = pydantic.Field()
    """
    Unique identifier for the agent.
    """

    name: str = pydantic.Field()
    """
    Name of the agent.
    """

    additional_properties: bool = pydantic.Field()
    """
    Indicates if the agent has additional properties that can be retrieved.
    """

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        extra = pydantic.Extra.allow
        json_encoders = {dt.datetime: serialize_datetime}
