# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ....core.datetime_utils import serialize_datetime
from ...common.types.id import Id

try:
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class GroupSummary(pydantic.BaseModel):
    """
    The group summary object gives a summary of a group in an escalation policy. A group is a collection of agents that can be notified when certain conditions are met
    """

    id: Id = pydantic.Field()
    """
    Unique identifier for the group.
    """

    name: typing.Optional[str] = pydantic.Field(default=None)
    """
    Name of the group.
    """

    additional_properties: bool = pydantic.Field()
    """
    Indicates if the group has additional properties that can be retrieved.
    """

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        extra = pydantic.Extra.allow
        json_encoders = {dt.datetime: serialize_datetime}
